// <auto-generated>
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for
// license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.
// </auto-generated>

namespace Microsoft.Azure.CognitiveServices.Vision.ComputerVision.Models
{
    using Microsoft.Rest;
    using Newtonsoft.Json;
    using System.Collections;
    using System.Collections.Generic;
    using System.Linq;

    /// <summary>
    /// An object representing a recognized text line.
    /// </summary>
    public partial class Line
    {
        /// <summary>
        /// Initializes a new instance of the Line class.
        /// </summary>
        public Line()
        {
            CustomInit();
        }

        /// <summary>
        /// Initializes a new instance of the Line class.
        /// </summary>
        /// <param name="boundingBox">Bounding box of a recognized
        /// line.</param>
        /// <param name="text">The text content of the line.</param>
        /// <param name="words">List of words in the text line.</param>
        /// <param name="language">The BCP-47 language code of the recognized
        /// text line. Only provided where the language of the line differs
        /// from the page's.</param>
        /// <param name="appearance">Appearance of the text line.</param>
        public Line(IList<double?> boundingBox, string text, IList<Word> words, string language = default(string), Appearance appearance = default(Appearance))
        {
            Language = language;
            BoundingBox = boundingBox;
            Appearance = appearance;
            Text = text;
            Words = words;
            CustomInit();
        }

        /// <summary>
        /// An initialization method that performs custom operations like setting defaults
        /// </summary>
        partial void CustomInit();

        /// <summary>
        /// Gets or sets the BCP-47 language code of the recognized text line.
        /// Only provided where the language of the line differs from the
        /// page's.
        /// </summary>
        [JsonProperty(PropertyName = "language")]
        public string Language { get; set; }

        /// <summary>
        /// Gets or sets bounding box of a recognized line.
        /// </summary>
        [JsonProperty(PropertyName = "boundingBox")]
        public IList<double?> BoundingBox { get; set; }

        /// <summary>
        /// Gets or sets appearance of the text line.
        /// </summary>
        [JsonProperty(PropertyName = "appearance")]
        public Appearance Appearance { get; set; }

        /// <summary>
        /// Gets or sets the text content of the line.
        /// </summary>
        [JsonProperty(PropertyName = "text")]
        public string Text { get; set; }

        /// <summary>
        /// Gets or sets list of words in the text line.
        /// </summary>
        [JsonProperty(PropertyName = "words")]
        public IList<Word> Words { get; set; }

        /// <summary>
        /// Validate the object.
        /// </summary>
        /// <exception cref="ValidationException">
        /// Thrown if validation fails
        /// </exception>
        public virtual void Validate()
        {
            if (BoundingBox == null)
            {
                throw new ValidationException(ValidationRules.CannotBeNull, "BoundingBox");
            }
            if (Text == null)
            {
                throw new ValidationException(ValidationRules.CannotBeNull, "Text");
            }
            if (Words == null)
            {
                throw new ValidationException(ValidationRules.CannotBeNull, "Words");
            }
            if (Appearance != null)
            {
                Appearance.Validate();
            }
            if (Words != null)
            {
                foreach (var element in Words)
                {
                    if (element != null)
                    {
                        element.Validate();
                    }
                }
            }
        }
    }
}
