// <auto-generated>
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for
// license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.
// </auto-generated>

namespace Microsoft.Azure.CognitiveServices.Vision.ComputerVision.Models
{
    using Newtonsoft.Json;
    using System.Collections;
    using System.Collections.Generic;
    using System.Linq;

    /// <summary>
    /// Result of AnalyzeImage operation.
    /// </summary>
    public partial class ImageAnalysis
    {
        /// <summary>
        /// Initializes a new instance of the ImageAnalysis class.
        /// </summary>
        public ImageAnalysis()
        {
            CustomInit();
        }

        /// <summary>
        /// Initializes a new instance of the ImageAnalysis class.
        /// </summary>
        /// <param name="categories">An array indicating identified
        /// categories.</param>
        /// <param name="adult">An object describing whether the image contains
        /// adult-oriented content and/or is racy.</param>
        /// <param name="color">An object providing additional metadata
        /// describing color attributes.</param>
        /// <param name="imageType">An object providing possible image types
        /// and matching confidence levels.</param>
        /// <param name="tags">A list of tags with confidence level.</param>
        /// <param name="description">A collection of content tags, along with
        /// a list of captions sorted by confidence level, and image
        /// metadata.</param>
        /// <param name="faces">An array of possible faces within the
        /// image.</param>
        /// <param name="objects">Array of objects describing what was detected
        /// in the image.</param>
        /// <param name="brands">Array of brands detected in the image.</param>
        /// <param name="requestId">Id of the REST API request.</param>
        public ImageAnalysis(IList<Category> categories = default(IList<Category>), AdultInfo adult = default(AdultInfo), ColorInfo color = default(ColorInfo), ImageType imageType = default(ImageType), IList<ImageTag> tags = default(IList<ImageTag>), ImageDescriptionDetails description = default(ImageDescriptionDetails), IList<FaceDescription> faces = default(IList<FaceDescription>), IList<DetectedObject> objects = default(IList<DetectedObject>), IList<DetectedBrand> brands = default(IList<DetectedBrand>), string requestId = default(string), ImageMetadata metadata = default(ImageMetadata), string modelVersion = default(string))
        {
            Categories = categories;
            Adult = adult;
            Color = color;
            ImageType = imageType;
            Tags = tags;
            Description = description;
            Faces = faces;
            Objects = objects;
            Brands = brands;
            RequestId = requestId;
            Metadata = metadata;
            ModelVersion = modelVersion;
            CustomInit();
        }

        /// <summary>
        /// An initialization method that performs custom operations like setting defaults
        /// </summary>
        partial void CustomInit();

        /// <summary>
        /// Gets or sets an array indicating identified categories.
        /// </summary>
        [JsonProperty(PropertyName = "categories")]
        public IList<Category> Categories { get; set; }

        /// <summary>
        /// Gets or sets an object describing whether the image contains
        /// adult-oriented content and/or is racy.
        /// </summary>
        [JsonProperty(PropertyName = "adult")]
        public AdultInfo Adult { get; set; }

        /// <summary>
        /// Gets or sets an object providing additional metadata describing
        /// color attributes.
        /// </summary>
        [JsonProperty(PropertyName = "color")]
        public ColorInfo Color { get; set; }

        /// <summary>
        /// Gets or sets an object providing possible image types and matching
        /// confidence levels.
        /// </summary>
        [JsonProperty(PropertyName = "imageType")]
        public ImageType ImageType { get; set; }

        /// <summary>
        /// Gets or sets a list of tags with confidence level.
        /// </summary>
        [JsonProperty(PropertyName = "tags")]
        public IList<ImageTag> Tags { get; set; }

        /// <summary>
        /// Gets or sets a collection of content tags, along with a list of
        /// captions sorted by confidence level, and image metadata.
        /// </summary>
        [JsonProperty(PropertyName = "description")]
        public ImageDescriptionDetails Description { get; set; }

        /// <summary>
        /// Gets or sets an array of possible faces within the image.
        /// </summary>
        [JsonProperty(PropertyName = "faces")]
        public IList<FaceDescription> Faces { get; set; }

        /// <summary>
        /// Gets or sets array of objects describing what was detected in the
        /// image.
        /// </summary>
        [JsonProperty(PropertyName = "objects")]
        public IList<DetectedObject> Objects { get; set; }

        /// <summary>
        /// Gets or sets array of brands detected in the image.
        /// </summary>
        [JsonProperty(PropertyName = "brands")]
        public IList<DetectedBrand> Brands { get; set; }

        /// <summary>
        /// Gets or sets id of the REST API request.
        /// </summary>
        [JsonProperty(PropertyName = "requestId")]
        public string RequestId { get; set; }

        /// <summary>
        /// </summary>
        [JsonProperty(PropertyName = "metadata")]
        public ImageMetadata Metadata { get; set; }

        /// <summary>
        /// </summary>
        [JsonProperty(PropertyName = "modelVersion")]
        public string ModelVersion { get; set; }

    }
}
