// <auto-generated>
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for
// license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.
// </auto-generated>

namespace Microsoft.Azure.CognitiveServices.Vision.ComputerVision.Models
{
    using Newtonsoft.Json;
    using System.Linq;

    /// <summary>
    /// A brand detected in an image.
    /// </summary>
    public partial class DetectedBrand
    {
        /// <summary>
        /// Initializes a new instance of the DetectedBrand class.
        /// </summary>
        public DetectedBrand()
        {
            CustomInit();
        }

        /// <summary>
        /// Initializes a new instance of the DetectedBrand class.
        /// </summary>
        /// <param name="name">Label for the brand.</param>
        /// <param name="confidence">Confidence score of having observed the
        /// brand in the image, as a value ranging from 0 to 1.</param>
        /// <param name="rectangle">Approximate location of the detected
        /// brand.</param>
        public DetectedBrand(string name = default(string), double confidence = default(double), BoundingRect rectangle = default(BoundingRect))
        {
            Name = name;
            Confidence = confidence;
            Rectangle = rectangle;
            CustomInit();
        }

        /// <summary>
        /// An initialization method that performs custom operations like setting defaults
        /// </summary>
        partial void CustomInit();

        /// <summary>
        /// Gets label for the brand.
        /// </summary>
        [JsonProperty(PropertyName = "name")]
        public string Name { get; private set; }

        /// <summary>
        /// Gets confidence score of having observed the brand in the image, as
        /// a value ranging from 0 to 1.
        /// </summary>
        [JsonProperty(PropertyName = "confidence")]
        public double Confidence { get; private set; }

        /// <summary>
        /// Gets approximate location of the detected brand.
        /// </summary>
        [JsonProperty(PropertyName = "rectangle")]
        public BoundingRect Rectangle { get; private set; }

    }
}
