// <auto-generated>
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for
// license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.
// </auto-generated>

namespace Microsoft.Azure.CognitiveServices.Vision.ComputerVision.Models
{
    using Newtonsoft.Json;
    using System.Collections;
    using System.Collections.Generic;
    using System.Linq;

    /// <summary>
    /// An object providing additional metadata describing color attributes.
    /// </summary>
    public partial class ColorInfo
    {
        /// <summary>
        /// Initializes a new instance of the ColorInfo class.
        /// </summary>
        public ColorInfo()
        {
            CustomInit();
        }

        /// <summary>
        /// Initializes a new instance of the ColorInfo class.
        /// </summary>
        /// <param name="dominantColorForeground">Possible dominant foreground
        /// color.</param>
        /// <param name="dominantColorBackground">Possible dominant background
        /// color.</param>
        /// <param name="dominantColors">An array of possible dominant
        /// colors.</param>
        /// <param name="accentColor">Possible accent color.</param>
        /// <param name="isBWImg">A value indicating if the image is black and
        /// white.</param>
        public ColorInfo(string dominantColorForeground = default(string), string dominantColorBackground = default(string), IList<string> dominantColors = default(IList<string>), string accentColor = default(string), bool isBWImg = default(bool))
        {
            DominantColorForeground = dominantColorForeground;
            DominantColorBackground = dominantColorBackground;
            DominantColors = dominantColors;
            AccentColor = accentColor;
            IsBWImg = isBWImg;
            CustomInit();
        }

        /// <summary>
        /// An initialization method that performs custom operations like setting defaults
        /// </summary>
        partial void CustomInit();

        /// <summary>
        /// Gets or sets possible dominant foreground color.
        /// </summary>
        [JsonProperty(PropertyName = "dominantColorForeground")]
        public string DominantColorForeground { get; set; }

        /// <summary>
        /// Gets or sets possible dominant background color.
        /// </summary>
        [JsonProperty(PropertyName = "dominantColorBackground")]
        public string DominantColorBackground { get; set; }

        /// <summary>
        /// Gets or sets an array of possible dominant colors.
        /// </summary>
        [JsonProperty(PropertyName = "dominantColors")]
        public IList<string> DominantColors { get; set; }

        /// <summary>
        /// Gets or sets possible accent color.
        /// </summary>
        [JsonProperty(PropertyName = "accentColor")]
        public string AccentColor { get; set; }

        /// <summary>
        /// Gets or sets a value indicating if the image is black and white.
        /// </summary>
        [JsonProperty(PropertyName = "isBWImg")]
        public bool IsBWImg { get; set; }

    }
}
