// <auto-generated>
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for
// license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.
// </auto-generated>

namespace Microsoft.Azure.CognitiveServices.Vision.ComputerVision.Models
{
    using Microsoft.Rest;
    using Newtonsoft.Json;
    using System.Collections;
    using System.Collections.Generic;
    using System.Linq;

    /// <summary>
    /// Analyze batch operation result.
    /// </summary>
    public partial class AnalyzeResults
    {
        /// <summary>
        /// Initializes a new instance of the AnalyzeResults class.
        /// </summary>
        public AnalyzeResults()
        {
            CustomInit();
        }

        /// <summary>
        /// Initializes a new instance of the AnalyzeResults class.
        /// </summary>
        /// <param name="version">Version of schema used for this
        /// result.</param>
        /// <param name="modelVersion">Version of the OCR model used for text
        /// extraction.</param>
        /// <param name="readResults">Text extracted from the input.</param>
        public AnalyzeResults(string version, string modelVersion, IList<ReadResult> readResults)
        {
            Version = version;
            ModelVersion = modelVersion;
            ReadResults = readResults;
            CustomInit();
        }

        /// <summary>
        /// An initialization method that performs custom operations like setting defaults
        /// </summary>
        partial void CustomInit();

        /// <summary>
        /// Gets or sets version of schema used for this result.
        /// </summary>
        [JsonProperty(PropertyName = "version")]
        public string Version { get; set; }

        /// <summary>
        /// Gets or sets version of the OCR model used for text extraction.
        /// </summary>
        [JsonProperty(PropertyName = "modelVersion")]
        public string ModelVersion { get; set; }

        /// <summary>
        /// Gets or sets text extracted from the input.
        /// </summary>
        [JsonProperty(PropertyName = "readResults")]
        public IList<ReadResult> ReadResults { get; set; }

        /// <summary>
        /// Validate the object.
        /// </summary>
        /// <exception cref="ValidationException">
        /// Thrown if validation fails
        /// </exception>
        public virtual void Validate()
        {
            if (Version == null)
            {
                throw new ValidationException(ValidationRules.CannotBeNull, "Version");
            }
            if (ModelVersion == null)
            {
                throw new ValidationException(ValidationRules.CannotBeNull, "ModelVersion");
            }
            if (ReadResults == null)
            {
                throw new ValidationException(ValidationRules.CannotBeNull, "ReadResults");
            }
            if (ModelVersion != null)
            {
                if (!System.Text.RegularExpressions.Regex.IsMatch(ModelVersion, "^(latest|\\d{4}-\\d{2}-\\d{2})(-preview)?$"))
                {
                    throw new ValidationException(ValidationRules.Pattern, "ModelVersion", "^(latest|\\d{4}-\\d{2}-\\d{2})(-preview)?$");
                }
            }
            if (ReadResults != null)
            {
                foreach (var element in ReadResults)
                {
                    if (element != null)
                    {
                        element.Validate();
                    }
                }
            }
        }
    }
}
