// <auto-generated>
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for
// license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.
// </auto-generated>

namespace Microsoft.Azure.CognitiveServices.Vision.ComputerVision.Models
{
    using Newtonsoft.Json;
    using System.Linq;

    /// <summary>
    /// An object describing whether the image contains adult-oriented content
    /// and/or is racy.
    /// </summary>
    public partial class AdultInfo
    {
        /// <summary>
        /// Initializes a new instance of the AdultInfo class.
        /// </summary>
        public AdultInfo()
        {
            CustomInit();
        }

        /// <summary>
        /// Initializes a new instance of the AdultInfo class.
        /// </summary>
        /// <param name="isAdultContent">A value indicating if the image
        /// contains adult-oriented content.</param>
        /// <param name="isRacyContent">A value indicating if the image is
        /// racy.</param>
        /// <param name="isGoryContent">A value indicating if the image is
        /// gory.</param>
        /// <param name="adultScore">Score from 0 to 1 that indicates how much
        /// the content is considered adult-oriented within the image.</param>
        /// <param name="racyScore">Score from 0 to 1 that indicates how
        /// suggestive is the image.</param>
        /// <param name="goreScore">Score from 0 to 1 that indicates how gory
        /// is the image.</param>
        public AdultInfo(bool isAdultContent = default(bool), bool isRacyContent = default(bool), bool isGoryContent = default(bool), double adultScore = default(double), double racyScore = default(double), double goreScore = default(double))
        {
            IsAdultContent = isAdultContent;
            IsRacyContent = isRacyContent;
            IsGoryContent = isGoryContent;
            AdultScore = adultScore;
            RacyScore = racyScore;
            GoreScore = goreScore;
            CustomInit();
        }

        /// <summary>
        /// An initialization method that performs custom operations like setting defaults
        /// </summary>
        partial void CustomInit();

        /// <summary>
        /// Gets or sets a value indicating if the image contains
        /// adult-oriented content.
        /// </summary>
        [JsonProperty(PropertyName = "isAdultContent")]
        public bool IsAdultContent { get; set; }

        /// <summary>
        /// Gets or sets a value indicating if the image is racy.
        /// </summary>
        [JsonProperty(PropertyName = "isRacyContent")]
        public bool IsRacyContent { get; set; }

        /// <summary>
        /// Gets or sets a value indicating if the image is gory.
        /// </summary>
        [JsonProperty(PropertyName = "isGoryContent")]
        public bool IsGoryContent { get; set; }

        /// <summary>
        /// Gets or sets score from 0 to 1 that indicates how much the content
        /// is considered adult-oriented within the image.
        /// </summary>
        [JsonProperty(PropertyName = "adultScore")]
        public double AdultScore { get; set; }

        /// <summary>
        /// Gets or sets score from 0 to 1 that indicates how suggestive is the
        /// image.
        /// </summary>
        [JsonProperty(PropertyName = "racyScore")]
        public double RacyScore { get; set; }

        /// <summary>
        /// Gets or sets score from 0 to 1 that indicates how gory is the
        /// image.
        /// </summary>
        [JsonProperty(PropertyName = "goreScore")]
        public double GoreScore { get; set; }

    }
}
