// <auto-generated>
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for
// license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.
// </auto-generated>

namespace Microsoft.Azure.CognitiveServices.Vision.ComputerVision
{
    using Microsoft.Rest;
    using Models;
    using Newtonsoft.Json;
    using System.Collections;
    using System.Collections.Generic;
    using System.IO;
    using System.Threading;
    using System.Threading.Tasks;

    /// <summary>
    /// The Computer Vision API provides state-of-the-art algorithms to process
    /// images and return information. For example, it can be used to determine
    /// if an image contains mature content, or it can be used to find all the
    /// faces in an image.  It also has other features like estimating dominant
    /// and accent colors, categorizing the content of images, and describing
    /// an image with complete English sentences.  Additionally, it can also
    /// intelligently generate images thumbnails for displaying large images
    /// effectively.
    /// </summary>
    public partial interface IComputerVisionClient : System.IDisposable
    {
        /// <summary>
        /// The base URI of the service.
        /// </summary>

        /// <summary>
        /// Gets or sets json serialization settings.
        /// </summary>
        JsonSerializerSettings SerializationSettings { get; }

        /// <summary>
        /// Gets or sets json deserialization settings.
        /// </summary>
        JsonSerializerSettings DeserializationSettings { get; }

        /// <summary>
        /// Supported Cognitive Services endpoints.
        /// </summary>
        string Endpoint { get; set; }

        /// <summary>
        /// Subscription credentials which uniquely identify client
        /// subscription.
        /// </summary>
        ServiceClientCredentials Credentials { get; }


        /// <summary>
        /// This operation extracts a rich set of visual features based on the
        /// image content.
        /// Two input methods are supported -- (1) Uploading an image or (2)
        /// specifying an image URL. Within your request, there is an optional
        /// parameter to allow you to choose which features to return. By
        /// default, image categories are returned in the response.
        /// A successful response will be returned in JSON. If the request
        /// failed, the response will contain an error code and a message to
        /// help understand what went wrong.
        /// </summary>
        /// <param name='url'>
        /// Publicly reachable URL of an image.
        /// </param>
        /// <param name='visualFeatures'>
        /// A string indicating what visual feature types to return. Multiple
        /// values should be comma-separated. Valid visual feature types
        /// include: Categories - categorizes image content according to a
        /// taxonomy defined in documentation. Tags - tags the image with a
        /// detailed list of words related to the image content. Description -
        /// describes the image content with a complete English sentence. Faces
        /// - detects if faces are present. If present, generate coordinates,
        /// gender and age. ImageType - detects if image is clipart or a line
        /// drawing. Color - determines the accent color, dominant color, and
        /// whether an image is black&amp;white. Adult - detects if the image
        /// is pornographic in nature (depicts nudity or a sex act), or is gory
        /// (depicts extreme violence or blood). Sexually suggestive content
        /// (aka racy content) is also detected. Objects - detects various
        /// objects within an image, including the approximate location. The
        /// Objects argument is only available in English. Brands - detects
        /// various brands within an image, including the approximate location.
        /// The Brands argument is only available in English.
        /// </param>
        /// <param name='details'>
        /// A string indicating which domain-specific details to return.
        /// Multiple values should be comma-separated. Valid visual feature
        /// types include: Celebrities - identifies celebrities if detected in
        /// the image, Landmarks - identifies notable landmarks in the image.
        /// </param>
        /// <param name='language'>
        /// The desired language for output generation. If this parameter is
        /// not specified, the default value is "en". See
        /// https://aka.ms/cv-languages for list of supported languages.
        /// Possible values include: 'ar', 'az', 'bg', 'bs', 'ca', 'cs', 'cy',
        /// 'da', 'de', 'el', 'en', 'es', 'et', 'eu', 'fi', 'fr', 'ga', 'gl',
        /// 'he', 'hi', 'hr', 'hu', 'id', 'it', 'ja', 'kk', 'ko', 'lt', 'lv',
        /// 'mk', 'ms', 'nb', 'nl', 'pl', 'prs', 'pt', 'pt-BR', 'pt-PT', 'ro',
        /// 'ru', 'sk', 'sl', 'sr-Cyrl', 'sr-Latn', 'sv', 'th', 'tr', 'uk',
        /// 'vi', 'zh', 'zh-Hans', 'zh-Hant'
        /// </param>
        /// <param name='descriptionExclude'>
        /// Turn off specified domain models when generating the description.
        /// </param>
        /// <param name='modelVersion'>
        /// Optional parameter to specify the version of the AI model. Accepted
        /// values are: "latest", "2021-04-01", "2021-05-01". Defaults to
        /// "latest".
        /// </param>
        /// <param name='customHeaders'>
        /// The headers that will be added to request.
        /// </param>
        /// <param name='cancellationToken'>
        /// The cancellation token.
        /// </param>
        Task<HttpOperationResponse<ImageAnalysis>> AnalyzeImageWithHttpMessagesAsync(string url, IList<VisualFeatureTypes?> visualFeatures = default(IList<VisualFeatureTypes?>), IList<Details?> details = default(IList<Details?>), string language = default(string), IList<DescriptionExclude?> descriptionExclude = default(IList<DescriptionExclude?>), string modelVersion = "latest", Dictionary<string, List<string>> customHeaders = null, CancellationToken cancellationToken = default(CancellationToken));

        /// <summary>
        /// This operation generates a description of an image in human
        /// readable language with complete sentences. The description is based
        /// on a collection of content tags, which are also returned by the
        /// operation. More than one description can be generated for each
        /// image. Descriptions are ordered by their confidence score.
        /// Descriptions may include results from celebrity and landmark domain
        /// models, if applicable.
        /// Two input methods are supported -- (1) Uploading an image or (2)
        /// specifying an image URL.
        /// A successful response will be returned in JSON. If the request
        /// failed, the response will contain an error code and a message to
        /// help understand what went wrong.
        /// </summary>
        /// <param name='url'>
        /// Publicly reachable URL of an image.
        /// </param>
        /// <param name='maxCandidates'>
        /// Maximum number of candidate descriptions to be returned.  The
        /// default is 1.
        /// </param>
        /// <param name='language'>
        /// The desired language for output generation. If this parameter is
        /// not specified, the default value is "en". See
        /// https://aka.ms/cv-languages for list of supported languages.
        /// Possible values include: 'ar', 'az', 'bg', 'bs', 'ca', 'cs', 'cy',
        /// 'da', 'de', 'el', 'en', 'es', 'et', 'eu', 'fi', 'fr', 'ga', 'gl',
        /// 'he', 'hi', 'hr', 'hu', 'id', 'it', 'ja', 'kk', 'ko', 'lt', 'lv',
        /// 'mk', 'ms', 'nb', 'nl', 'pl', 'prs', 'pt', 'pt-BR', 'pt-PT', 'ro',
        /// 'ru', 'sk', 'sl', 'sr-Cyrl', 'sr-Latn', 'sv', 'th', 'tr', 'uk',
        /// 'vi', 'zh', 'zh-Hans', 'zh-Hant'
        /// </param>
        /// <param name='descriptionExclude'>
        /// Turn off specified domain models when generating the description.
        /// </param>
        /// <param name='modelVersion'>
        /// Optional parameter to specify the version of the AI model. Accepted
        /// values are: "latest", "2021-04-01", "2021-05-01". Defaults to
        /// "latest".
        /// </param>
        /// <param name='customHeaders'>
        /// The headers that will be added to request.
        /// </param>
        /// <param name='cancellationToken'>
        /// The cancellation token.
        /// </param>
        Task<HttpOperationResponse<ImageDescription>> DescribeImageWithHttpMessagesAsync(string url, int? maxCandidates = 1, string language = default(string), IList<DescriptionExclude?> descriptionExclude = default(IList<DescriptionExclude?>), string modelVersion = "latest", Dictionary<string, List<string>> customHeaders = null, CancellationToken cancellationToken = default(CancellationToken));

        /// <summary>
        /// Performs object detection on the specified image.
        /// Two input methods are supported -- (1) Uploading an image or (2)
        /// specifying an image URL.
        /// A successful response will be returned in JSON. If the request
        /// failed, the response will contain an error code and a message to
        /// help understand what went wrong.
        /// </summary>
        /// <param name='url'>
        /// Publicly reachable URL of an image.
        /// </param>
        /// <param name='modelVersion'>
        /// Optional parameter to specify the version of the AI model. Accepted
        /// values are: "latest", "2021-04-01", "2021-05-01". Defaults to
        /// "latest".
        /// </param>
        /// <param name='customHeaders'>
        /// The headers that will be added to request.
        /// </param>
        /// <param name='cancellationToken'>
        /// The cancellation token.
        /// </param>
        Task<HttpOperationResponse<DetectResult>> DetectObjectsWithHttpMessagesAsync(string url, string modelVersion = "latest", Dictionary<string, List<string>> customHeaders = null, CancellationToken cancellationToken = default(CancellationToken));

        /// <summary>
        /// This operation returns the list of domain-specific models that are
        /// supported by the Computer Vision API. Currently, the API supports
        /// following domain-specific models: celebrity recognizer, landmark
        /// recognizer.
        /// A successful response will be returned in JSON. If the request
        /// failed, the response will contain an error code and a message to
        /// help understand what went wrong.
        /// </summary>
        /// <param name='customHeaders'>
        /// The headers that will be added to request.
        /// </param>
        /// <param name='cancellationToken'>
        /// The cancellation token.
        /// </param>
        Task<HttpOperationResponse<ListModelsResult>> ListModelsWithHttpMessagesAsync(Dictionary<string, List<string>> customHeaders = null, CancellationToken cancellationToken = default(CancellationToken));

        /// <summary>
        /// This operation recognizes content within an image by applying a
        /// domain-specific model. The list of domain-specific models that are
        /// supported by the Computer Vision API can be retrieved using the
        /// /models GET request. Currently, the API provides following
        /// domain-specific models: celebrities, landmarks.
        /// Two input methods are supported -- (1) Uploading an image or (2)
        /// specifying an image URL.
        /// A successful response will be returned in JSON.
        /// If the request failed, the response will contain an error code and
        /// a message to help understand what went wrong.
        /// </summary>
        /// <param name='model'>
        /// The domain-specific content to recognize.
        /// </param>
        /// <param name='url'>
        /// Publicly reachable URL of an image.
        /// </param>
        /// <param name='language'>
        /// The desired language for output generation. If this parameter is
        /// not specified, the default value is "en". See
        /// https://aka.ms/cv-languages for list of supported languages.
        /// Possible values include: 'ar', 'az', 'bg', 'bs', 'ca', 'cs', 'cy',
        /// 'da', 'de', 'el', 'en', 'es', 'et', 'eu', 'fi', 'fr', 'ga', 'gl',
        /// 'he', 'hi', 'hr', 'hu', 'id', 'it', 'ja', 'kk', 'ko', 'lt', 'lv',
        /// 'mk', 'ms', 'nb', 'nl', 'pl', 'prs', 'pt', 'pt-BR', 'pt-PT', 'ro',
        /// 'ru', 'sk', 'sl', 'sr-Cyrl', 'sr-Latn', 'sv', 'th', 'tr', 'uk',
        /// 'vi', 'zh', 'zh-Hans', 'zh-Hant'
        /// </param>
        /// <param name='modelVersion'>
        /// Optional parameter to specify the version of the AI model. Accepted
        /// values are: "latest", "2021-04-01", "2021-05-01". Defaults to
        /// "latest".
        /// </param>
        /// <param name='customHeaders'>
        /// The headers that will be added to request.
        /// </param>
        /// <param name='cancellationToken'>
        /// The cancellation token.
        /// </param>
        Task<HttpOperationResponse<DomainModelResults>> AnalyzeImageByDomainWithHttpMessagesAsync(string model, string url, string language = default(string), string modelVersion = "latest", Dictionary<string, List<string>> customHeaders = null, CancellationToken cancellationToken = default(CancellationToken));

        /// <summary>
        /// Optical Character Recognition (OCR) detects text in an image and
        /// extracts the recognized characters into a machine-usable character
        /// stream.
        /// Upon success, the OCR results will be returned.
        /// Upon failure, the error code together with an error message will be
        /// returned. The error code can be one of InvalidImageUrl,
        /// InvalidImageFormat, InvalidImageSize, NotSupportedImage,
        /// NotSupportedLanguage, or InternalServerError.
        /// </summary>
        /// <param name='detectOrientation'>
        /// Whether detect the text orientation in the image. With
        /// detectOrientation=true the OCR service tries to detect the image
        /// orientation and correct it before further processing (e.g. if it's
        /// upside-down).
        /// </param>
        /// <param name='url'>
        /// Publicly reachable URL of an image.
        /// </param>
        /// <param name='language'>
        /// The BCP-47 language code of the text to be detected in the image.
        /// The default value is 'unk'. Possible values include: 'unk',
        /// 'zh-Hans', 'zh-Hant', 'cs', 'da', 'nl', 'en', 'fi', 'fr', 'de',
        /// 'el', 'hu', 'it', 'ja', 'ko', 'nb', 'pl', 'pt', 'ru', 'es', 'sv',
        /// 'tr', 'ar', 'ro', 'sr-Cyrl', 'sr-Latn', 'sk'
        /// </param>
        /// <param name='modelVersion'>
        /// Optional parameter to specify the version of the AI model. Accepted
        /// values are: "latest", "2021-04-01", "2021-05-01". Defaults to
        /// "latest".
        /// </param>
        /// <param name='customHeaders'>
        /// The headers that will be added to request.
        /// </param>
        /// <param name='cancellationToken'>
        /// The cancellation token.
        /// </param>
        Task<HttpOperationResponse<OcrResult>> RecognizePrintedTextWithHttpMessagesAsync(bool detectOrientation, string url, OcrLanguages? language = default(OcrLanguages?), string modelVersion = "latest", Dictionary<string, List<string>> customHeaders = null, CancellationToken cancellationToken = default(CancellationToken));

        /// <summary>
        /// This operation generates a list of words, or tags, that are
        /// relevant to the content of the supplied image. The Computer Vision
        /// API can return tags based on objects, living beings, scenery or
        /// actions found in images. Unlike categories, tags are not organized
        /// according to a hierarchical classification system, but correspond
        /// to image content. Tags may contain hints to avoid ambiguity or
        /// provide context, for example the tag "ascomycete" may be
        /// accompanied by the hint "fungus".
        /// Two input methods are supported -- (1) Uploading an image or (2)
        /// specifying an image URL.
        /// A successful response will be returned in JSON. If the request
        /// failed, the response will contain an error code and a message to
        /// help understand what went wrong.
        /// </summary>
        /// <param name='url'>
        /// Publicly reachable URL of an image.
        /// </param>
        /// <param name='language'>
        /// The desired language for output generation. If this parameter is
        /// not specified, the default value is "en". See
        /// https://aka.ms/cv-languages for list of supported languages.
        /// Possible values include: 'ar', 'az', 'bg', 'bs', 'ca', 'cs', 'cy',
        /// 'da', 'de', 'el', 'en', 'es', 'et', 'eu', 'fi', 'fr', 'ga', 'gl',
        /// 'he', 'hi', 'hr', 'hu', 'id', 'it', 'ja', 'kk', 'ko', 'lt', 'lv',
        /// 'mk', 'ms', 'nb', 'nl', 'pl', 'prs', 'pt', 'pt-BR', 'pt-PT', 'ro',
        /// 'ru', 'sk', 'sl', 'sr-Cyrl', 'sr-Latn', 'sv', 'th', 'tr', 'uk',
        /// 'vi', 'zh', 'zh-Hans', 'zh-Hant'
        /// </param>
        /// <param name='modelVersion'>
        /// Optional parameter to specify the version of the AI model. Accepted
        /// values are: "latest", "2021-04-01", "2021-05-01". Defaults to
        /// "latest".
        /// </param>
        /// <param name='customHeaders'>
        /// The headers that will be added to request.
        /// </param>
        /// <param name='cancellationToken'>
        /// The cancellation token.
        /// </param>
        Task<HttpOperationResponse<TagResult>> TagImageWithHttpMessagesAsync(string url, string language = default(string), string modelVersion = "latest", Dictionary<string, List<string>> customHeaders = null, CancellationToken cancellationToken = default(CancellationToken));

        /// <summary>
        /// This operation generates a thumbnail image with the user-specified
        /// width and height. By default, the service analyzes the image,
        /// identifies the region of interest (ROI), and generates smart
        /// cropping coordinates based on the ROI. Smart cropping helps when
        /// you specify an aspect ratio that differs from that of the input
        /// image.
        /// A successful response contains the thumbnail image binary. If the
        /// request failed, the response contains an error code and a message
        /// to help determine what went wrong.
        /// Upon failure, the error code and an error message are returned. The
        /// error code could be one of InvalidImageUrl, InvalidImageFormat,
        /// InvalidImageSize, InvalidThumbnailSize, NotSupportedImage,
        /// FailedToProcess, Timeout, or InternalServerError.
        /// </summary>
        /// <param name='width'>
        /// Width of the thumbnail, in pixels. It must be between 1 and 1024.
        /// Recommended minimum of 50.
        /// </param>
        /// <param name='height'>
        /// Height of the thumbnail, in pixels. It must be between 1 and 1024.
        /// Recommended minimum of 50.
        /// </param>
        /// <param name='url'>
        /// Publicly reachable URL of an image.
        /// </param>
        /// <param name='smartCropping'>
        /// Boolean flag for enabling smart cropping.
        /// </param>
        /// <param name='modelVersion'>
        /// Optional parameter to specify the version of the AI model. Accepted
        /// values are: "latest", "2021-04-01", "2021-05-01". Defaults to
        /// "latest".
        /// </param>
        /// <param name='customHeaders'>
        /// The headers that will be added to request.
        /// </param>
        /// <param name='cancellationToken'>
        /// The cancellation token.
        /// </param>
        Task<HttpOperationResponse<Stream>> GenerateThumbnailWithHttpMessagesAsync(int width, int height, string url, bool? smartCropping = false, string modelVersion = "latest", Dictionary<string, List<string>> customHeaders = null, CancellationToken cancellationToken = default(CancellationToken));

        /// <summary>
        /// This operation returns a bounding box around the most important
        /// area of the image.
        /// A successful response will be returned in JSON. If the request
        /// failed, the response contains an error code and a message to help
        /// determine what went wrong.
        /// Upon failure, the error code and an error message are returned. The
        /// error code could be one of InvalidImageUrl, InvalidImageFormat,
        /// InvalidImageSize, NotSupportedImage, FailedToProcess, Timeout, or
        /// InternalServerError.
        /// </summary>
        /// <param name='url'>
        /// Publicly reachable URL of an image.
        /// </param>
        /// <param name='modelVersion'>
        /// Optional parameter to specify the version of the AI model. Accepted
        /// values are: "latest", "2021-04-01", "2021-05-01". Defaults to
        /// "latest".
        /// </param>
        /// <param name='customHeaders'>
        /// The headers that will be added to request.
        /// </param>
        /// <param name='cancellationToken'>
        /// The cancellation token.
        /// </param>
        Task<HttpOperationResponse<AreaOfInterestResult>> GetAreaOfInterestWithHttpMessagesAsync(string url, string modelVersion = "latest", Dictionary<string, List<string>> customHeaders = null, CancellationToken cancellationToken = default(CancellationToken));

        /// <summary>
        /// Use this interface to get the result of a Read operation, employing
        /// the state-of-the-art Optical Character Recognition (OCR) algorithms
        /// optimized for text-heavy documents. When you use the Read
        /// interface, the response contains a field called
        /// 'Operation-Location'. The 'Operation-Location' field contains the
        /// URL that you must use for your 'GetReadResult' operation to access
        /// OCR results.​
        /// </summary>
        /// <param name='url'>
        /// Publicly reachable URL of an image.
        /// </param>
        /// <param name='language'>
        /// The BCP-47 language code of the text in the document. Read supports
        /// auto language identification and multi-language documents, so only
        /// provide a language code if you would like to force the document to
        /// be processed in that specific language. See
        /// https://aka.ms/ocr-languages for list of supported languages.
        /// Possible values include: 'af', 'ast', 'bi', 'br', 'ca', 'ceb',
        /// 'ch', 'co', 'crh', 'cs', 'csb', 'da', 'de', 'en', 'es', 'et', 'eu',
        /// 'fi', 'fil', 'fj', 'fr', 'fur', 'fy', 'ga', 'gd', 'gil', 'gl',
        /// 'gv', 'hni', 'hsb', 'ht', 'hu', 'ia', 'id', 'it', 'iu', 'ja', 'jv',
        /// 'kaa', 'kac', 'kea', 'kha', 'kl', 'ko', 'ku', 'kw', 'lb', 'ms',
        /// 'mww', 'nap', 'nl', 'no', 'oc', 'pl', 'pt', 'quc', 'rm', 'sco',
        /// 'sl', 'sq', 'sv', 'sw', 'tet', 'tr', 'tt', 'uz', 'vo', 'wae',
        /// 'yua', 'za', 'zh-Hans', 'zh-Hant', 'zu'
        /// </param>
        /// <param name='pages'>
        /// Custom page numbers for multi-page documents(PDF/TIFF), input the
        /// number of the pages you want to get OCR result. For a range of
        /// pages, use a hyphen. Separate each page or range with a comma.
        /// </param>
        /// <param name='modelVersion'>
        /// Optional parameter to specify the version of the OCR model used for
        /// text extraction. Accepted values are: "latest", "latest-preview",
        /// "2021-04-12". Defaults to "latest".
        /// </param>
        /// <param name='readingOrder'>
        /// Optional parameter to specify which reading order algorithm should
        /// be applied when ordering the extract text elements. Can be either
        /// 'basic' or 'natural'. Will default to 'basic' if not specified
        /// </param>
        /// <param name='customHeaders'>
        /// The headers that will be added to request.
        /// </param>
        /// <param name='cancellationToken'>
        /// The cancellation token.
        /// </param>
        Task<HttpOperationHeaderResponse<ReadHeaders>> ReadWithHttpMessagesAsync(string url, string language = default(string), IList<string> pages = default(IList<string>), string modelVersion = "latest", string readingOrder = "basic", Dictionary<string, List<string>> customHeaders = null, CancellationToken cancellationToken = default(CancellationToken));

        /// <summary>
        /// This interface is used for getting OCR results of Read operation.
        /// The URL to this interface should be retrieved from
        /// 'Operation-Location' field returned from Read interface.
        /// </summary>
        /// <param name='operationId'>
        /// Id of read operation returned in the response of the 'Read'
        /// interface.
        /// </param>
        /// <param name='customHeaders'>
        /// The headers that will be added to request.
        /// </param>
        /// <param name='cancellationToken'>
        /// The cancellation token.
        /// </param>
        Task<HttpOperationResponse<ReadOperationResult>> GetReadResultWithHttpMessagesAsync(System.Guid operationId, Dictionary<string, List<string>> customHeaders = null, CancellationToken cancellationToken = default(CancellationToken));

        /// <summary>
        /// This operation extracts a rich set of visual features based on the
        /// image content.
        /// Two input methods are supported -- (1) Uploading an image or (2)
        /// specifying an image URL. Within your request, there is an optional
        /// parameter to allow you to choose which features to return. By
        /// default, image categories are returned in the response.
        /// A successful response will be returned in JSON. If the request
        /// failed, the response will contain an error code and a message to
        /// help understand what went wrong.
        /// </summary>
        /// <param name='image'>
        /// An image stream.
        /// </param>
        /// <param name='visualFeatures'>
        /// A string indicating what visual feature types to return. Multiple
        /// values should be comma-separated. Valid visual feature types
        /// include: Categories - categorizes image content according to a
        /// taxonomy defined in documentation. Tags - tags the image with a
        /// detailed list of words related to the image content. Description -
        /// describes the image content with a complete English sentence. Faces
        /// - detects if faces are present. If present, generate coordinates,
        /// gender and age. ImageType - detects if image is clipart or a line
        /// drawing. Color - determines the accent color, dominant color, and
        /// whether an image is black&amp;white. Adult - detects if the image
        /// is pornographic in nature (depicts nudity or a sex act), or is gory
        /// (depicts extreme violence or blood). Sexually suggestive content
        /// (aka racy content) is also detected. Objects - detects various
        /// objects within an image, including the approximate location. The
        /// Objects argument is only available in English. Brands - detects
        /// various brands within an image, including the approximate location.
        /// The Brands argument is only available in English.
        /// </param>
        /// <param name='details'>
        /// A string indicating which domain-specific details to return.
        /// Multiple values should be comma-separated. Valid visual feature
        /// types include: Celebrities - identifies celebrities if detected in
        /// the image, Landmarks - identifies notable landmarks in the image.
        /// </param>
        /// <param name='language'>
        /// The desired language for output generation. If this parameter is
        /// not specified, the default value is "en". See
        /// https://aka.ms/cv-languages for list of supported languages.
        /// Possible values include: 'ar', 'az', 'bg', 'bs', 'ca', 'cs', 'cy',
        /// 'da', 'de', 'el', 'en', 'es', 'et', 'eu', 'fi', 'fr', 'ga', 'gl',
        /// 'he', 'hi', 'hr', 'hu', 'id', 'it', 'ja', 'kk', 'ko', 'lt', 'lv',
        /// 'mk', 'ms', 'nb', 'nl', 'pl', 'prs', 'pt', 'pt-BR', 'pt-PT', 'ro',
        /// 'ru', 'sk', 'sl', 'sr-Cyrl', 'sr-Latn', 'sv', 'th', 'tr', 'uk',
        /// 'vi', 'zh', 'zh-Hans', 'zh-Hant'
        /// </param>
        /// <param name='descriptionExclude'>
        /// Turn off specified domain models when generating the description.
        /// </param>
        /// <param name='modelVersion'>
        /// Optional parameter to specify the version of the AI model. Accepted
        /// values are: "latest", "2021-04-01", "2021-05-01". Defaults to
        /// "latest".
        /// </param>
        /// <param name='customHeaders'>
        /// The headers that will be added to request.
        /// </param>
        /// <param name='cancellationToken'>
        /// The cancellation token.
        /// </param>
        Task<HttpOperationResponse<ImageAnalysis>> AnalyzeImageInStreamWithHttpMessagesAsync(Stream image, IList<VisualFeatureTypes?> visualFeatures = default(IList<VisualFeatureTypes?>), IList<Details?> details = default(IList<Details?>), string language = default(string), IList<DescriptionExclude?> descriptionExclude = default(IList<DescriptionExclude?>), string modelVersion = "latest", Dictionary<string, List<string>> customHeaders = null, CancellationToken cancellationToken = default(CancellationToken));

        /// <summary>
        /// This operation returns a bounding box around the most important
        /// area of the image.
        /// A successful response will be returned in JSON. If the request
        /// failed, the response contains an error code and a message to help
        /// determine what went wrong.
        /// Upon failure, the error code and an error message are returned. The
        /// error code could be one of InvalidImageUrl, InvalidImageFormat,
        /// InvalidImageSize, NotSupportedImage, FailedToProcess, Timeout, or
        /// InternalServerError.
        /// </summary>
        /// <param name='image'>
        /// An image stream.
        /// </param>
        /// <param name='modelVersion'>
        /// Optional parameter to specify the version of the AI model. Accepted
        /// values are: "latest", "2021-04-01", "2021-05-01". Defaults to
        /// "latest".
        /// </param>
        /// <param name='customHeaders'>
        /// The headers that will be added to request.
        /// </param>
        /// <param name='cancellationToken'>
        /// The cancellation token.
        /// </param>
        Task<HttpOperationResponse<AreaOfInterestResult>> GetAreaOfInterestInStreamWithHttpMessagesAsync(Stream image, string modelVersion = "latest", Dictionary<string, List<string>> customHeaders = null, CancellationToken cancellationToken = default(CancellationToken));

        /// <summary>
        /// This operation generates a description of an image in human
        /// readable language with complete sentences. The description is based
        /// on a collection of content tags, which are also returned by the
        /// operation. More than one description can be generated for each
        /// image. Descriptions are ordered by their confidence score.
        /// Descriptions may include results from celebrity and landmark domain
        /// models, if applicable.
        /// Two input methods are supported -- (1) Uploading an image or (2)
        /// specifying an image URL.
        /// A successful response will be returned in JSON. If the request
        /// failed, the response will contain an error code and a message to
        /// help understand what went wrong.
        /// </summary>
        /// <param name='image'>
        /// An image stream.
        /// </param>
        /// <param name='maxCandidates'>
        /// Maximum number of candidate descriptions to be returned.  The
        /// default is 1.
        /// </param>
        /// <param name='language'>
        /// The desired language for output generation. If this parameter is
        /// not specified, the default value is "en". See
        /// https://aka.ms/cv-languages for list of supported languages.
        /// Possible values include: 'ar', 'az', 'bg', 'bs', 'ca', 'cs', 'cy',
        /// 'da', 'de', 'el', 'en', 'es', 'et', 'eu', 'fi', 'fr', 'ga', 'gl',
        /// 'he', 'hi', 'hr', 'hu', 'id', 'it', 'ja', 'kk', 'ko', 'lt', 'lv',
        /// 'mk', 'ms', 'nb', 'nl', 'pl', 'prs', 'pt', 'pt-BR', 'pt-PT', 'ro',
        /// 'ru', 'sk', 'sl', 'sr-Cyrl', 'sr-Latn', 'sv', 'th', 'tr', 'uk',
        /// 'vi', 'zh', 'zh-Hans', 'zh-Hant'
        /// </param>
        /// <param name='descriptionExclude'>
        /// Turn off specified domain models when generating the description.
        /// </param>
        /// <param name='modelVersion'>
        /// Optional parameter to specify the version of the AI model. Accepted
        /// values are: "latest", "2021-04-01", "2021-05-01". Defaults to
        /// "latest".
        /// </param>
        /// <param name='customHeaders'>
        /// The headers that will be added to request.
        /// </param>
        /// <param name='cancellationToken'>
        /// The cancellation token.
        /// </param>
        Task<HttpOperationResponse<ImageDescription>> DescribeImageInStreamWithHttpMessagesAsync(Stream image, int? maxCandidates = 1, string language = default(string), IList<DescriptionExclude?> descriptionExclude = default(IList<DescriptionExclude?>), string modelVersion = "latest", Dictionary<string, List<string>> customHeaders = null, CancellationToken cancellationToken = default(CancellationToken));

        /// <summary>
        /// Performs object detection on the specified image.
        /// Two input methods are supported -- (1) Uploading an image or (2)
        /// specifying an image URL.
        /// A successful response will be returned in JSON. If the request
        /// failed, the response will contain an error code and a message to
        /// help understand what went wrong.
        /// </summary>
        /// <param name='image'>
        /// An image stream.
        /// </param>
        /// <param name='modelVersion'>
        /// Optional parameter to specify the version of the AI model. Accepted
        /// values are: "latest", "2021-04-01", "2021-05-01". Defaults to
        /// "latest".
        /// </param>
        /// <param name='customHeaders'>
        /// The headers that will be added to request.
        /// </param>
        /// <param name='cancellationToken'>
        /// The cancellation token.
        /// </param>
        Task<HttpOperationResponse<DetectResult>> DetectObjectsInStreamWithHttpMessagesAsync(Stream image, string modelVersion = "latest", Dictionary<string, List<string>> customHeaders = null, CancellationToken cancellationToken = default(CancellationToken));

        /// <summary>
        /// This operation generates a thumbnail image with the user-specified
        /// width and height. By default, the service analyzes the image,
        /// identifies the region of interest (ROI), and generates smart
        /// cropping coordinates based on the ROI. Smart cropping helps when
        /// you specify an aspect ratio that differs from that of the input
        /// image.
        /// A successful response contains the thumbnail image binary. If the
        /// request failed, the response contains an error code and a message
        /// to help determine what went wrong.
        /// Upon failure, the error code and an error message are returned. The
        /// error code could be one of InvalidImageUrl, InvalidImageFormat,
        /// InvalidImageSize, InvalidThumbnailSize, NotSupportedImage,
        /// FailedToProcess, Timeout, or InternalServerError.
        /// </summary>
        /// <param name='width'>
        /// Width of the thumbnail, in pixels. It must be between 1 and 1024.
        /// Recommended minimum of 50.
        /// </param>
        /// <param name='height'>
        /// Height of the thumbnail, in pixels. It must be between 1 and 1024.
        /// Recommended minimum of 50.
        /// </param>
        /// <param name='image'>
        /// An image stream.
        /// </param>
        /// <param name='smartCropping'>
        /// Boolean flag for enabling smart cropping.
        /// </param>
        /// <param name='modelVersion'>
        /// Optional parameter to specify the version of the AI model. Accepted
        /// values are: "latest", "2021-04-01", "2021-05-01". Defaults to
        /// "latest".
        /// </param>
        /// <param name='customHeaders'>
        /// The headers that will be added to request.
        /// </param>
        /// <param name='cancellationToken'>
        /// The cancellation token.
        /// </param>
        Task<HttpOperationResponse<Stream>> GenerateThumbnailInStreamWithHttpMessagesAsync(int width, int height, Stream image, bool? smartCropping = false, string modelVersion = "latest", Dictionary<string, List<string>> customHeaders = null, CancellationToken cancellationToken = default(CancellationToken));

        /// <summary>
        /// This operation recognizes content within an image by applying a
        /// domain-specific model. The list of domain-specific models that are
        /// supported by the Computer Vision API can be retrieved using the
        /// /models GET request. Currently, the API provides following
        /// domain-specific models: celebrities, landmarks.
        /// Two input methods are supported -- (1) Uploading an image or (2)
        /// specifying an image URL.
        /// A successful response will be returned in JSON.
        /// If the request failed, the response will contain an error code and
        /// a message to help understand what went wrong.
        /// </summary>
        /// <param name='model'>
        /// The domain-specific content to recognize.
        /// </param>
        /// <param name='image'>
        /// An image stream.
        /// </param>
        /// <param name='language'>
        /// The desired language for output generation. If this parameter is
        /// not specified, the default value is "en". See
        /// https://aka.ms/cv-languages for list of supported languages.
        /// Possible values include: 'ar', 'az', 'bg', 'bs', 'ca', 'cs', 'cy',
        /// 'da', 'de', 'el', 'en', 'es', 'et', 'eu', 'fi', 'fr', 'ga', 'gl',
        /// 'he', 'hi', 'hr', 'hu', 'id', 'it', 'ja', 'kk', 'ko', 'lt', 'lv',
        /// 'mk', 'ms', 'nb', 'nl', 'pl', 'prs', 'pt', 'pt-BR', 'pt-PT', 'ro',
        /// 'ru', 'sk', 'sl', 'sr-Cyrl', 'sr-Latn', 'sv', 'th', 'tr', 'uk',
        /// 'vi', 'zh', 'zh-Hans', 'zh-Hant'
        /// </param>
        /// <param name='modelVersion'>
        /// Optional parameter to specify the version of the AI model. Accepted
        /// values are: "latest", "2021-04-01", "2021-05-01". Defaults to
        /// "latest".
        /// </param>
        /// <param name='customHeaders'>
        /// The headers that will be added to request.
        /// </param>
        /// <param name='cancellationToken'>
        /// The cancellation token.
        /// </param>
        Task<HttpOperationResponse<DomainModelResults>> AnalyzeImageByDomainInStreamWithHttpMessagesAsync(string model, Stream image, string language = default(string), string modelVersion = "latest", Dictionary<string, List<string>> customHeaders = null, CancellationToken cancellationToken = default(CancellationToken));

        /// <summary>
        /// Optical Character Recognition (OCR) detects text in an image and
        /// extracts the recognized characters into a machine-usable character
        /// stream.
        /// Upon success, the OCR results will be returned.
        /// Upon failure, the error code together with an error message will be
        /// returned. The error code can be one of InvalidImageUrl,
        /// InvalidImageFormat, InvalidImageSize, NotSupportedImage,
        /// NotSupportedLanguage, or InternalServerError.
        /// </summary>
        /// <param name='detectOrientation'>
        /// Whether detect the text orientation in the image. With
        /// detectOrientation=true the OCR service tries to detect the image
        /// orientation and correct it before further processing (e.g. if it's
        /// upside-down).
        /// </param>
        /// <param name='image'>
        /// An image stream.
        /// </param>
        /// <param name='language'>
        /// The BCP-47 language code of the text to be detected in the image.
        /// The default value is 'unk'. Possible values include: 'unk',
        /// 'zh-Hans', 'zh-Hant', 'cs', 'da', 'nl', 'en', 'fi', 'fr', 'de',
        /// 'el', 'hu', 'it', 'ja', 'ko', 'nb', 'pl', 'pt', 'ru', 'es', 'sv',
        /// 'tr', 'ar', 'ro', 'sr-Cyrl', 'sr-Latn', 'sk'
        /// </param>
        /// <param name='modelVersion'>
        /// Optional parameter to specify the version of the AI model. Accepted
        /// values are: "latest", "2021-04-01", "2021-05-01". Defaults to
        /// "latest".
        /// </param>
        /// <param name='customHeaders'>
        /// The headers that will be added to request.
        /// </param>
        /// <param name='cancellationToken'>
        /// The cancellation token.
        /// </param>
        Task<HttpOperationResponse<OcrResult>> RecognizePrintedTextInStreamWithHttpMessagesAsync(bool detectOrientation, Stream image, OcrLanguages? language = default(OcrLanguages?), string modelVersion = "latest", Dictionary<string, List<string>> customHeaders = null, CancellationToken cancellationToken = default(CancellationToken));

        /// <summary>
        /// This operation generates a list of words, or tags, that are
        /// relevant to the content of the supplied image. The Computer Vision
        /// API can return tags based on objects, living beings, scenery or
        /// actions found in images. Unlike categories, tags are not organized
        /// according to a hierarchical classification system, but correspond
        /// to image content. Tags may contain hints to avoid ambiguity or
        /// provide context, for example the tag "ascomycete" may be
        /// accompanied by the hint "fungus".
        /// Two input methods are supported -- (1) Uploading an image or (2)
        /// specifying an image URL.
        /// A successful response will be returned in JSON. If the request
        /// failed, the response will contain an error code and a message to
        /// help understand what went wrong.
        /// </summary>
        /// <param name='image'>
        /// An image stream.
        /// </param>
        /// <param name='language'>
        /// The desired language for output generation. If this parameter is
        /// not specified, the default value is "en". See
        /// https://aka.ms/cv-languages for list of supported languages.
        /// Possible values include: 'ar', 'az', 'bg', 'bs', 'ca', 'cs', 'cy',
        /// 'da', 'de', 'el', 'en', 'es', 'et', 'eu', 'fi', 'fr', 'ga', 'gl',
        /// 'he', 'hi', 'hr', 'hu', 'id', 'it', 'ja', 'kk', 'ko', 'lt', 'lv',
        /// 'mk', 'ms', 'nb', 'nl', 'pl', 'prs', 'pt', 'pt-BR', 'pt-PT', 'ro',
        /// 'ru', 'sk', 'sl', 'sr-Cyrl', 'sr-Latn', 'sv', 'th', 'tr', 'uk',
        /// 'vi', 'zh', 'zh-Hans', 'zh-Hant'
        /// </param>
        /// <param name='modelVersion'>
        /// Optional parameter to specify the version of the AI model. Accepted
        /// values are: "latest", "2021-04-01", "2021-05-01". Defaults to
        /// "latest".
        /// </param>
        /// <param name='customHeaders'>
        /// The headers that will be added to request.
        /// </param>
        /// <param name='cancellationToken'>
        /// The cancellation token.
        /// </param>
        Task<HttpOperationResponse<TagResult>> TagImageInStreamWithHttpMessagesAsync(Stream image, string language = default(string), string modelVersion = "latest", Dictionary<string, List<string>> customHeaders = null, CancellationToken cancellationToken = default(CancellationToken));

        /// <summary>
        /// Use this interface to get the result of a Read operation, employing
        /// the state-of-the-art Optical Character Recognition (OCR) algorithms
        /// optimized for text-heavy documents. When you use the Read
        /// interface, the response contains a field called
        /// 'Operation-Location'. The 'Operation-Location' field contains the
        /// URL that you must use for your 'GetReadResult' operation to access
        /// OCR results.​
        /// </summary>
        /// <param name='image'>
        /// An image stream.
        /// </param>
        /// <param name='language'>
        /// The BCP-47 language code of the text in the document. Read supports
        /// auto language identification and multi-language documents, so only
        /// provide a language code if you would like to force the document to
        /// be processed in that specific language. See
        /// https://aka.ms/ocr-languages for list of supported languages.
        /// Possible values include: 'af', 'ast', 'bi', 'br', 'ca', 'ceb',
        /// 'ch', 'co', 'crh', 'cs', 'csb', 'da', 'de', 'en', 'es', 'et', 'eu',
        /// 'fi', 'fil', 'fj', 'fr', 'fur', 'fy', 'ga', 'gd', 'gil', 'gl',
        /// 'gv', 'hni', 'hsb', 'ht', 'hu', 'ia', 'id', 'it', 'iu', 'ja', 'jv',
        /// 'kaa', 'kac', 'kea', 'kha', 'kl', 'ko', 'ku', 'kw', 'lb', 'ms',
        /// 'mww', 'nap', 'nl', 'no', 'oc', 'pl', 'pt', 'quc', 'rm', 'sco',
        /// 'sl', 'sq', 'sv', 'sw', 'tet', 'tr', 'tt', 'uz', 'vo', 'wae',
        /// 'yua', 'za', 'zh-Hans', 'zh-Hant', 'zu'
        /// </param>
        /// <param name='pages'>
        /// Custom page numbers for multi-page documents(PDF/TIFF), input the
        /// number of the pages you want to get OCR result. For a range of
        /// pages, use a hyphen. Separate each page or range with a comma.
        /// </param>
        /// <param name='modelVersion'>
        /// Optional parameter to specify the version of the OCR model used for
        /// text extraction. Accepted values are: "latest", "latest-preview",
        /// "2021-04-12". Defaults to "latest".
        /// </param>
        /// <param name='readingOrder'>
        /// Optional parameter to specify which reading order algorithm should
        /// be applied when ordering the extract text elements. Can be either
        /// 'basic' or 'natural'. Will default to 'basic' if not specified
        /// </param>
        /// <param name='customHeaders'>
        /// The headers that will be added to request.
        /// </param>
        /// <param name='cancellationToken'>
        /// The cancellation token.
        /// </param>
        Task<HttpOperationHeaderResponse<ReadInStreamHeaders>> ReadInStreamWithHttpMessagesAsync(Stream image, string language = default(string), IList<string> pages = default(IList<string>), string modelVersion = "latest", string readingOrder = "basic", Dictionary<string, List<string>> customHeaders = null, CancellationToken cancellationToken = default(CancellationToken));

    }
}
