// <auto-generated>
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.
// </auto-generated>

namespace Microsoft.Azure.CognitiveServices.Search.WebSearch.Models
{
    using Microsoft.Rest;
    using Newtonsoft.Json;
    using System.Linq;

    /// <summary>
    /// Defines the query context that Bing used for the request.
    /// </summary>
    public partial class QueryContext
    {
        /// <summary>
        /// Initializes a new instance of the QueryContext class.
        /// </summary>
        public QueryContext()
        {
            CustomInit();
        }

        /// <summary>
        /// Initializes a new instance of the QueryContext class.
        /// </summary>
        /// <param name="originalQuery">The query string as specified in the
        /// request.</param>
        /// <param name="alteredQuery">The query string used by Bing to perform
        /// the query. Bing uses the altered query string if the original query
        /// string contained spelling mistakes. For example, if the query
        /// string is "saling downwind", the altered query string will be
        /// "sailing downwind". This field is included only if the original
        /// query string contains a spelling mistake.</param>
        /// <param name="alterationOverrideQuery">The query string to use to
        /// force Bing to use the original string. For example, if the query
        /// string is "saling downwind", the override query string will be
        /// "+saling downwind". Remember to encode the query string which
        /// results in "%2Bsaling+downwind". This field is included only if the
        /// original query string contains a spelling mistake.</param>
        /// <param name="adultIntent">A Boolean value that indicates whether
        /// the specified query has adult intent. The value is true if the
        /// query has adult intent; otherwise, false.</param>
        /// <param name="askUserForLocation">A Boolean value that indicates
        /// whether Bing requires the user's location to provide accurate
        /// results. If you specified the user's location by using the
        /// X-MSEdge-ClientIP and X-Search-Location headers, you can ignore
        /// this field. For location aware queries, such as "today's weather"
        /// or "restaurants near me" that need the user's location to provide
        /// accurate results, this field is set to true. For location aware
        /// queries that include the location (for example, "Seattle weather"),
        /// this field is set to false. This field is also set to false for
        /// queries that are not location aware, such as "best
        /// sellers".</param>
        public QueryContext(string originalQuery, string alteredQuery = default(string), string alterationOverrideQuery = default(string), bool? adultIntent = default(bool?), bool? askUserForLocation = default(bool?), bool? isTransactional = default(bool?))
        {
            OriginalQuery = originalQuery;
            AlteredQuery = alteredQuery;
            AlterationOverrideQuery = alterationOverrideQuery;
            AdultIntent = adultIntent;
            AskUserForLocation = askUserForLocation;
            IsTransactional = isTransactional;
            CustomInit();
        }

        /// <summary>
        /// An initialization method that performs custom operations like setting defaults
        /// </summary>
        partial void CustomInit();

        /// <summary>
        /// Gets or sets the query string as specified in the request.
        /// </summary>
        [JsonProperty(PropertyName = "originalQuery")]
        public string OriginalQuery { get; set; }

        /// <summary>
        /// Gets the query string used by Bing to perform the query. Bing uses
        /// the altered query string if the original query string contained
        /// spelling mistakes. For example, if the query string is "saling
        /// downwind", the altered query string will be "sailing downwind".
        /// This field is included only if the original query string contains a
        /// spelling mistake.
        /// </summary>
        [JsonProperty(PropertyName = "alteredQuery")]
        public string AlteredQuery { get; private set; }

        /// <summary>
        /// Gets the query string to use to force Bing to use the original
        /// string. For example, if the query string is "saling downwind", the
        /// override query string will be "+saling downwind". Remember to
        /// encode the query string which results in "%2Bsaling+downwind". This
        /// field is included only if the original query string contains a
        /// spelling mistake.
        /// </summary>
        [JsonProperty(PropertyName = "alterationOverrideQuery")]
        public string AlterationOverrideQuery { get; private set; }

        /// <summary>
        /// Gets a Boolean value that indicates whether the specified query has
        /// adult intent. The value is true if the query has adult intent;
        /// otherwise, false.
        /// </summary>
        [JsonProperty(PropertyName = "adultIntent")]
        public bool? AdultIntent { get; private set; }

        /// <summary>
        /// Gets a Boolean value that indicates whether Bing requires the
        /// user's location to provide accurate results. If you specified the
        /// user's location by using the X-MSEdge-ClientIP and
        /// X-Search-Location headers, you can ignore this field. For location
        /// aware queries, such as "today's weather" or "restaurants near me"
        /// that need the user's location to provide accurate results, this
        /// field is set to true. For location aware queries that include the
        /// location (for example, "Seattle weather"), this field is set to
        /// false. This field is also set to false for queries that are not
        /// location aware, such as "best sellers".
        /// </summary>
        [JsonProperty(PropertyName = "askUserForLocation")]
        public bool? AskUserForLocation { get; private set; }

        /// <summary>
        /// </summary>
        [JsonProperty(PropertyName = "isTransactional")]
        public bool? IsTransactional { get; private set; }

        /// <summary>
        /// Validate the object.
        /// </summary>
        /// <exception cref="ValidationException">
        /// Thrown if validation fails
        /// </exception>
        public virtual void Validate()
        {
            if (OriginalQuery == null)
            {
                throw new ValidationException(ValidationRules.CannotBeNull, "OriginalQuery");
            }
        }
    }
}
