// <auto-generated>
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.
// </auto-generated>

namespace Microsoft.Azure.CognitiveServices.Search.ImageSearch.Models
{
    using Microsoft.Rest;
    using Newtonsoft.Json;
    using System.Collections;
    using System.Collections.Generic;
    using System.Linq;

    /// <summary>
    /// Defines an image answer
    /// </summary>
    public partial class Images : SearchResultsAnswer
    {
        /// <summary>
        /// Initializes a new instance of the Images class.
        /// </summary>
        public Images()
        {
            CustomInit();
        }

        /// <summary>
        /// Initializes a new instance of the Images class.
        /// </summary>
        /// <param name="value">A list of image objects that are relevant to
        /// the query. If there are no results, the List is empty.</param>
        /// <param name="id">A String identifier.</param>
        /// <param name="readLink">The URL that returns this resource.</param>
        /// <param name="webSearchUrl">The URL To Bing's search result for this
        /// item.</param>
        /// <param name="totalEstimatedMatches">The estimated number of
        /// webpages that are relevant to the query. Use this number along with
        /// the count and offset query parameters to page the results.</param>
        /// <param name="nextOffset">Used as part of deduping. Tells client the
        /// next offset that client should use in the next pagination
        /// request</param>
        /// <param name="queryExpansions">A list of expanded queries that
        /// narrows the original query. For example, if the query was Microsoft
        /// Surface, the expanded queries might be: Microsoft Surface Pro 3,
        /// Microsoft Surface RT, Microsoft Surface Phone, and Microsoft
        /// Surface Hub.</param>
        /// <param name="pivotSuggestions">A list of segments in the original
        /// query. For example, if the query was Red Flowers, Bing might
        /// segment the query into Red and Flowers. The Flowers pivot may
        /// contain query suggestions such as Red Peonies and Red Daisies, and
        /// the Red pivot may contain query suggestions such as Green Flowers
        /// and Yellow Flowers.</param>
        /// <param name="similarTerms">A list of terms that are similar in
        /// meaning to the user's query term.</param>
        public Images(IList<ImageObject> value, string id = default(string), string readLink = default(string), string webSearchUrl = default(string), long? totalEstimatedMatches = default(long?), int? nextOffset = default(int?), IList<Query> queryExpansions = default(IList<Query>), IList<PivotSuggestions> pivotSuggestions = default(IList<PivotSuggestions>), IList<Query> similarTerms = default(IList<Query>))
            : base(id, readLink, webSearchUrl, totalEstimatedMatches)
        {
            NextOffset = nextOffset;
            Value = value;
            QueryExpansions = queryExpansions;
            PivotSuggestions = pivotSuggestions;
            SimilarTerms = similarTerms;
            CustomInit();
        }

        /// <summary>
        /// An initialization method that performs custom operations like setting defaults
        /// </summary>
        partial void CustomInit();

        /// <summary>
        /// Gets used as part of deduping. Tells client the next offset that
        /// client should use in the next pagination request
        /// </summary>
        [JsonProperty(PropertyName = "nextOffset")]
        public int? NextOffset { get; private set; }

        /// <summary>
        /// Gets or sets a list of image objects that are relevant to the
        /// query. If there are no results, the List is empty.
        /// </summary>
        [JsonProperty(PropertyName = "value")]
        public IList<ImageObject> Value { get; set; }

        /// <summary>
        /// Gets a list of expanded queries that narrows the original query.
        /// For example, if the query was Microsoft Surface, the expanded
        /// queries might be: Microsoft Surface Pro 3, Microsoft Surface RT,
        /// Microsoft Surface Phone, and Microsoft Surface Hub.
        /// </summary>
        [JsonProperty(PropertyName = "queryExpansions")]
        public IList<Query> QueryExpansions { get; private set; }

        /// <summary>
        /// Gets a list of segments in the original query. For example, if the
        /// query was Red Flowers, Bing might segment the query into Red and
        /// Flowers. The Flowers pivot may contain query suggestions such as
        /// Red Peonies and Red Daisies, and the Red pivot may contain query
        /// suggestions such as Green Flowers and Yellow Flowers.
        /// </summary>
        [JsonProperty(PropertyName = "pivotSuggestions")]
        public IList<PivotSuggestions> PivotSuggestions { get; private set; }

        /// <summary>
        /// Gets a list of terms that are similar in meaning to the user's
        /// query term.
        /// </summary>
        [JsonProperty(PropertyName = "similarTerms")]
        public IList<Query> SimilarTerms { get; private set; }

        /// <summary>
        /// Validate the object.
        /// </summary>
        /// <exception cref="ValidationException">
        /// Thrown if validation fails
        /// </exception>
        public virtual void Validate()
        {
            if (Value == null)
            {
                throw new ValidationException(ValidationRules.CannotBeNull, "Value");
            }
            if (QueryExpansions != null)
            {
                foreach (var element in QueryExpansions)
                {
                    if (element != null)
                    {
                        element.Validate();
                    }
                }
            }
            if (PivotSuggestions != null)
            {
                foreach (var element1 in PivotSuggestions)
                {
                    if (element1 != null)
                    {
                        element1.Validate();
                    }
                }
            }
            if (SimilarTerms != null)
            {
                foreach (var element2 in SimilarTerms)
                {
                    if (element2 != null)
                    {
                        element2.Validate();
                    }
                }
            }
        }
    }
}
