// <auto-generated>
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.
// </auto-generated>

namespace Microsoft.Azure.CognitiveServices.Search.ImageSearch.Models
{
    using Microsoft.Rest;
    using Newtonsoft.Json;
    using System.Collections;
    using System.Collections.Generic;
    using System.Linq;

    /// <summary>
    /// Defines an image's caption.
    /// </summary>
    public partial class ImageInsightsImageCaption
    {
        /// <summary>
        /// Initializes a new instance of the ImageInsightsImageCaption class.
        /// </summary>
        public ImageInsightsImageCaption()
        {
            CustomInit();
        }

        /// <summary>
        /// Initializes a new instance of the ImageInsightsImageCaption class.
        /// </summary>
        /// <param name="caption">A caption about the image.</param>
        /// <param name="dataSourceUrl">The URL to the website where the
        /// caption was found. You must attribute the caption to the source.
        /// For example, by displaying the domain name from the URL next to the
        /// caption and using the URL to link to the source website.</param>
        /// <param name="relatedSearches">A list of entities found in the
        /// caption. Use the contents of the Query object to find the entity in
        /// the caption and create a link. The link takes the user to images of
        /// the entity.</param>
        public ImageInsightsImageCaption(string caption, string dataSourceUrl, IList<Query> relatedSearches)
        {
            Caption = caption;
            DataSourceUrl = dataSourceUrl;
            RelatedSearches = relatedSearches;
            CustomInit();
        }

        /// <summary>
        /// An initialization method that performs custom operations like setting defaults
        /// </summary>
        partial void CustomInit();

        /// <summary>
        /// Gets or sets a caption about the image.
        /// </summary>
        [JsonProperty(PropertyName = "caption")]
        public string Caption { get; set; }

        /// <summary>
        /// Gets or sets the URL to the website where the caption was found.
        /// You must attribute the caption to the source. For example, by
        /// displaying the domain name from the URL next to the caption and
        /// using the URL to link to the source website.
        /// </summary>
        [JsonProperty(PropertyName = "dataSourceUrl")]
        public string DataSourceUrl { get; set; }

        /// <summary>
        /// Gets or sets a list of entities found in the caption. Use the
        /// contents of the Query object to find the entity in the caption and
        /// create a link. The link takes the user to images of the entity.
        /// </summary>
        [JsonProperty(PropertyName = "relatedSearches")]
        public IList<Query> RelatedSearches { get; set; }

        /// <summary>
        /// Validate the object.
        /// </summary>
        /// <exception cref="ValidationException">
        /// Thrown if validation fails
        /// </exception>
        public virtual void Validate()
        {
            if (Caption == null)
            {
                throw new ValidationException(ValidationRules.CannotBeNull, "Caption");
            }
            if (DataSourceUrl == null)
            {
                throw new ValidationException(ValidationRules.CannotBeNull, "DataSourceUrl");
            }
            if (RelatedSearches == null)
            {
                throw new ValidationException(ValidationRules.CannotBeNull, "RelatedSearches");
            }
            if (RelatedSearches != null)
            {
                foreach (var element in RelatedSearches)
                {
                    if (element != null)
                    {
                        element.Validate();
                    }
                }
            }
        }
    }
}
