// <auto-generated>
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.
// </auto-generated>

namespace Microsoft.Azure.CognitiveServices.Search.ImageSearch.Models
{
    using Newtonsoft.Json;
    using System.Linq;

    /// <summary>
    /// The top-level object that the response includes when an image insights
    /// request succeeds. For information about requesting image insights, see
    /// the
    /// [insightsToken](https://docs.microsoft.com/en-us/rest/api/cognitiveservices/bing-images-api-v7-reference#insightstoken)
    /// query parameter. The modules query parameter affects the fields that
    /// Bing includes in the response. If you set
    /// [modules](https://docs.microsoft.com/en-us/rest/api/cognitiveservices/bing-images-api-v7-reference#modulesrequested)
    /// to only Caption, then this object includes only the imageCaption field.
    /// </summary>
    public partial class ImageInsights : Response
    {
        /// <summary>
        /// Initializes a new instance of the ImageInsights class.
        /// </summary>
        public ImageInsights()
        {
            CustomInit();
        }

        /// <summary>
        /// Initializes a new instance of the ImageInsights class.
        /// </summary>
        /// <param name="id">A String identifier.</param>
        /// <param name="readLink">The URL that returns this resource.</param>
        /// <param name="webSearchUrl">The URL To Bing's search result for this
        /// item.</param>
        /// <param name="imageInsightsToken">A token that you use in a
        /// subsequent call to the Image Search API to get more information
        /// about the image. For information about using this token, see the
        /// insightsToken query parameter. This token has the same usage as the
        /// token in the Image object.</param>
        /// <param name="bestRepresentativeQuery">The query term that best
        /// represents the image. Clicking the link in the Query object, takes
        /// the user to a webpage with more pictures of the image.</param>
        /// <param name="imageCaption">The caption to use for the
        /// image.</param>
        /// <param name="relatedCollections">A list of links to webpages that
        /// contain related images.</param>
        /// <param name="pagesIncluding">A list of webpages that contain the
        /// image. To access the webpage, use the URL in the image's
        /// hostPageUrl field.</param>
        /// <param name="shoppingSources">A list of merchants that offer items
        /// related to the image. For example, if the image is of an apple pie,
        /// the list contains merchants that are selling apple pies.</param>
        /// <param name="relatedSearches">A list of related queries made by
        /// others.</param>
        /// <param name="recipes">A list of recipes related to the image. For
        /// example, if the image is of an apple pie, the list contains recipes
        /// for making an apple pie.</param>
        /// <param name="visuallySimilarImages">A list of images that are
        /// visually similar to the original image. For example, if the
        /// specified image is of a sunset over a body of water, the list of
        /// similar images are of a sunset over a body of water. If the
        /// specified image is of a person, similar images might be of the same
        /// person or they might be of persons dressed similarly or in a
        /// similar setting. The criteria for similarity continues to
        /// evolve.</param>
        /// <param name="visuallySimilarProducts">A list of images that contain
        /// products that are visually similar to products found in the
        /// original image. For example, if the specified image contains a
        /// dress, the list of similar images contain a dress. The image
        /// provides summary information about offers that Bing found online
        /// for the product.</param>
        /// <param name="recognizedEntityGroups">A list of groups that contain
        /// images of entities that match the entity found in the specified
        /// image. For example, the response might include images from the
        /// general celebrity group if the entity was recognized in that
        /// group.</param>
        /// <param name="imageTags">A list of characteristics of the content
        /// found in the image. For example, if the image is of a person, the
        /// tags might indicate the person's gender and the type of clothes
        /// they're wearing.</param>
        public ImageInsights(string id = default(string), string readLink = default(string), string webSearchUrl = default(string), string imageInsightsToken = default(string), Query bestRepresentativeQuery = default(Query), ImageInsightsImageCaption imageCaption = default(ImageInsightsImageCaption), RelatedCollectionsModule relatedCollections = default(RelatedCollectionsModule), ImagesModule pagesIncluding = default(ImagesModule), AggregateOffer shoppingSources = default(AggregateOffer), RelatedSearchesModule relatedSearches = default(RelatedSearchesModule), RecipesModule recipes = default(RecipesModule), ImagesModule visuallySimilarImages = default(ImagesModule), ImagesModule visuallySimilarProducts = default(ImagesModule), RecognizedEntitiesModule recognizedEntityGroups = default(RecognizedEntitiesModule), ImageTagsModule imageTags = default(ImageTagsModule))
            : base(id, readLink, webSearchUrl)
        {
            ImageInsightsToken = imageInsightsToken;
            BestRepresentativeQuery = bestRepresentativeQuery;
            ImageCaption = imageCaption;
            RelatedCollections = relatedCollections;
            PagesIncluding = pagesIncluding;
            ShoppingSources = shoppingSources;
            RelatedSearches = relatedSearches;
            Recipes = recipes;
            VisuallySimilarImages = visuallySimilarImages;
            VisuallySimilarProducts = visuallySimilarProducts;
            RecognizedEntityGroups = recognizedEntityGroups;
            ImageTags = imageTags;
            CustomInit();
        }

        /// <summary>
        /// An initialization method that performs custom operations like setting defaults
        /// </summary>
        partial void CustomInit();

        /// <summary>
        /// Gets a token that you use in a subsequent call to the Image Search
        /// API to get more information about the image. For information about
        /// using this token, see the insightsToken query parameter. This token
        /// has the same usage as the token in the Image object.
        /// </summary>
        [JsonProperty(PropertyName = "imageInsightsToken")]
        public string ImageInsightsToken { get; private set; }

        /// <summary>
        /// Gets the query term that best represents the image. Clicking the
        /// link in the Query object, takes the user to a webpage with more
        /// pictures of the image.
        /// </summary>
        [JsonProperty(PropertyName = "bestRepresentativeQuery")]
        public Query BestRepresentativeQuery { get; private set; }

        /// <summary>
        /// Gets the caption to use for the image.
        /// </summary>
        [JsonProperty(PropertyName = "imageCaption")]
        public ImageInsightsImageCaption ImageCaption { get; private set; }

        /// <summary>
        /// Gets a list of links to webpages that contain related images.
        /// </summary>
        [JsonProperty(PropertyName = "relatedCollections")]
        public RelatedCollectionsModule RelatedCollections { get; private set; }

        /// <summary>
        /// Gets a list of webpages that contain the image. To access the
        /// webpage, use the URL in the image's hostPageUrl field.
        /// </summary>
        [JsonProperty(PropertyName = "pagesIncluding")]
        public ImagesModule PagesIncluding { get; private set; }

        /// <summary>
        /// Gets a list of merchants that offer items related to the image. For
        /// example, if the image is of an apple pie, the list contains
        /// merchants that are selling apple pies.
        /// </summary>
        [JsonProperty(PropertyName = "shoppingSources")]
        public AggregateOffer ShoppingSources { get; private set; }

        /// <summary>
        /// Gets a list of related queries made by others.
        /// </summary>
        [JsonProperty(PropertyName = "relatedSearches")]
        public RelatedSearchesModule RelatedSearches { get; private set; }

        /// <summary>
        /// Gets a list of recipes related to the image. For example, if the
        /// image is of an apple pie, the list contains recipes for making an
        /// apple pie.
        /// </summary>
        [JsonProperty(PropertyName = "recipes")]
        public RecipesModule Recipes { get; private set; }

        /// <summary>
        /// Gets a list of images that are visually similar to the original
        /// image. For example, if the specified image is of a sunset over a
        /// body of water, the list of similar images are of a sunset over a
        /// body of water. If the specified image is of a person, similar
        /// images might be of the same person or they might be of persons
        /// dressed similarly or in a similar setting. The criteria for
        /// similarity continues to evolve.
        /// </summary>
        [JsonProperty(PropertyName = "visuallySimilarImages")]
        public ImagesModule VisuallySimilarImages { get; private set; }

        /// <summary>
        /// Gets a list of images that contain products that are visually
        /// similar to products found in the original image. For example, if
        /// the specified image contains a dress, the list of similar images
        /// contain a dress. The image provides summary information about
        /// offers that Bing found online for the product.
        /// </summary>
        [JsonProperty(PropertyName = "visuallySimilarProducts")]
        public ImagesModule VisuallySimilarProducts { get; private set; }

        /// <summary>
        /// Gets a list of groups that contain images of entities that match
        /// the entity found in the specified image. For example, the response
        /// might include images from the general celebrity group if the entity
        /// was recognized in that group.
        /// </summary>
        [JsonProperty(PropertyName = "recognizedEntityGroups")]
        public RecognizedEntitiesModule RecognizedEntityGroups { get; private set; }

        /// <summary>
        /// Gets a list of characteristics of the content found in the image.
        /// For example, if the image is of a person, the tags might indicate
        /// the person's gender and the type of clothes they're wearing.
        /// </summary>
        [JsonProperty(PropertyName = "imageTags")]
        public ImageTagsModule ImageTags { get; private set; }

        /// <summary>
        /// Validate the object.
        /// </summary>
        /// <exception cref="Rest.ValidationException">
        /// Thrown if validation fails
        /// </exception>
        public virtual void Validate()
        {
            if (BestRepresentativeQuery != null)
            {
                BestRepresentativeQuery.Validate();
            }
            if (ImageCaption != null)
            {
                ImageCaption.Validate();
            }
            if (ImageTags != null)
            {
                ImageTags.Validate();
            }
        }
    }
}
