// <auto-generated>
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for
// license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.
// </auto-generated>

namespace Microsoft.Azure.CognitiveServices.Personalizer
{
    using Microsoft.Rest;
    using Models;
    using System.Collections;
    using System.Collections.Generic;
    using System.Threading;
    using System.Threading.Tasks;

    /// <summary>
    /// Extension methods for ServiceConfigurationOperations.
    /// </summary>
    public static partial class ServiceConfigurationOperationsExtensions
    {
            /// <summary>
            /// Get Service Configuration.
            /// </summary>
            /// <remarks>
            /// Get the Personalizer service configuration.
            /// </remarks>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            public static ServiceConfiguration Get(this IServiceConfigurationOperations operations)
            {
                return operations.GetAsync().GetAwaiter().GetResult();
            }

            /// <summary>
            /// Get Service Configuration.
            /// </summary>
            /// <remarks>
            /// Get the Personalizer service configuration.
            /// </remarks>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<ServiceConfiguration> GetAsync(this IServiceConfigurationOperations operations, CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.GetWithHttpMessagesAsync(null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Get Service Configuration.
            /// </summary>
            /// <remarks>
            /// Get the Personalizer service configuration.
            /// </remarks>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='customHeaders'>
            /// Headers that will be added to request.
            /// </param>
            public static HttpOperationResponse<ServiceConfiguration> GetWithHttpMessages(this IServiceConfigurationOperations operations, Dictionary<string, List<string>> customHeaders = null)
            {
                return operations.GetWithHttpMessagesAsync(customHeaders, CancellationToken.None).ConfigureAwait(false).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Update Service Configuration.
            /// </summary>
            /// <remarks>
            /// Update the Personalizer service configuration.
            /// </remarks>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='config'>
            /// The personalizer service configuration.
            /// </param>
            public static ServiceConfiguration Update(this IServiceConfigurationOperations operations, ServiceConfiguration config)
            {
                return operations.UpdateAsync(config).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Update Service Configuration.
            /// </summary>
            /// <remarks>
            /// Update the Personalizer service configuration.
            /// </remarks>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='config'>
            /// The personalizer service configuration.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<ServiceConfiguration> UpdateAsync(this IServiceConfigurationOperations operations, ServiceConfiguration config, CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.UpdateWithHttpMessagesAsync(config, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Update Service Configuration.
            /// </summary>
            /// <remarks>
            /// Update the Personalizer service configuration.
            /// </remarks>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='config'>
            /// The personalizer service configuration.
            /// </param>
            /// <param name='customHeaders'>
            /// Headers that will be added to request.
            /// </param>
            public static HttpOperationResponse<ServiceConfiguration> UpdateWithHttpMessages(this IServiceConfigurationOperations operations, ServiceConfiguration config, Dictionary<string, List<string>> customHeaders = null)
            {
                return operations.UpdateWithHttpMessagesAsync(config, customHeaders, CancellationToken.None).ConfigureAwait(false).GetAwaiter().GetResult();
            }

    }
}
