// <auto-generated>
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for
// license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.
// </auto-generated>

namespace Microsoft.Azure.CognitiveServices.Personalizer
{
    using Microsoft.Rest;
    using Models;
    using System.Collections;
    using System.Collections.Generic;
    using System.Threading;
    using System.Threading.Tasks;

    /// <summary>
    /// Extension methods for Policy.
    /// </summary>
    public static partial class PolicyExtensions
    {
            /// <summary>
            /// Get Policy.
            /// </summary>
            /// <remarks>
            /// Get the Learning settings currently used by the Personalizer service.
            /// </remarks>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            public static PolicyContract Get(this IPolicy operations)
            {
                return operations.GetAsync().GetAwaiter().GetResult();
            }

            /// <summary>
            /// Get Policy.
            /// </summary>
            /// <remarks>
            /// Get the Learning settings currently used by the Personalizer service.
            /// </remarks>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<PolicyContract> GetAsync(this IPolicy operations, CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.GetWithHttpMessagesAsync(null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Get Policy.
            /// </summary>
            /// <remarks>
            /// Get the Learning settings currently used by the Personalizer service.
            /// </remarks>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='customHeaders'>
            /// Headers that will be added to request.
            /// </param>
            public static HttpOperationResponse<PolicyContract> GetWithHttpMessages(this IPolicy operations, Dictionary<string, List<string>> customHeaders = null)
            {
                return operations.GetWithHttpMessagesAsync(customHeaders, CancellationToken.None).ConfigureAwait(false).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Update Policy.
            /// </summary>
            /// <remarks>
            /// Update the Learning settings that the Personalizer service will use to
            /// train models.
            /// </remarks>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='policy'>
            /// The Learning settings.
            /// </param>
            public static PolicyContract Update(this IPolicy operations, PolicyContract policy)
            {
                return operations.UpdateAsync(policy).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Update Policy.
            /// </summary>
            /// <remarks>
            /// Update the Learning settings that the Personalizer service will use to
            /// train models.
            /// </remarks>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='policy'>
            /// The Learning settings.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<PolicyContract> UpdateAsync(this IPolicy operations, PolicyContract policy, CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.UpdateWithHttpMessagesAsync(policy, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Update Policy.
            /// </summary>
            /// <remarks>
            /// Update the Learning settings that the Personalizer service will use to
            /// train models.
            /// </remarks>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='policy'>
            /// The Learning settings.
            /// </param>
            /// <param name='customHeaders'>
            /// Headers that will be added to request.
            /// </param>
            public static HttpOperationResponse<PolicyContract> UpdateWithHttpMessages(this IPolicy operations, PolicyContract policy, Dictionary<string, List<string>> customHeaders = null)
            {
                return operations.UpdateWithHttpMessagesAsync(policy, customHeaders, CancellationToken.None).ConfigureAwait(false).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Reset Policy.
            /// </summary>
            /// <remarks>
            /// Resets the Learning settings of the Personalizer service to default.
            /// </remarks>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            public static PolicyContract Reset(this IPolicy operations)
            {
                return operations.ResetAsync().GetAwaiter().GetResult();
            }

            /// <summary>
            /// Reset Policy.
            /// </summary>
            /// <remarks>
            /// Resets the Learning settings of the Personalizer service to default.
            /// </remarks>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<PolicyContract> ResetAsync(this IPolicy operations, CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.ResetWithHttpMessagesAsync(null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Reset Policy.
            /// </summary>
            /// <remarks>
            /// Resets the Learning settings of the Personalizer service to default.
            /// </remarks>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='customHeaders'>
            /// Headers that will be added to request.
            /// </param>
            public static HttpOperationResponse<PolicyContract> ResetWithHttpMessages(this IPolicy operations, Dictionary<string, List<string>> customHeaders = null)
            {
                return operations.ResetWithHttpMessagesAsync(customHeaders, CancellationToken.None).ConfigureAwait(false).GetAwaiter().GetResult();
            }

    }
}
