// <auto-generated>
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for
// license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.
// </auto-generated>

namespace Microsoft.Azure.CognitiveServices.Personalizer.Models
{
    using Microsoft.Rest;
    using Newtonsoft.Json;
    using System.Linq;

    /// <summary>
    /// The configuration of the service.
    /// </summary>
    public partial class ServiceConfiguration
    {
        /// <summary>
        /// Initializes a new instance of the ServiceConfiguration class.
        /// </summary>
        public ServiceConfiguration()
        {
            CustomInit();
        }

        /// <summary>
        /// Initializes a new instance of the ServiceConfiguration class.
        /// </summary>
        /// <param name="rewardWaitTime">The time span waited until a request
        /// is marked with the default reward.
        /// For example, PT5M (5 mins). For information about the time format,
        /// see http://en.wikipedia.org/wiki/ISO_8601#Durations</param>
        /// <param name="defaultReward">The reward given if a reward is not
        /// received within the specified wait time.</param>
        /// <param name="rewardAggregation">The function used to process
        /// rewards, if multiple reward scores are received before
        /// rewardWaitTime is over.</param>
        /// <param name="explorationPercentage">The percentage of rank
        /// responses that will use exploration.</param>
        /// <param name="modelExportFrequency">Personalizer will start using
        /// the most updated trained model for online ranks automatically every
        /// specified time period.
        /// For example, PT5M (5 mins). For information about the time format,
        /// see http://en.wikipedia.org/wiki/ISO_8601#Durations</param>
        /// <param name="logRetentionDays">Number of days historical logs are
        /// to be maintained. -1 implies the logs will never be
        /// deleted.</param>
        /// <param name="logMirrorEnabled">Flag indicates whether log mirroring
        /// is enabled.</param>
        /// <param name="logMirrorSasUri">Azure storage account container SAS
        /// URI for log mirroring.</param>
        public ServiceConfiguration(System.TimeSpan rewardWaitTime, double defaultReward, string rewardAggregation, double explorationPercentage, System.TimeSpan modelExportFrequency, int logRetentionDays, bool? logMirrorEnabled = default(bool?), string logMirrorSasUri = default(string))
        {
            RewardWaitTime = rewardWaitTime;
            DefaultReward = defaultReward;
            RewardAggregation = rewardAggregation;
            ExplorationPercentage = explorationPercentage;
            ModelExportFrequency = modelExportFrequency;
            LogMirrorEnabled = logMirrorEnabled;
            LogMirrorSasUri = logMirrorSasUri;
            LogRetentionDays = logRetentionDays;
            CustomInit();
        }

        /// <summary>
        /// An initialization method that performs custom operations like setting defaults
        /// </summary>
        partial void CustomInit();

        /// <summary>
        /// Gets or sets the time span waited until a request is marked with
        /// the default reward.
        /// For example, PT5M (5 mins). For information about the time format,
        /// see http://en.wikipedia.org/wiki/ISO_8601#Durations
        /// </summary>
        [JsonProperty(PropertyName = "rewardWaitTime")]
        public System.TimeSpan RewardWaitTime { get; set; }

        /// <summary>
        /// Gets or sets the reward given if a reward is not received within
        /// the specified wait time.
        /// </summary>
        [JsonProperty(PropertyName = "defaultReward")]
        public double DefaultReward { get; set; }

        /// <summary>
        /// Gets or sets the function used to process rewards, if multiple
        /// reward scores are received before rewardWaitTime is over.
        /// </summary>
        [JsonProperty(PropertyName = "rewardAggregation")]
        public string RewardAggregation { get; set; }

        /// <summary>
        /// Gets or sets the percentage of rank responses that will use
        /// exploration.
        /// </summary>
        [JsonProperty(PropertyName = "explorationPercentage")]
        public double ExplorationPercentage { get; set; }

        /// <summary>
        /// Gets or sets personalizer will start using the most updated trained
        /// model for online ranks automatically every specified time period.
        /// For example, PT5M (5 mins). For information about the time format,
        /// see http://en.wikipedia.org/wiki/ISO_8601#Durations
        /// </summary>
        [JsonProperty(PropertyName = "modelExportFrequency")]
        public System.TimeSpan ModelExportFrequency { get; set; }

        /// <summary>
        /// Gets or sets flag indicates whether log mirroring is enabled.
        /// </summary>
        [JsonProperty(PropertyName = "logMirrorEnabled")]
        public bool? LogMirrorEnabled { get; set; }

        /// <summary>
        /// Gets or sets azure storage account container SAS URI for log
        /// mirroring.
        /// </summary>
        [JsonProperty(PropertyName = "logMirrorSasUri")]
        public string LogMirrorSasUri { get; set; }

        /// <summary>
        /// Gets or sets number of days historical logs are to be maintained.
        /// -1 implies the logs will never be deleted.
        /// </summary>
        [JsonProperty(PropertyName = "logRetentionDays")]
        public int LogRetentionDays { get; set; }

        /// <summary>
        /// Validate the object.
        /// </summary>
        /// <exception cref="ValidationException">
        /// Thrown if validation fails
        /// </exception>
        public virtual void Validate()
        {
            if (RewardAggregation == null)
            {
                throw new ValidationException(ValidationRules.CannotBeNull, "RewardAggregation");
            }
            if (DefaultReward > 1)
            {
                throw new ValidationException(ValidationRules.InclusiveMaximum, "DefaultReward", 1);
            }
            if (DefaultReward < -1)
            {
                throw new ValidationException(ValidationRules.InclusiveMinimum, "DefaultReward", -1);
            }
            if (RewardAggregation != null)
            {
                if (RewardAggregation.Length > 256)
                {
                    throw new ValidationException(ValidationRules.MaxLength, "RewardAggregation", 256);
                }
            }
            if (ExplorationPercentage > 1)
            {
                throw new ValidationException(ValidationRules.InclusiveMaximum, "ExplorationPercentage", 1);
            }
            if (ExplorationPercentage < 0)
            {
                throw new ValidationException(ValidationRules.InclusiveMinimum, "ExplorationPercentage", 0);
            }
            if (LogRetentionDays > 2147483647)
            {
                throw new ValidationException(ValidationRules.InclusiveMaximum, "LogRetentionDays", 2147483647);
            }
            if (LogRetentionDays < -1)
            {
                throw new ValidationException(ValidationRules.InclusiveMinimum, "LogRetentionDays", -1);
            }
        }
    }
}
