// <auto-generated>
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for
// license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.
// </auto-generated>

namespace Microsoft.Azure.CognitiveServices.Personalizer.Models
{
    using Microsoft.Rest;
    using Newtonsoft.Json;
    using System.Collections;
    using System.Collections.Generic;
    using System.Linq;

    /// <summary>
    /// An action with it's associated features used for ranking.
    /// </summary>
    public partial class RankableAction
    {
        /// <summary>
        /// Initializes a new instance of the RankableAction class.
        /// </summary>
        public RankableAction()
        {
            CustomInit();
        }

        /// <summary>
        /// Initializes a new instance of the RankableAction class.
        /// </summary>
        /// <param name="id">Id of the action.</param>
        /// <param name="features">List of dictionaries containing
        /// features.</param>
        public RankableAction(string id, IList<object> features)
        {
            Id = id;
            Features = features;
            CustomInit();
        }

        /// <summary>
        /// An initialization method that performs custom operations like setting defaults
        /// </summary>
        partial void CustomInit();

        /// <summary>
        /// Gets or sets id of the action.
        /// </summary>
        [JsonProperty(PropertyName = "id")]
        public string Id { get; set; }

        /// <summary>
        /// Gets or sets list of dictionaries containing features.
        /// </summary>
        [JsonProperty(PropertyName = "features")]
        public IList<object> Features { get; set; }

        /// <summary>
        /// Validate the object.
        /// </summary>
        /// <exception cref="ValidationException">
        /// Thrown if validation fails
        /// </exception>
        public virtual void Validate()
        {
            if (Id == null)
            {
                throw new ValidationException(ValidationRules.CannotBeNull, "Id");
            }
            if (Features == null)
            {
                throw new ValidationException(ValidationRules.CannotBeNull, "Features");
            }
            if (Id != null)
            {
                if (Id.Length > 256)
                {
                    throw new ValidationException(ValidationRules.MaxLength, "Id", 256);
                }
            }
        }
    }
}
