// <auto-generated>
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for
// license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.
// </auto-generated>

namespace Microsoft.Azure.CognitiveServices.Personalizer.Models
{
    using Microsoft.Rest;
    using Newtonsoft.Json;
    using System.Collections;
    using System.Collections.Generic;
    using System.Linq;

    /// <summary>
    /// Returns which action to use as rewardActionId, and additional
    /// information about each action as a result of a Rank request.
    /// </summary>
    public partial class RankResponse
    {
        /// <summary>
        /// Initializes a new instance of the RankResponse class.
        /// </summary>
        public RankResponse()
        {
            CustomInit();
        }

        /// <summary>
        /// Initializes a new instance of the RankResponse class.
        /// </summary>
        /// <param name="ranking">The calculated ranking for the current
        /// request.</param>
        /// <param name="eventId">The eventId for the round trip from request
        /// to response.</param>
        /// <param name="rewardActionId">The action chosen by the Personalizer
        /// service. This is the action your application should display, and
        /// for which to report the reward. This might not be the
        /// first found in 'ranking' if an action in the request in first
        /// position was part of the excluded ids.</param>
        public RankResponse(IList<RankedAction> ranking = default(IList<RankedAction>), string eventId = default(string), string rewardActionId = default(string))
        {
            Ranking = ranking;
            EventId = eventId;
            RewardActionId = rewardActionId;
            CustomInit();
        }

        /// <summary>
        /// An initialization method that performs custom operations like setting defaults
        /// </summary>
        partial void CustomInit();

        /// <summary>
        /// Gets the calculated ranking for the current request.
        /// </summary>
        [JsonProperty(PropertyName = "ranking")]
        public IList<RankedAction> Ranking { get; private set; }

        /// <summary>
        /// Gets the eventId for the round trip from request to response.
        /// </summary>
        [JsonProperty(PropertyName = "eventId")]
        public string EventId { get; private set; }

        /// <summary>
        /// Gets the action chosen by the Personalizer service. This is the
        /// action your application should display, and for which to report the
        /// reward. This might not be the
        /// first found in 'ranking' if an action in the request in first
        /// position was part of the excluded ids.
        /// </summary>
        [JsonProperty(PropertyName = "rewardActionId")]
        public string RewardActionId { get; private set; }

        /// <summary>
        /// Validate the object.
        /// </summary>
        /// <exception cref="ValidationException">
        /// Thrown if validation fails
        /// </exception>
        public virtual void Validate()
        {
            if (Ranking != null)
            {
                foreach (var element in Ranking)
                {
                    if (element != null)
                    {
                        element.Validate();
                    }
                }
            }
            if (EventId != null)
            {
                if (EventId.Length > 256)
                {
                    throw new ValidationException(ValidationRules.MaxLength, "EventId", 256);
                }
            }
            if (RewardActionId != null)
            {
                if (RewardActionId.Length > 256)
                {
                    throw new ValidationException(ValidationRules.MaxLength, "RewardActionId", 256);
                }
            }
        }
    }
}
