// <auto-generated>
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for
// license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.
// </auto-generated>

namespace Microsoft.Azure.CognitiveServices.Personalizer.Models
{
    using Microsoft.Rest;
    using Newtonsoft.Json;
    using System.Linq;

    /// <summary>
    /// Learning settings specifying how to train the model.
    /// </summary>
    public partial class PolicyContract
    {
        /// <summary>
        /// Initializes a new instance of the PolicyContract class.
        /// </summary>
        public PolicyContract()
        {
            CustomInit();
        }

        /// <summary>
        /// Initializes a new instance of the PolicyContract class.
        /// </summary>
        /// <param name="name">Name of the Learning settings.</param>
        /// <param name="arguments">Arguments of the Learning settings.</param>
        public PolicyContract(string name, string arguments)
        {
            Name = name;
            Arguments = arguments;
            CustomInit();
        }

        /// <summary>
        /// An initialization method that performs custom operations like setting defaults
        /// </summary>
        partial void CustomInit();

        /// <summary>
        /// Gets or sets name of the Learning settings.
        /// </summary>
        [JsonProperty(PropertyName = "name")]
        public string Name { get; set; }

        /// <summary>
        /// Gets or sets arguments of the Learning settings.
        /// </summary>
        [JsonProperty(PropertyName = "arguments")]
        public string Arguments { get; set; }

        /// <summary>
        /// Validate the object.
        /// </summary>
        /// <exception cref="ValidationException">
        /// Thrown if validation fails
        /// </exception>
        public virtual void Validate()
        {
            if (Name == null)
            {
                throw new ValidationException(ValidationRules.CannotBeNull, "Name");
            }
            if (Arguments == null)
            {
                throw new ValidationException(ValidationRules.CannotBeNull, "Arguments");
            }
            if (Name != null)
            {
                if (Name.Length > 256)
                {
                    throw new ValidationException(ValidationRules.MaxLength, "Name", 256);
                }
            }
            if (Arguments != null)
            {
                if (Arguments.Length > 1024)
                {
                    throw new ValidationException(ValidationRules.MaxLength, "Arguments", 1024);
                }
            }
        }
    }
}
