// <auto-generated>
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for
// license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.
// </auto-generated>

namespace Microsoft.Azure.CognitiveServices.Personalizer.Models
{
    using Microsoft.Rest;
    using Newtonsoft.Json;
    using System.Collections;
    using System.Collections.Generic;
    using System.Linq;

    /// <summary>
    /// The error object.
    /// </summary>
    public partial class PersonalizerError
    {
        /// <summary>
        /// Initializes a new instance of the PersonalizerError class.
        /// </summary>
        public PersonalizerError()
        {
            CustomInit();
        }

        /// <summary>
        /// Initializes a new instance of the PersonalizerError class.
        /// </summary>
        /// <param name="code">High level error code. Possible values include:
        /// 'BadRequest', 'ResourceNotFound', 'InternalServerError',
        /// 'InvalidServiceConfiguration', 'InvalidPolicyConfiguration',
        /// 'InvalidPolicyContract', 'InvalidEvaluationContract',
        /// 'InvalidRewardRequest', 'InvalidEventIdToActivate',
        /// 'InvalidRankRequest', 'InvalidExportLogsRequest',
        /// 'InvalidContainer', 'FrontEndNotFound', 'EvaluationNotFound',
        /// 'LogsPropertiesNotFound', 'RankNullResponse',
        /// 'UpdateConfigurationFailed', 'ModelResetFailed'</param>
        /// <param name="message">A message explaining the error reported by
        /// the service.</param>
        /// <param name="target">Error source element.</param>
        /// <param name="details">An array of details about specific errors
        /// that led to this reported error.</param>
        /// <param name="innerError">Finer error details.</param>
        public PersonalizerError(string code, string message, string target = default(string), IList<PersonalizerError> details = default(IList<PersonalizerError>), InternalError innerError = default(InternalError))
        {
            Code = code;
            Message = message;
            Target = target;
            Details = details;
            InnerError = innerError;
            CustomInit();
        }

        /// <summary>
        /// An initialization method that performs custom operations like setting defaults
        /// </summary>
        partial void CustomInit();

        /// <summary>
        /// Gets or sets high level error code. Possible values include:
        /// 'BadRequest', 'ResourceNotFound', 'InternalServerError',
        /// 'InvalidServiceConfiguration', 'InvalidPolicyConfiguration',
        /// 'InvalidPolicyContract', 'InvalidEvaluationContract',
        /// 'InvalidRewardRequest', 'InvalidEventIdToActivate',
        /// 'InvalidRankRequest', 'InvalidExportLogsRequest',
        /// 'InvalidContainer', 'FrontEndNotFound', 'EvaluationNotFound',
        /// 'LogsPropertiesNotFound', 'RankNullResponse',
        /// 'UpdateConfigurationFailed', 'ModelResetFailed'
        /// </summary>
        [JsonProperty(PropertyName = "code")]
        public string Code { get; set; }

        /// <summary>
        /// Gets or sets a message explaining the error reported by the
        /// service.
        /// </summary>
        [JsonProperty(PropertyName = "message")]
        public string Message { get; set; }

        /// <summary>
        /// Gets or sets error source element.
        /// </summary>
        [JsonProperty(PropertyName = "target")]
        public string Target { get; set; }

        /// <summary>
        /// Gets or sets an array of details about specific errors that led to
        /// this reported error.
        /// </summary>
        [JsonProperty(PropertyName = "details")]
        public IList<PersonalizerError> Details { get; set; }

        /// <summary>
        /// Gets or sets finer error details.
        /// </summary>
        [JsonProperty(PropertyName = "innerError")]
        public InternalError InnerError { get; set; }

        /// <summary>
        /// Validate the object.
        /// </summary>
        /// <exception cref="ValidationException">
        /// Thrown if validation fails
        /// </exception>
        public virtual void Validate()
        {
            if (Code == null)
            {
                throw new ValidationException(ValidationRules.CannotBeNull, "Code");
            }
            if (Message == null)
            {
                throw new ValidationException(ValidationRules.CannotBeNull, "Message");
            }
            if (Details != null)
            {
                foreach (var element in Details)
                {
                    if (element != null)
                    {
                        element.Validate();
                    }
                }
            }
        }
    }
}
