// <auto-generated>
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for
// license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.
// </auto-generated>

namespace Microsoft.Azure.CognitiveServices.Personalizer.Models
{
    using Microsoft.Rest;
    using Newtonsoft.Json;
    using System.Collections;
    using System.Collections.Generic;
    using System.Linq;

    /// <summary>
    /// A counterfactual evaluation.
    /// </summary>
    public partial class EvaluationContract
    {
        /// <summary>
        /// Initializes a new instance of the EvaluationContract class.
        /// </summary>
        public EvaluationContract()
        {
            CustomInit();
        }

        /// <summary>
        /// Initializes a new instance of the EvaluationContract class.
        /// </summary>
        /// <param name="name">The name of the evaluation.</param>
        /// <param name="startTime">The start time of the evaluation.</param>
        /// <param name="endTime">The end time of the evaluation.</param>
        /// <param name="policies">Additional Learning settings to
        /// evaluate.</param>
        /// <param name="enableOfflineExperimentation">True if the evaluation
        /// should explore for a more optimal Learning settings.</param>
        public EvaluationContract(string name, System.DateTime startTime, System.DateTime endTime, IList<PolicyContract> policies, bool? enableOfflineExperimentation = default(bool?))
        {
            EnableOfflineExperimentation = enableOfflineExperimentation;
            Name = name;
            StartTime = startTime;
            EndTime = endTime;
            Policies = policies;
            CustomInit();
        }

        /// <summary>
        /// An initialization method that performs custom operations like setting defaults
        /// </summary>
        partial void CustomInit();

        /// <summary>
        /// Gets or sets true if the evaluation should explore for a more
        /// optimal Learning settings.
        /// </summary>
        [JsonProperty(PropertyName = "enableOfflineExperimentation")]
        public bool? EnableOfflineExperimentation { get; set; }

        /// <summary>
        /// Gets or sets the name of the evaluation.
        /// </summary>
        [JsonProperty(PropertyName = "name")]
        public string Name { get; set; }

        /// <summary>
        /// Gets or sets the start time of the evaluation.
        /// </summary>
        [JsonProperty(PropertyName = "startTime")]
        public System.DateTime StartTime { get; set; }

        /// <summary>
        /// Gets or sets the end time of the evaluation.
        /// </summary>
        [JsonProperty(PropertyName = "endTime")]
        public System.DateTime EndTime { get; set; }

        /// <summary>
        /// Gets or sets additional Learning settings to evaluate.
        /// </summary>
        [JsonProperty(PropertyName = "policies")]
        public IList<PolicyContract> Policies { get; set; }

        /// <summary>
        /// Validate the object.
        /// </summary>
        /// <exception cref="ValidationException">
        /// Thrown if validation fails
        /// </exception>
        public virtual void Validate()
        {
            if (Name == null)
            {
                throw new ValidationException(ValidationRules.CannotBeNull, "Name");
            }
            if (Policies == null)
            {
                throw new ValidationException(ValidationRules.CannotBeNull, "Policies");
            }
            if (Name != null)
            {
                if (Name.Length > 256)
                {
                    throw new ValidationException(ValidationRules.MaxLength, "Name", 256);
                }
            }
            if (Policies != null)
            {
                foreach (var element in Policies)
                {
                    if (element != null)
                    {
                        element.Validate();
                    }
                }
            }
        }
    }
}
