// <auto-generated>
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for
// license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.
// </auto-generated>

namespace Microsoft.Azure.CognitiveServices.Personalizer
{
    using Microsoft.Rest;
    using Models;
    using System.Collections;
    using System.Collections.Generic;
    using System.IO;
    using System.Threading;
    using System.Threading.Tasks;

    /// <summary>
    /// Extension methods for Model.
    /// </summary>
    public static partial class ModelExtensions
    {
            /// <summary>
            /// Get Model.
            /// </summary>
            /// <remarks>
            /// Get the model file generated by Personalizer service.
            /// </remarks>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            public static Stream Get(this IModel operations)
            {
                return operations.GetAsync().GetAwaiter().GetResult();
            }

            /// <summary>
            /// Get Model.
            /// </summary>
            /// <remarks>
            /// Get the model file generated by Personalizer service.
            /// </remarks>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<Stream> GetAsync(this IModel operations, CancellationToken cancellationToken = default(CancellationToken))
            {
                var _result = await operations.GetWithHttpMessagesAsync(null, cancellationToken).ConfigureAwait(false);
                _result.Request.Dispose();
                return _result.Body;
            }

            /// <summary>
            /// Get Model.
            /// </summary>
            /// <remarks>
            /// Get the model file generated by Personalizer service.
            /// </remarks>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='customHeaders'>
            /// Headers that will be added to request.
            /// </param>
            public static HttpOperationResponse<Stream> GetWithHttpMessages(this IModel operations, Dictionary<string, List<string>> customHeaders = null)
            {
                return operations.GetWithHttpMessagesAsync(customHeaders, CancellationToken.None).ConfigureAwait(false).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Reset Model.
            /// </summary>
            /// <remarks>
            /// Resets the model file generated by Personalizer service.
            /// </remarks>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            public static void Reset(this IModel operations)
            {
                operations.ResetAsync().GetAwaiter().GetResult();
            }

            /// <summary>
            /// Reset Model.
            /// </summary>
            /// <remarks>
            /// Resets the model file generated by Personalizer service.
            /// </remarks>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task ResetAsync(this IModel operations, CancellationToken cancellationToken = default(CancellationToken))
            {
                (await operations.ResetWithHttpMessagesAsync(null, cancellationToken).ConfigureAwait(false)).Dispose();
            }

            /// <summary>
            /// Reset Model.
            /// </summary>
            /// <remarks>
            /// Resets the model file generated by Personalizer service.
            /// </remarks>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='customHeaders'>
            /// Headers that will be added to request.
            /// </param>
            public static HttpOperationResponse ResetWithHttpMessages(this IModel operations, Dictionary<string, List<string>> customHeaders = null)
            {
                return operations.ResetWithHttpMessagesAsync(customHeaders, CancellationToken.None).ConfigureAwait(false).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Get Model Properties.
            /// </summary>
            /// <remarks>
            /// Get properties of the model file generated by Personalizer service.
            /// </remarks>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            public static ModelProperties GetProperties(this IModel operations)
            {
                return operations.GetPropertiesAsync().GetAwaiter().GetResult();
            }

            /// <summary>
            /// Get Model Properties.
            /// </summary>
            /// <remarks>
            /// Get properties of the model file generated by Personalizer service.
            /// </remarks>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<ModelProperties> GetPropertiesAsync(this IModel operations, CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.GetPropertiesWithHttpMessagesAsync(null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Get Model Properties.
            /// </summary>
            /// <remarks>
            /// Get properties of the model file generated by Personalizer service.
            /// </remarks>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='customHeaders'>
            /// Headers that will be added to request.
            /// </param>
            public static HttpOperationResponse<ModelProperties> GetPropertiesWithHttpMessages(this IModel operations, Dictionary<string, List<string>> customHeaders = null)
            {
                return operations.GetPropertiesWithHttpMessagesAsync(customHeaders, CancellationToken.None).ConfigureAwait(false).GetAwaiter().GetResult();
            }

    }
}
