// <auto-generated>
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for
// license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.
// </auto-generated>

namespace Microsoft.Azure.CognitiveServices.Personalizer
{
    using Microsoft.Rest;
    using Models;
    using System.Collections;
    using System.Collections.Generic;
    using System.Threading;
    using System.Threading.Tasks;

    /// <summary>
    /// Extension methods for Events.
    /// </summary>
    public static partial class EventsExtensions
    {
            /// <summary>
            /// Post Reward.
            /// </summary>
            /// <remarks>
            /// Report reward that resulted from using the action specified in
            /// rewardActionId for the specified event.
            /// </remarks>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='eventId'>
            /// The event id this reward applies to.
            /// </param>
            /// <param name='reward'>
            /// The reward should be a floating point number, typically between 0 and 1.
            /// </param>
            public static void Reward(this IEvents operations, string eventId, RewardRequest reward)
            {
                operations.RewardAsync(eventId, reward).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Post Reward.
            /// </summary>
            /// <remarks>
            /// Report reward that resulted from using the action specified in
            /// rewardActionId for the specified event.
            /// </remarks>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='eventId'>
            /// The event id this reward applies to.
            /// </param>
            /// <param name='reward'>
            /// The reward should be a floating point number, typically between 0 and 1.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task RewardAsync(this IEvents operations, string eventId, RewardRequest reward, CancellationToken cancellationToken = default(CancellationToken))
            {
                (await operations.RewardWithHttpMessagesAsync(eventId, reward, null, cancellationToken).ConfigureAwait(false)).Dispose();
            }

            /// <summary>
            /// Post Reward.
            /// </summary>
            /// <remarks>
            /// Report reward that resulted from using the action specified in
            /// rewardActionId for the specified event.
            /// </remarks>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='eventId'>
            /// The event id this reward applies to.
            /// </param>
            /// <param name='reward'>
            /// The reward should be a floating point number, typically between 0 and 1.
            /// </param>
            /// <param name='customHeaders'>
            /// Headers that will be added to request.
            /// </param>
            public static HttpOperationResponse RewardWithHttpMessages(this IEvents operations, string eventId, RewardRequest reward, Dictionary<string, List<string>> customHeaders = null)
            {
                return operations.RewardWithHttpMessagesAsync(eventId, reward, customHeaders, CancellationToken.None).ConfigureAwait(false).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Activate Event.
            /// </summary>
            /// <remarks>
            /// Report that the specified event was actually displayed to the user and a
            /// reward should be expected for it
            /// </remarks>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='eventId'>
            /// The event ID this activation applies to.
            /// </param>
            public static void Activate(this IEvents operations, string eventId)
            {
                operations.ActivateAsync(eventId).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Activate Event.
            /// </summary>
            /// <remarks>
            /// Report that the specified event was actually displayed to the user and a
            /// reward should be expected for it
            /// </remarks>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='eventId'>
            /// The event ID this activation applies to.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task ActivateAsync(this IEvents operations, string eventId, CancellationToken cancellationToken = default(CancellationToken))
            {
                (await operations.ActivateWithHttpMessagesAsync(eventId, null, cancellationToken).ConfigureAwait(false)).Dispose();
            }

            /// <summary>
            /// Activate Event.
            /// </summary>
            /// <remarks>
            /// Report that the specified event was actually displayed to the user and a
            /// reward should be expected for it
            /// </remarks>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='eventId'>
            /// The event ID this activation applies to.
            /// </param>
            /// <param name='customHeaders'>
            /// Headers that will be added to request.
            /// </param>
            public static HttpOperationResponse ActivateWithHttpMessages(this IEvents operations, string eventId, Dictionary<string, List<string>> customHeaders = null)
            {
                return operations.ActivateWithHttpMessagesAsync(eventId, customHeaders, CancellationToken.None).ConfigureAwait(false).GetAwaiter().GetResult();
            }

    }
}
