// <auto-generated>
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for
// license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.
// </auto-generated>

namespace Microsoft.Azure.CognitiveServices.Language.TextAnalytics.Models
{
    using Newtonsoft.Json;
    using System.Collections;
    using System.Collections.Generic;
    using System.Linq;

    public partial class EntityRecord
    {
        /// <summary>
        /// Initializes a new instance of the EntityRecord class.
        /// </summary>
        public EntityRecord()
        {
            CustomInit();
        }

        /// <summary>
        /// Initializes a new instance of the EntityRecord class.
        /// </summary>
        /// <param name="name">Entity formal name.</param>
        /// <param name="matches">List of instances this entity appears in the
        /// text.</param>
        /// <param name="wikipediaLanguage">Wikipedia language for which the
        /// WikipediaId and WikipediaUrl refers to.</param>
        /// <param name="wikipediaId">Wikipedia unique identifier of the
        /// recognized entity.</param>
        /// <param name="wikipediaUrl">URL for the entity's Wikipedia
        /// page.</param>
        /// <param name="bingId">Bing unique identifier of the recognized
        /// entity. Use in conjunction with the Bing Entity Search API to fetch
        /// additional relevant information.</param>
        /// <param name="type">Entity type from Named Entity Recognition
        /// model</param>
        /// <param name="subType">Entity sub type from Named Entity Recognition
        /// model</param>
        public EntityRecord(string name = default(string), IList<MatchRecord> matches = default(IList<MatchRecord>), string wikipediaLanguage = default(string), string wikipediaId = default(string), string wikipediaUrl = default(string), string bingId = default(string), string type = default(string), string subType = default(string))
        {
            Name = name;
            Matches = matches;
            WikipediaLanguage = wikipediaLanguage;
            WikipediaId = wikipediaId;
            WikipediaUrl = wikipediaUrl;
            BingId = bingId;
            Type = type;
            SubType = subType;
            CustomInit();
        }

        /// <summary>
        /// An initialization method that performs custom operations like setting defaults
        /// </summary>
        partial void CustomInit();

        /// <summary>
        /// Gets or sets entity formal name.
        /// </summary>
        [JsonProperty(PropertyName = "name")]
        public string Name { get; set; }

        /// <summary>
        /// Gets or sets list of instances this entity appears in the text.
        /// </summary>
        [JsonProperty(PropertyName = "matches")]
        public IList<MatchRecord> Matches { get; set; }

        /// <summary>
        /// Gets or sets wikipedia language for which the WikipediaId and
        /// WikipediaUrl refers to.
        /// </summary>
        [JsonProperty(PropertyName = "wikipediaLanguage")]
        public string WikipediaLanguage { get; set; }

        /// <summary>
        /// Gets or sets wikipedia unique identifier of the recognized entity.
        /// </summary>
        [JsonProperty(PropertyName = "wikipediaId")]
        public string WikipediaId { get; set; }

        /// <summary>
        /// Gets URL for the entity's Wikipedia page.
        /// </summary>
        [JsonProperty(PropertyName = "wikipediaUrl")]
        public string WikipediaUrl { get; private set; }

        /// <summary>
        /// Gets or sets bing unique identifier of the recognized entity. Use
        /// in conjunction with the Bing Entity Search API to fetch additional
        /// relevant information.
        /// </summary>
        [JsonProperty(PropertyName = "bingId")]
        public string BingId { get; set; }

        /// <summary>
        /// Gets or sets entity type from Named Entity Recognition model
        /// </summary>
        [JsonProperty(PropertyName = "type")]
        public string Type { get; set; }

        /// <summary>
        /// Gets or sets entity sub type from Named Entity Recognition model
        /// </summary>
        [JsonProperty(PropertyName = "subType")]
        public string SubType { get; set; }

    }
}
