// <auto-generated>
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for
// license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.
// </auto-generated>

namespace Microsoft.Azure.CognitiveServices.Language.TextAnalytics.Models
{
    using Newtonsoft.Json;
    using System.Linq;

    public partial class DetectedLanguage
    {
        /// <summary>
        /// Initializes a new instance of the DetectedLanguage class.
        /// </summary>
        public DetectedLanguage()
        {
            CustomInit();
        }

        /// <summary>
        /// Initializes a new instance of the DetectedLanguage class.
        /// </summary>
        /// <param name="name">Long name of a detected language (e.g. English,
        /// French).</param>
        /// <param name="iso6391Name">A two letter representation of the
        /// detected language according to the ISO 639-1 standard (e.g. en,
        /// fr).</param>
        /// <param name="score">A confidence score between 0 and 1. Scores
        /// close to 1 indicate 100% certainty that the identified language is
        /// true.</param>
        public DetectedLanguage(string name = default(string), string iso6391Name = default(string), double? score = default(double?))
        {
            Name = name;
            Iso6391Name = iso6391Name;
            Score = score;
            CustomInit();
        }

        /// <summary>
        /// An initialization method that performs custom operations like setting defaults
        /// </summary>
        partial void CustomInit();

        /// <summary>
        /// Gets or sets long name of a detected language (e.g. English,
        /// French).
        /// </summary>
        [JsonProperty(PropertyName = "name")]
        public string Name { get; set; }

        /// <summary>
        /// Gets or sets a two letter representation of the detected language
        /// according to the ISO 639-1 standard (e.g. en, fr).
        /// </summary>
        [JsonProperty(PropertyName = "iso6391Name")]
        public string Iso6391Name { get; set; }

        /// <summary>
        /// Gets or sets a confidence score between 0 and 1. Scores close to 1
        /// indicate 100% certainty that the identified language is true.
        /// </summary>
        [JsonProperty(PropertyName = "score")]
        public double? Score { get; set; }

    }
}
