// <auto-generated>
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for
// license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.
// </auto-generated>

namespace Microsoft.Azure.CognitiveServices.Language.LUIS.Runtime.Models
{
    using Microsoft.Rest;
    using Newtonsoft.Json;
    using System.Collections;
    using System.Collections.Generic;
    using System.Linq;

    /// <summary>
    /// Defines a sub-list to append to an existing list entity.
    /// </summary>
    public partial class RequestList
    {
        /// <summary>
        /// Initializes a new instance of the RequestList class.
        /// </summary>
        public RequestList()
        {
            CustomInit();
        }

        /// <summary>
        /// Initializes a new instance of the RequestList class.
        /// </summary>
        /// <param name="canonicalForm">The canonical form of the
        /// sub-list.</param>
        /// <param name="name">The name of the sub-list.</param>
        /// <param name="synonyms">The synonyms of the canonical form.</param>
        public RequestList(string canonicalForm, string name = default(string), IList<string> synonyms = default(IList<string>))
        {
            Name = name;
            CanonicalForm = canonicalForm;
            Synonyms = synonyms;
            CustomInit();
        }

        /// <summary>
        /// An initialization method that performs custom operations like setting defaults
        /// </summary>
        partial void CustomInit();

        /// <summary>
        /// Gets or sets the name of the sub-list.
        /// </summary>
        [JsonProperty(PropertyName = "name")]
        public string Name { get; set; }

        /// <summary>
        /// Gets or sets the canonical form of the sub-list.
        /// </summary>
        [JsonProperty(PropertyName = "canonicalForm")]
        public string CanonicalForm { get; set; }

        /// <summary>
        /// Gets or sets the synonyms of the canonical form.
        /// </summary>
        [JsonProperty(PropertyName = "synonyms")]
        public IList<string> Synonyms { get; set; }

        /// <summary>
        /// Validate the object.
        /// </summary>
        /// <exception cref="ValidationException">
        /// Thrown if validation fails
        /// </exception>
        public virtual void Validate()
        {
            if (CanonicalForm == null)
            {
                throw new ValidationException(ValidationRules.CannotBeNull, "CanonicalForm");
            }
        }
    }
}
