// <auto-generated>
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for
// license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.
// </auto-generated>

namespace Microsoft.Azure.CognitiveServices.Language.LUIS.Runtime.Models
{
    using Microsoft.Rest;
    using Newtonsoft.Json;
    using System.Collections;
    using System.Collections.Generic;
    using System.Linq;

    /// <summary>
    /// Represents the prediction request parameters.
    /// </summary>
    public partial class PredictionRequest
    {
        /// <summary>
        /// Initializes a new instance of the PredictionRequest class.
        /// </summary>
        public PredictionRequest()
        {
            CustomInit();
        }

        /// <summary>
        /// Initializes a new instance of the PredictionRequest class.
        /// </summary>
        /// <param name="query">The query to predict.</param>
        /// <param name="options">The custom options defined for this
        /// request.</param>
        /// <param name="externalEntities">The externally predicted entities
        /// for this request.</param>
        /// <param name="dynamicLists">The dynamically created list entities
        /// for this request.</param>
        public PredictionRequest(string query, PredictionRequestOptions options = default(PredictionRequestOptions), IList<ExternalEntity> externalEntities = default(IList<ExternalEntity>), IList<DynamicList> dynamicLists = default(IList<DynamicList>))
        {
            Query = query;
            Options = options;
            ExternalEntities = externalEntities;
            DynamicLists = dynamicLists;
            CustomInit();
        }

        /// <summary>
        /// An initialization method that performs custom operations like setting defaults
        /// </summary>
        partial void CustomInit();

        /// <summary>
        /// Gets or sets the query to predict.
        /// </summary>
        [JsonProperty(PropertyName = "query")]
        public string Query { get; set; }

        /// <summary>
        /// Gets or sets the custom options defined for this request.
        /// </summary>
        [JsonProperty(PropertyName = "options")]
        public PredictionRequestOptions Options { get; set; }

        /// <summary>
        /// Gets or sets the externally predicted entities for this request.
        /// </summary>
        [JsonProperty(PropertyName = "externalEntities")]
        public IList<ExternalEntity> ExternalEntities { get; set; }

        /// <summary>
        /// Gets or sets the dynamically created list entities for this
        /// request.
        /// </summary>
        [JsonProperty(PropertyName = "dynamicLists")]
        public IList<DynamicList> DynamicLists { get; set; }

        /// <summary>
        /// Validate the object.
        /// </summary>
        /// <exception cref="ValidationException">
        /// Thrown if validation fails
        /// </exception>
        public virtual void Validate()
        {
            if (Query == null)
            {
                throw new ValidationException(ValidationRules.CannotBeNull, "Query");
            }
            if (ExternalEntities != null)
            {
                foreach (var element in ExternalEntities)
                {
                    if (element != null)
                    {
                        element.Validate();
                    }
                }
            }
            if (DynamicLists != null)
            {
                foreach (var element1 in DynamicLists)
                {
                    if (element1 != null)
                    {
                        element1.Validate();
                    }
                }
            }
        }
    }
}
