// <auto-generated>
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for
// license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.
// </auto-generated>

namespace Microsoft.Azure.CognitiveServices.Language.LUIS.Runtime.Models
{
    using Microsoft.Rest;
    using Newtonsoft.Json;
    using System.Linq;

    /// <summary>
    /// Defines a user predicted entity that extends an already existing one.
    /// </summary>
    public partial class ExternalEntity
    {
        /// <summary>
        /// Initializes a new instance of the ExternalEntity class.
        /// </summary>
        public ExternalEntity()
        {
            CustomInit();
        }

        /// <summary>
        /// Initializes a new instance of the ExternalEntity class.
        /// </summary>
        /// <param name="entityName">The name of the entity to extend.</param>
        /// <param name="startIndex">The start character index of the predicted
        /// entity.</param>
        /// <param name="entityLength">The length of the predicted
        /// entity.</param>
        /// <param name="resolution">A user supplied custom resolution to
        /// return as the entity's prediction.</param>
        /// <param name="score">A user supplied score to return as the entity's
        /// prediction score.</param>
        public ExternalEntity(string entityName, int startIndex, int entityLength, object resolution = default(object), double? score = default(double?))
        {
            EntityName = entityName;
            StartIndex = startIndex;
            EntityLength = entityLength;
            Resolution = resolution;
            Score = score;
            CustomInit();
        }

        /// <summary>
        /// An initialization method that performs custom operations like setting defaults
        /// </summary>
        partial void CustomInit();

        /// <summary>
        /// Gets or sets the name of the entity to extend.
        /// </summary>
        [JsonProperty(PropertyName = "entityName")]
        public string EntityName { get; set; }

        /// <summary>
        /// Gets or sets the start character index of the predicted entity.
        /// </summary>
        [JsonProperty(PropertyName = "startIndex")]
        public int StartIndex { get; set; }

        /// <summary>
        /// Gets or sets the length of the predicted entity.
        /// </summary>
        [JsonProperty(PropertyName = "entityLength")]
        public int EntityLength { get; set; }

        /// <summary>
        /// Gets or sets a user supplied custom resolution to return as the
        /// entity's prediction.
        /// </summary>
        [JsonProperty(PropertyName = "resolution")]
        public object Resolution { get; set; }

        /// <summary>
        /// Gets or sets a user supplied score to return as the entity's
        /// prediction score.
        /// </summary>
        [JsonProperty(PropertyName = "score")]
        public double? Score { get; set; }

        /// <summary>
        /// Validate the object.
        /// </summary>
        /// <exception cref="ValidationException">
        /// Thrown if validation fails
        /// </exception>
        public virtual void Validate()
        {
            if (EntityName == null)
            {
                throw new ValidationException(ValidationRules.CannotBeNull, "EntityName");
            }
        }
    }
}
