// <auto-generated>
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for
// license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.
// </auto-generated>

namespace Microsoft.Azure.CognitiveServices.Language.LUIS.Authoring.Models
{
    using Newtonsoft.Json;
    using System.Collections;
    using System.Collections.Generic;
    using System.Linq;

    /// <summary>
    /// Exported Model - An exported LUIS Application.
    /// </summary>
    public partial class LuisApp
    {
        /// <summary>
        /// Initializes a new instance of the LuisApp class.
        /// </summary>
        public LuisApp()
        {
            CustomInit();
        }

        /// <summary>
        /// Initializes a new instance of the LuisApp class.
        /// </summary>
        /// <param name="additionalProperties">Unmatched properties from the
        /// message are deserialized this collection</param>
        /// <param name="name">The name of the application.</param>
        /// <param name="versionId">The version ID of the application that was
        /// exported.</param>
        /// <param name="desc">The description of the application.</param>
        /// <param name="culture">The culture of the application. E.g.:
        /// en-us.</param>
        /// <param name="intents">List of intents.</param>
        /// <param name="entities">List of entities.</param>
        /// <param name="closedLists">List of list entities.</param>
        /// <param name="composites">List of composite entities.</param>
        /// <param name="hierarchicals">List of hierarchical entities.</param>
        /// <param name="patternAnyEntities">List of Pattern.Any
        /// entities.</param>
        /// <param name="regexEntities">List of regular expression
        /// entities.</param>
        /// <param name="prebuiltEntities">List of prebuilt entities.</param>
        /// <param name="regexFeatures">List of pattern features.</param>
        /// <param name="phraselists">List of model features.</param>
        /// <param name="patterns">List of patterns.</param>
        /// <param name="utterances">List of example utterances.</param>
        public LuisApp(IDictionary<string, object> additionalProperties = default(IDictionary<string, object>), string name = default(string), string versionId = default(string), string desc = default(string), string culture = default(string), IList<HierarchicalModel> intents = default(IList<HierarchicalModel>), IList<HierarchicalModel> entities = default(IList<HierarchicalModel>), IList<ClosedList> closedLists = default(IList<ClosedList>), IList<HierarchicalModel> composites = default(IList<HierarchicalModel>), IList<HierarchicalModel> hierarchicals = default(IList<HierarchicalModel>), IList<PatternAny> patternAnyEntities = default(IList<PatternAny>), IList<RegexEntity> regexEntities = default(IList<RegexEntity>), IList<PrebuiltEntity> prebuiltEntities = default(IList<PrebuiltEntity>), IList<JSONRegexFeature> regexFeatures = default(IList<JSONRegexFeature>), IList<JSONModelFeature> phraselists = default(IList<JSONModelFeature>), IList<PatternRule> patterns = default(IList<PatternRule>), IList<JSONUtterance> utterances = default(IList<JSONUtterance>))
        {
            AdditionalProperties = additionalProperties;
            Name = name;
            VersionId = versionId;
            Desc = desc;
            Culture = culture;
            Intents = intents;
            Entities = entities;
            ClosedLists = closedLists;
            Composites = composites;
            Hierarchicals = hierarchicals;
            PatternAnyEntities = patternAnyEntities;
            RegexEntities = regexEntities;
            PrebuiltEntities = prebuiltEntities;
            RegexFeatures = regexFeatures;
            Phraselists = phraselists;
            Patterns = patterns;
            Utterances = utterances;
            CustomInit();
        }

        /// <summary>
        /// An initialization method that performs custom operations like setting defaults
        /// </summary>
        partial void CustomInit();

        /// <summary>
        /// Gets or sets unmatched properties from the message are deserialized
        /// this collection
        /// </summary>
        [JsonExtensionData]
        public IDictionary<string, object> AdditionalProperties { get; set; }

        /// <summary>
        /// Gets or sets the name of the application.
        /// </summary>
        [JsonProperty(PropertyName = "name")]
        public string Name { get; set; }

        /// <summary>
        /// Gets or sets the version ID of the application that was exported.
        /// </summary>
        [JsonProperty(PropertyName = "versionId")]
        public string VersionId { get; set; }

        /// <summary>
        /// Gets or sets the description of the application.
        /// </summary>
        [JsonProperty(PropertyName = "desc")]
        public string Desc { get; set; }

        /// <summary>
        /// Gets or sets the culture of the application. E.g.: en-us.
        /// </summary>
        [JsonProperty(PropertyName = "culture")]
        public string Culture { get; set; }

        /// <summary>
        /// Gets or sets list of intents.
        /// </summary>
        [JsonProperty(PropertyName = "intents")]
        public IList<HierarchicalModel> Intents { get; set; }

        /// <summary>
        /// Gets or sets list of entities.
        /// </summary>
        [JsonProperty(PropertyName = "entities")]
        public IList<HierarchicalModel> Entities { get; set; }

        /// <summary>
        /// Gets or sets list of list entities.
        /// </summary>
        [JsonProperty(PropertyName = "closedLists")]
        public IList<ClosedList> ClosedLists { get; set; }

        /// <summary>
        /// Gets or sets list of composite entities.
        /// </summary>
        [JsonProperty(PropertyName = "composites")]
        public IList<HierarchicalModel> Composites { get; set; }

        /// <summary>
        /// Gets or sets list of hierarchical entities.
        /// </summary>
        [JsonProperty(PropertyName = "hierarchicals")]
        public IList<HierarchicalModel> Hierarchicals { get; set; }

        /// <summary>
        /// Gets or sets list of Pattern.Any entities.
        /// </summary>
        [JsonProperty(PropertyName = "patternAnyEntities")]
        public IList<PatternAny> PatternAnyEntities { get; set; }

        /// <summary>
        /// Gets or sets list of regular expression entities.
        /// </summary>
        [JsonProperty(PropertyName = "regex_entities")]
        public IList<RegexEntity> RegexEntities { get; set; }

        /// <summary>
        /// Gets or sets list of prebuilt entities.
        /// </summary>
        [JsonProperty(PropertyName = "prebuiltEntities")]
        public IList<PrebuiltEntity> PrebuiltEntities { get; set; }

        /// <summary>
        /// Gets or sets list of pattern features.
        /// </summary>
        [JsonProperty(PropertyName = "regex_features")]
        public IList<JSONRegexFeature> RegexFeatures { get; set; }

        /// <summary>
        /// Gets or sets list of model features.
        /// </summary>
        [JsonProperty(PropertyName = "phraselists")]
        public IList<JSONModelFeature> Phraselists { get; set; }

        /// <summary>
        /// Gets or sets list of patterns.
        /// </summary>
        [JsonProperty(PropertyName = "patterns")]
        public IList<PatternRule> Patterns { get; set; }

        /// <summary>
        /// Gets or sets list of example utterances.
        /// </summary>
        [JsonProperty(PropertyName = "utterances")]
        public IList<JSONUtterance> Utterances { get; set; }

    }
}
