// <auto-generated>
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for
// license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.
// </auto-generated>

namespace Microsoft.Azure.CognitiveServices.Language.LUIS.Authoring.Models
{
    using Microsoft.Rest;
    using Newtonsoft.Json;
    using System.Collections;
    using System.Collections.Generic;
    using System.Linq;

    /// <summary>
    /// A suggested entity.
    /// </summary>
    public partial class EntityPrediction
    {
        /// <summary>
        /// Initializes a new instance of the EntityPrediction class.
        /// </summary>
        public EntityPrediction()
        {
            CustomInit();
        }

        /// <summary>
        /// Initializes a new instance of the EntityPrediction class.
        /// </summary>
        /// <param name="entityName">The entity's name</param>
        /// <param name="startTokenIndex">The index within the utterance where
        /// the extracted entity starts.</param>
        /// <param name="endTokenIndex">The index within the utterance where
        /// the extracted entity ends.</param>
        /// <param name="phrase">The actual token(s) that comprise the
        /// entity.</param>
        public EntityPrediction(string entityName, int startTokenIndex, int endTokenIndex, string phrase, IList<EntityPrediction> children = default(IList<EntityPrediction>))
        {
            EntityName = entityName;
            StartTokenIndex = startTokenIndex;
            EndTokenIndex = endTokenIndex;
            Phrase = phrase;
            Children = children;
            CustomInit();
        }

        /// <summary>
        /// An initialization method that performs custom operations like setting defaults
        /// </summary>
        partial void CustomInit();

        /// <summary>
        /// Gets or sets the entity's name
        /// </summary>
        [JsonProperty(PropertyName = "entityName")]
        public string EntityName { get; set; }

        /// <summary>
        /// Gets or sets the index within the utterance where the extracted
        /// entity starts.
        /// </summary>
        [JsonProperty(PropertyName = "startTokenIndex")]
        public int StartTokenIndex { get; set; }

        /// <summary>
        /// Gets or sets the index within the utterance where the extracted
        /// entity ends.
        /// </summary>
        [JsonProperty(PropertyName = "endTokenIndex")]
        public int EndTokenIndex { get; set; }

        /// <summary>
        /// Gets or sets the actual token(s) that comprise the entity.
        /// </summary>
        [JsonProperty(PropertyName = "phrase")]
        public string Phrase { get; set; }

        /// <summary>
        /// </summary>
        [JsonProperty(PropertyName = "children")]
        public IList<EntityPrediction> Children { get; set; }

        /// <summary>
        /// Validate the object.
        /// </summary>
        /// <exception cref="ValidationException">
        /// Thrown if validation fails
        /// </exception>
        public virtual void Validate()
        {
            if (EntityName == null)
            {
                throw new ValidationException(ValidationRules.CannotBeNull, "EntityName");
            }
            if (Phrase == null)
            {
                throw new ValidationException(ValidationRules.CannotBeNull, "Phrase");
            }
            if (Children != null)
            {
                foreach (var element in Children)
                {
                    if (element != null)
                    {
                        element.Validate();
                    }
                }
            }
        }
    }
}
