// <auto-generated>
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for
// license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.
// </auto-generated>

namespace Microsoft.Azure.CognitiveServices.Language.LUIS.Authoring.Models
{
    using Microsoft.Rest;
    using Newtonsoft.Json;
    using System.Collections;
    using System.Collections.Generic;
    using System.Linq;

    /// <summary>
    /// Defines the entity type and position of the extracted entity within the
    /// example.
    /// </summary>
    public partial class EntityLabelObject
    {
        /// <summary>
        /// Initializes a new instance of the EntityLabelObject class.
        /// </summary>
        public EntityLabelObject()
        {
            CustomInit();
        }

        /// <summary>
        /// Initializes a new instance of the EntityLabelObject class.
        /// </summary>
        /// <param name="entityName">The entity type.</param>
        /// <param name="startCharIndex">The index within the utterance where
        /// the extracted entity starts.</param>
        /// <param name="endCharIndex">The index within the utterance where the
        /// extracted entity ends.</param>
        /// <param name="role">The role the entity plays in the
        /// utterance.</param>
        /// <param name="children">The identified entities within the example
        /// utterance.</param>
        public EntityLabelObject(string entityName, int startCharIndex, int endCharIndex, string role = default(string), IList<EntityLabelObject> children = default(IList<EntityLabelObject>))
        {
            EntityName = entityName;
            StartCharIndex = startCharIndex;
            EndCharIndex = endCharIndex;
            Role = role;
            Children = children;
            CustomInit();
        }

        /// <summary>
        /// An initialization method that performs custom operations like setting defaults
        /// </summary>
        partial void CustomInit();

        /// <summary>
        /// Gets or sets the entity type.
        /// </summary>
        [JsonProperty(PropertyName = "entityName")]
        public string EntityName { get; set; }

        /// <summary>
        /// Gets or sets the index within the utterance where the extracted
        /// entity starts.
        /// </summary>
        [JsonProperty(PropertyName = "startCharIndex")]
        public int StartCharIndex { get; set; }

        /// <summary>
        /// Gets or sets the index within the utterance where the extracted
        /// entity ends.
        /// </summary>
        [JsonProperty(PropertyName = "endCharIndex")]
        public int EndCharIndex { get; set; }

        /// <summary>
        /// Gets or sets the role the entity plays in the utterance.
        /// </summary>
        [JsonProperty(PropertyName = "role")]
        public string Role { get; set; }

        /// <summary>
        /// Gets or sets the identified entities within the example utterance.
        /// </summary>
        [JsonProperty(PropertyName = "children")]
        public IList<EntityLabelObject> Children { get; set; }

        /// <summary>
        /// Validate the object.
        /// </summary>
        /// <exception cref="ValidationException">
        /// Thrown if validation fails
        /// </exception>
        public virtual void Validate()
        {
            if (EntityName == null)
            {
                throw new ValidationException(ValidationRules.CannotBeNull, "EntityName");
            }
            if (Children != null)
            {
                foreach (var element in Children)
                {
                    if (element != null)
                    {
                        element.Validate();
                    }
                }
            }
        }
    }
}
