// <auto-generated>
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for
// license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.
// </auto-generated>

namespace Microsoft.Azure.CognitiveServices.Language.LUIS.Authoring.Models
{
    using Microsoft.Rest;
    using Newtonsoft.Json;
    using System.Collections;
    using System.Collections.Generic;
    using System.Linq;

    /// <summary>
    /// Defines the entity type and position of the extracted entity within the
    /// example.
    /// </summary>
    public partial class EntityLabel
    {
        /// <summary>
        /// Initializes a new instance of the EntityLabel class.
        /// </summary>
        public EntityLabel()
        {
            CustomInit();
        }

        /// <summary>
        /// Initializes a new instance of the EntityLabel class.
        /// </summary>
        /// <param name="entityName">The entity type.</param>
        /// <param name="startTokenIndex">The index within the utterance where
        /// the extracted entity starts.</param>
        /// <param name="endTokenIndex">The index within the utterance where
        /// the extracted entity ends.</param>
        /// <param name="role">The role of the predicted entity.</param>
        /// <param name="roleId">The role id for the predicted entity.</param>
        public EntityLabel(string entityName, int startTokenIndex, int endTokenIndex, string role = default(string), System.Guid? roleId = default(System.Guid?), IList<EntityLabel> children = default(IList<EntityLabel>))
        {
            EntityName = entityName;
            StartTokenIndex = startTokenIndex;
            EndTokenIndex = endTokenIndex;
            Role = role;
            RoleId = roleId;
            Children = children;
            CustomInit();
        }

        /// <summary>
        /// An initialization method that performs custom operations like setting defaults
        /// </summary>
        partial void CustomInit();

        /// <summary>
        /// Gets or sets the entity type.
        /// </summary>
        [JsonProperty(PropertyName = "entityName")]
        public string EntityName { get; set; }

        /// <summary>
        /// Gets or sets the index within the utterance where the extracted
        /// entity starts.
        /// </summary>
        [JsonProperty(PropertyName = "startTokenIndex")]
        public int StartTokenIndex { get; set; }

        /// <summary>
        /// Gets or sets the index within the utterance where the extracted
        /// entity ends.
        /// </summary>
        [JsonProperty(PropertyName = "endTokenIndex")]
        public int EndTokenIndex { get; set; }

        /// <summary>
        /// Gets or sets the role of the predicted entity.
        /// </summary>
        [JsonProperty(PropertyName = "role")]
        public string Role { get; set; }

        /// <summary>
        /// Gets or sets the role id for the predicted entity.
        /// </summary>
        [JsonProperty(PropertyName = "roleId")]
        public System.Guid? RoleId { get; set; }

        /// <summary>
        /// </summary>
        [JsonProperty(PropertyName = "children")]
        public IList<EntityLabel> Children { get; set; }

        /// <summary>
        /// Validate the object.
        /// </summary>
        /// <exception cref="ValidationException">
        /// Thrown if validation fails
        /// </exception>
        public virtual void Validate()
        {
            if (EntityName == null)
            {
                throw new ValidationException(ValidationRules.CannotBeNull, "EntityName");
            }
            if (Children != null)
            {
                foreach (var element in Children)
                {
                    if (element != null)
                    {
                        element.Validate();
                    }
                }
            }
        }
    }
}
