// <auto-generated>
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for
// license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.
// </auto-generated>

namespace Microsoft.Azure.CognitiveServices.Language.LUIS.Authoring
{
    using Models;
    using System.Collections;
    using System.Collections.Generic;
    using System.Threading;
    using System.Threading.Tasks;

    /// <summary>
    /// Extension methods for Model.
    /// </summary>
    public static partial class ModelExtensions
    {
            /// <summary>
            /// Adds an intent to a version of the application.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='appId'>
            /// The application ID.
            /// </param>
            /// <param name='versionId'>
            /// The version ID.
            /// </param>
            /// <param name='intentCreateObject'>
            /// A model object containing the name of the new intent.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<System.Guid> AddIntentAsync(this IModel operations, System.Guid appId, string versionId, ModelCreateObject intentCreateObject, CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.AddIntentWithHttpMessagesAsync(appId, versionId, intentCreateObject, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Gets information about the intent models in a version of the application.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='appId'>
            /// The application ID.
            /// </param>
            /// <param name='versionId'>
            /// The version ID.
            /// </param>
            /// <param name='skip'>
            /// The number of entries to skip. Default value is 0.
            /// </param>
            /// <param name='take'>
            /// The number of entries to return. Maximum page size is 500. Default is 100.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<IList<IntentClassifier>> ListIntentsAsync(this IModel operations, System.Guid appId, string versionId, int? skip = 0, int? take = 100, CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.ListIntentsWithHttpMessagesAsync(appId, versionId, skip, take, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Adds an entity extractor to a version of the application.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='appId'>
            /// The application ID.
            /// </param>
            /// <param name='versionId'>
            /// The version ID.
            /// </param>
            /// <param name='entityModelCreateObject'>
            /// A model object containing the name of the new entity extractor and its
            /// children.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<System.Guid> AddEntityAsync(this IModel operations, System.Guid appId, string versionId, EntityModelCreateObject entityModelCreateObject, CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.AddEntityWithHttpMessagesAsync(appId, versionId, entityModelCreateObject, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Gets information about all the simple entity models in a version of the
            /// application.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='appId'>
            /// The application ID.
            /// </param>
            /// <param name='versionId'>
            /// The version ID.
            /// </param>
            /// <param name='skip'>
            /// The number of entries to skip. Default value is 0.
            /// </param>
            /// <param name='take'>
            /// The number of entries to return. Maximum page size is 500. Default is 100.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<IList<NDepthEntityExtractor>> ListEntitiesAsync(this IModel operations, System.Guid appId, string versionId, int? skip = 0, int? take = 100, CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.ListEntitiesWithHttpMessagesAsync(appId, versionId, skip, take, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Gets information about all the hierarchical entity models in a version of
            /// the application.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='appId'>
            /// The application ID.
            /// </param>
            /// <param name='versionId'>
            /// The version ID.
            /// </param>
            /// <param name='skip'>
            /// The number of entries to skip. Default value is 0.
            /// </param>
            /// <param name='take'>
            /// The number of entries to return. Maximum page size is 500. Default is 100.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<IList<HierarchicalEntityExtractor>> ListHierarchicalEntitiesAsync(this IModel operations, System.Guid appId, string versionId, int? skip = 0, int? take = 100, CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.ListHierarchicalEntitiesWithHttpMessagesAsync(appId, versionId, skip, take, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Gets information about all the composite entity models in a version of the
            /// application.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='appId'>
            /// The application ID.
            /// </param>
            /// <param name='versionId'>
            /// The version ID.
            /// </param>
            /// <param name='skip'>
            /// The number of entries to skip. Default value is 0.
            /// </param>
            /// <param name='take'>
            /// The number of entries to return. Maximum page size is 500. Default is 100.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<IList<CompositeEntityExtractor>> ListCompositeEntitiesAsync(this IModel operations, System.Guid appId, string versionId, int? skip = 0, int? take = 100, CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.ListCompositeEntitiesWithHttpMessagesAsync(appId, versionId, skip, take, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Gets information about all the list entity models in a version of the
            /// application.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='appId'>
            /// The application ID.
            /// </param>
            /// <param name='versionId'>
            /// The version ID.
            /// </param>
            /// <param name='skip'>
            /// The number of entries to skip. Default value is 0.
            /// </param>
            /// <param name='take'>
            /// The number of entries to return. Maximum page size is 500. Default is 100.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<IList<ClosedListEntityExtractor>> ListClosedListsAsync(this IModel operations, System.Guid appId, string versionId, int? skip = 0, int? take = 100, CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.ListClosedListsWithHttpMessagesAsync(appId, versionId, skip, take, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Adds a list entity model to a version of the application.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='appId'>
            /// The application ID.
            /// </param>
            /// <param name='versionId'>
            /// The version ID.
            /// </param>
            /// <param name='closedListModelCreateObject'>
            /// A model containing the name and words for the new list entity extractor.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<System.Guid> AddClosedListAsync(this IModel operations, System.Guid appId, string versionId, ClosedListModelCreateObject closedListModelCreateObject, CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.AddClosedListWithHttpMessagesAsync(appId, versionId, closedListModelCreateObject, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Adds a list of prebuilt entities to a version of the application.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='appId'>
            /// The application ID.
            /// </param>
            /// <param name='versionId'>
            /// The version ID.
            /// </param>
            /// <param name='prebuiltExtractorNames'>
            /// An array of prebuilt entity extractor names.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<IList<PrebuiltEntityExtractor>> AddPrebuiltAsync(this IModel operations, System.Guid appId, string versionId, IList<string> prebuiltExtractorNames, CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.AddPrebuiltWithHttpMessagesAsync(appId, versionId, prebuiltExtractorNames, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Gets information about all the prebuilt entities in a version of the
            /// application.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='appId'>
            /// The application ID.
            /// </param>
            /// <param name='versionId'>
            /// The version ID.
            /// </param>
            /// <param name='skip'>
            /// The number of entries to skip. Default value is 0.
            /// </param>
            /// <param name='take'>
            /// The number of entries to return. Maximum page size is 500. Default is 100.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<IList<PrebuiltEntityExtractor>> ListPrebuiltsAsync(this IModel operations, System.Guid appId, string versionId, int? skip = 0, int? take = 100, CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.ListPrebuiltsWithHttpMessagesAsync(appId, versionId, skip, take, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Gets all the available prebuilt entities in a version of the application.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='appId'>
            /// The application ID.
            /// </param>
            /// <param name='versionId'>
            /// The version ID.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<IList<AvailablePrebuiltEntityModel>> ListPrebuiltEntitiesAsync(this IModel operations, System.Guid appId, string versionId, CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.ListPrebuiltEntitiesWithHttpMessagesAsync(appId, versionId, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Gets information about all the intent and entity models in a version of the
            /// application.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='appId'>
            /// The application ID.
            /// </param>
            /// <param name='versionId'>
            /// The version ID.
            /// </param>
            /// <param name='skip'>
            /// The number of entries to skip. Default value is 0.
            /// </param>
            /// <param name='take'>
            /// The number of entries to return. Maximum page size is 500. Default is 100.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<IList<ModelInfoResponse>> ListModelsAsync(this IModel operations, System.Guid appId, string versionId, int? skip = 0, int? take = 100, CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.ListModelsWithHttpMessagesAsync(appId, versionId, skip, take, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Gets the example utterances for the given intent or entity model in a
            /// version of the application.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='appId'>
            /// The application ID.
            /// </param>
            /// <param name='versionId'>
            /// The version ID.
            /// </param>
            /// <param name='modelId'>
            /// The ID (GUID) of the model.
            /// </param>
            /// <param name='skip'>
            /// The number of entries to skip. Default value is 0.
            /// </param>
            /// <param name='take'>
            /// The number of entries to return. Maximum page size is 500. Default is 100.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<IList<LabelTextObject>> ExamplesMethodAsync(this IModel operations, System.Guid appId, string versionId, string modelId, int? skip = 0, int? take = 100, CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.ExamplesMethodWithHttpMessagesAsync(appId, versionId, modelId, skip, take, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Gets information about the intent model in a version of the application.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='appId'>
            /// The application ID.
            /// </param>
            /// <param name='versionId'>
            /// The version ID.
            /// </param>
            /// <param name='intentId'>
            /// The intent classifier ID.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<IntentClassifier> GetIntentAsync(this IModel operations, System.Guid appId, string versionId, System.Guid intentId, CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.GetIntentWithHttpMessagesAsync(appId, versionId, intentId, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Updates the name of an intent in a version of the application.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='appId'>
            /// The application ID.
            /// </param>
            /// <param name='versionId'>
            /// The version ID.
            /// </param>
            /// <param name='intentId'>
            /// The intent classifier ID.
            /// </param>
            /// <param name='modelUpdateObject'>
            /// A model object containing the new intent name.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<OperationStatus> UpdateIntentAsync(this IModel operations, System.Guid appId, string versionId, System.Guid intentId, ModelUpdateObject modelUpdateObject, CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.UpdateIntentWithHttpMessagesAsync(appId, versionId, intentId, modelUpdateObject, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Deletes an intent from a version of the application.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='appId'>
            /// The application ID.
            /// </param>
            /// <param name='versionId'>
            /// The version ID.
            /// </param>
            /// <param name='intentId'>
            /// The intent classifier ID.
            /// </param>
            /// <param name='deleteUtterances'>
            /// If true, deletes the intent's example utterances. If false, moves the
            /// example utterances to the None intent. The default value is false.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<OperationStatus> DeleteIntentAsync(this IModel operations, System.Guid appId, string versionId, System.Guid intentId, bool? deleteUtterances = false, CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.DeleteIntentWithHttpMessagesAsync(appId, versionId, intentId, deleteUtterances, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Gets information about an entity model in a version of the application.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='appId'>
            /// The application ID.
            /// </param>
            /// <param name='versionId'>
            /// The version ID.
            /// </param>
            /// <param name='entityId'>
            /// The entity extractor ID.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<NDepthEntityExtractor> GetEntityAsync(this IModel operations, System.Guid appId, string versionId, System.Guid entityId, CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.GetEntityWithHttpMessagesAsync(appId, versionId, entityId, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Deletes an entity or a child from a version of the application.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='appId'>
            /// The application ID.
            /// </param>
            /// <param name='versionId'>
            /// The version ID.
            /// </param>
            /// <param name='entityId'>
            /// The entity extractor or the child entity extractor ID.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<OperationStatus> DeleteEntityAsync(this IModel operations, System.Guid appId, string versionId, System.Guid entityId, CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.DeleteEntityWithHttpMessagesAsync(appId, versionId, entityId, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Updates the name of an entity extractor or the name and instanceOf model of
            /// a child entity extractor.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='appId'>
            /// The application ID.
            /// </param>
            /// <param name='versionId'>
            /// The version ID.
            /// </param>
            /// <param name='entityId'>
            /// The entity extractor or the child entity extractor ID.
            /// </param>
            /// <param name='entityModelUpdateObject'>
            /// A model object containing the name new entity extractor or the name and
            /// instance of model of a child entity extractor
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<OperationStatus> UpdateEntityChildAsync(this IModel operations, System.Guid appId, string versionId, System.Guid entityId, EntityModelUpdateObject entityModelUpdateObject, CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.UpdateEntityChildWithHttpMessagesAsync(appId, versionId, entityId, entityModelUpdateObject, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Gets the information of the features used by the intent in a version of the
            /// application.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='appId'>
            /// The application ID.
            /// </param>
            /// <param name='versionId'>
            /// The version ID.
            /// </param>
            /// <param name='intentId'>
            /// The intent classifier ID.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<IList<ModelFeatureInformation>> GetIntentFeaturesAsync(this IModel operations, System.Guid appId, string versionId, System.Guid intentId, CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.GetIntentFeaturesWithHttpMessagesAsync(appId, versionId, intentId, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Updates the information of the features used by the intent in a version of
            /// the application.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='appId'>
            /// The application ID.
            /// </param>
            /// <param name='versionId'>
            /// The version ID.
            /// </param>
            /// <param name='intentId'>
            /// The intent classifier ID.
            /// </param>
            /// <param name='featureRelationsUpdateObject'>
            /// A list of feature information objects containing the new feature relations.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<OperationStatus> ReplaceIntentFeaturesAsync(this IModel operations, System.Guid appId, string versionId, System.Guid intentId, IList<ModelFeatureInformation> featureRelationsUpdateObject, CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.ReplaceIntentFeaturesWithHttpMessagesAsync(appId, versionId, intentId, featureRelationsUpdateObject, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Deletes a relation from the feature relations used by the intent in a
            /// version of the application.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='appId'>
            /// The application ID.
            /// </param>
            /// <param name='versionId'>
            /// The version ID.
            /// </param>
            /// <param name='intentId'>
            /// The intent classifier ID.
            /// </param>
            /// <param name='featureRelationDeleteObject'>
            /// A feature information object containing the feature relation to delete.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<OperationStatus> DeleteIntentFeatureAsync(this IModel operations, System.Guid appId, string versionId, System.Guid intentId, ModelFeatureInformation featureRelationDeleteObject, CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.DeleteIntentFeatureWithHttpMessagesAsync(appId, versionId, intentId, featureRelationDeleteObject, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Gets the information of the features used by the entity in a version of the
            /// application.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='appId'>
            /// The application ID.
            /// </param>
            /// <param name='versionId'>
            /// The version ID.
            /// </param>
            /// <param name='entityId'>
            /// The entity extractor ID.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<IList<ModelFeatureInformation>> GetEntityFeaturesAsync(this IModel operations, System.Guid appId, string versionId, System.Guid entityId, CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.GetEntityFeaturesWithHttpMessagesAsync(appId, versionId, entityId, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Updates the information of the features used by the entity in a version of
            /// the application.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='appId'>
            /// The application ID.
            /// </param>
            /// <param name='versionId'>
            /// The version ID.
            /// </param>
            /// <param name='entityId'>
            /// The entity extractor ID.
            /// </param>
            /// <param name='featureRelationsUpdateObject'>
            /// A list of feature information objects containing the new feature relations.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<OperationStatus> ReplaceEntityFeaturesAsync(this IModel operations, System.Guid appId, string versionId, System.Guid entityId, IList<ModelFeatureInformation> featureRelationsUpdateObject, CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.ReplaceEntityFeaturesWithHttpMessagesAsync(appId, versionId, entityId, featureRelationsUpdateObject, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Deletes a relation from the feature relations used by the entity in a
            /// version of the application.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='appId'>
            /// The application ID.
            /// </param>
            /// <param name='versionId'>
            /// The version ID.
            /// </param>
            /// <param name='entityId'>
            /// The entity extractor ID.
            /// </param>
            /// <param name='featureRelationDeleteObject'>
            /// A feature information object containing the feature relation to delete.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<OperationStatus> DeleteEntityFeatureAsync(this IModel operations, System.Guid appId, string versionId, System.Guid entityId, ModelFeatureInformation featureRelationDeleteObject, CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.DeleteEntityFeatureWithHttpMessagesAsync(appId, versionId, entityId, featureRelationDeleteObject, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Gets information about a hierarchical entity in a version of the
            /// application.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='appId'>
            /// The application ID.
            /// </param>
            /// <param name='versionId'>
            /// The version ID.
            /// </param>
            /// <param name='hEntityId'>
            /// The hierarchical entity extractor ID.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<HierarchicalEntityExtractor> GetHierarchicalEntityAsync(this IModel operations, System.Guid appId, string versionId, System.Guid hEntityId, CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.GetHierarchicalEntityWithHttpMessagesAsync(appId, versionId, hEntityId, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Updates the name of a hierarchical entity model in a version of the
            /// application.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='appId'>
            /// The application ID.
            /// </param>
            /// <param name='versionId'>
            /// The version ID.
            /// </param>
            /// <param name='hEntityId'>
            /// The hierarchical entity extractor ID.
            /// </param>
            /// <param name='modelUpdateObject'>
            /// Model containing names of the hierarchical entity.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<OperationStatus> UpdateHierarchicalEntityAsync(this IModel operations, System.Guid appId, string versionId, System.Guid hEntityId, ModelUpdateObject modelUpdateObject, CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.UpdateHierarchicalEntityWithHttpMessagesAsync(appId, versionId, hEntityId, modelUpdateObject, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Deletes a hierarchical entity from a version of the application.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='appId'>
            /// The application ID.
            /// </param>
            /// <param name='versionId'>
            /// The version ID.
            /// </param>
            /// <param name='hEntityId'>
            /// The hierarchical entity extractor ID.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<OperationStatus> DeleteHierarchicalEntityAsync(this IModel operations, System.Guid appId, string versionId, System.Guid hEntityId, CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.DeleteHierarchicalEntityWithHttpMessagesAsync(appId, versionId, hEntityId, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Gets information about a composite entity in a version of the application.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='appId'>
            /// The application ID.
            /// </param>
            /// <param name='versionId'>
            /// The version ID.
            /// </param>
            /// <param name='cEntityId'>
            /// The composite entity extractor ID.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<CompositeEntityExtractor> GetCompositeEntityAsync(this IModel operations, System.Guid appId, string versionId, System.Guid cEntityId, CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.GetCompositeEntityWithHttpMessagesAsync(appId, versionId, cEntityId, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Updates a composite entity in a version of the application.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='appId'>
            /// The application ID.
            /// </param>
            /// <param name='versionId'>
            /// The version ID.
            /// </param>
            /// <param name='cEntityId'>
            /// The composite entity extractor ID.
            /// </param>
            /// <param name='compositeModelUpdateObject'>
            /// A model object containing the new entity extractor name and children.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<OperationStatus> UpdateCompositeEntityAsync(this IModel operations, System.Guid appId, string versionId, System.Guid cEntityId, CompositeEntityModel compositeModelUpdateObject, CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.UpdateCompositeEntityWithHttpMessagesAsync(appId, versionId, cEntityId, compositeModelUpdateObject, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Deletes a composite entity from a version of the application.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='appId'>
            /// The application ID.
            /// </param>
            /// <param name='versionId'>
            /// The version ID.
            /// </param>
            /// <param name='cEntityId'>
            /// The composite entity extractor ID.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<OperationStatus> DeleteCompositeEntityAsync(this IModel operations, System.Guid appId, string versionId, System.Guid cEntityId, CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.DeleteCompositeEntityWithHttpMessagesAsync(appId, versionId, cEntityId, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Gets information about a list entity in a version of the application.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='appId'>
            /// The application ID.
            /// </param>
            /// <param name='versionId'>
            /// The version ID.
            /// </param>
            /// <param name='clEntityId'>
            /// The list model ID.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<ClosedListEntityExtractor> GetClosedListAsync(this IModel operations, System.Guid appId, string versionId, System.Guid clEntityId, CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.GetClosedListWithHttpMessagesAsync(appId, versionId, clEntityId, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Updates the list entity in a version of the application.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='appId'>
            /// The application ID.
            /// </param>
            /// <param name='versionId'>
            /// The version ID.
            /// </param>
            /// <param name='clEntityId'>
            /// The list model ID.
            /// </param>
            /// <param name='closedListModelUpdateObject'>
            /// The new list entity name and words list.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<OperationStatus> UpdateClosedListAsync(this IModel operations, System.Guid appId, string versionId, System.Guid clEntityId, ClosedListModelUpdateObject closedListModelUpdateObject, CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.UpdateClosedListWithHttpMessagesAsync(appId, versionId, clEntityId, closedListModelUpdateObject, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Adds a batch of sublists to an existing list entity in a version of the
            /// application.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='appId'>
            /// The application ID.
            /// </param>
            /// <param name='versionId'>
            /// The version ID.
            /// </param>
            /// <param name='clEntityId'>
            /// The list entity model ID.
            /// </param>
            /// <param name='closedListModelPatchObject'>
            /// A words list batch.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<OperationStatus> PatchClosedListAsync(this IModel operations, System.Guid appId, string versionId, System.Guid clEntityId, ClosedListModelPatchObject closedListModelPatchObject, CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.PatchClosedListWithHttpMessagesAsync(appId, versionId, clEntityId, closedListModelPatchObject, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Deletes a list entity model from a version of the application.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='appId'>
            /// The application ID.
            /// </param>
            /// <param name='versionId'>
            /// The version ID.
            /// </param>
            /// <param name='clEntityId'>
            /// The list entity model ID.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<OperationStatus> DeleteClosedListAsync(this IModel operations, System.Guid appId, string versionId, System.Guid clEntityId, CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.DeleteClosedListWithHttpMessagesAsync(appId, versionId, clEntityId, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Gets information about a prebuilt entity model in a version of the
            /// application.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='appId'>
            /// The application ID.
            /// </param>
            /// <param name='versionId'>
            /// The version ID.
            /// </param>
            /// <param name='prebuiltId'>
            /// The prebuilt entity extractor ID.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<PrebuiltEntityExtractor> GetPrebuiltAsync(this IModel operations, System.Guid appId, string versionId, System.Guid prebuiltId, CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.GetPrebuiltWithHttpMessagesAsync(appId, versionId, prebuiltId, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Deletes a prebuilt entity extractor from a version of the application.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='appId'>
            /// The application ID.
            /// </param>
            /// <param name='versionId'>
            /// The version ID.
            /// </param>
            /// <param name='prebuiltId'>
            /// The prebuilt entity extractor ID.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<OperationStatus> DeletePrebuiltAsync(this IModel operations, System.Guid appId, string versionId, System.Guid prebuiltId, CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.DeletePrebuiltWithHttpMessagesAsync(appId, versionId, prebuiltId, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Deletes a sublist of a specific list entity model from a version of the
            /// application.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='appId'>
            /// The application ID.
            /// </param>
            /// <param name='versionId'>
            /// The version ID.
            /// </param>
            /// <param name='clEntityId'>
            /// The list entity extractor ID.
            /// </param>
            /// <param name='subListId'>
            /// The sublist ID.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<OperationStatus> DeleteSubListAsync(this IModel operations, System.Guid appId, string versionId, System.Guid clEntityId, long subListId, CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.DeleteSubListWithHttpMessagesAsync(appId, versionId, clEntityId, subListId, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Updates one of the list entity's sublists in a version of the application.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='appId'>
            /// The application ID.
            /// </param>
            /// <param name='versionId'>
            /// The version ID.
            /// </param>
            /// <param name='clEntityId'>
            /// The list entity extractor ID.
            /// </param>
            /// <param name='subListId'>
            /// The sublist ID.
            /// </param>
            /// <param name='wordListBaseUpdateObject'>
            /// A sublist update object containing the new canonical form and the list of
            /// words.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<OperationStatus> UpdateSubListAsync(this IModel operations, System.Guid appId, string versionId, System.Guid clEntityId, long subListId, WordListBaseUpdateObject wordListBaseUpdateObject, CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.UpdateSubListWithHttpMessagesAsync(appId, versionId, clEntityId, subListId, wordListBaseUpdateObject, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Suggests example utterances that would improve the accuracy of the intent
            /// model in a version of the application.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='appId'>
            /// The application ID.
            /// </param>
            /// <param name='versionId'>
            /// The version ID.
            /// </param>
            /// <param name='intentId'>
            /// The intent classifier ID.
            /// </param>
            /// <param name='take'>
            /// The number of entries to return. Maximum page size is 500. Default is 100.
            /// </param>
            /// <param name='enableNestedChildren'>
            /// Toggles nested/flat format
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<IList<IntentsSuggestionExample>> ListIntentSuggestionsAsync(this IModel operations, System.Guid appId, string versionId, System.Guid intentId, int? take = 100, bool? enableNestedChildren = false, CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.ListIntentSuggestionsWithHttpMessagesAsync(appId, versionId, intentId, take, enableNestedChildren, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Get suggested example utterances that would improve the accuracy of the
            /// entity model in a version of the application.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='appId'>
            /// The application ID.
            /// </param>
            /// <param name='versionId'>
            /// The version ID.
            /// </param>
            /// <param name='entityId'>
            /// The target entity extractor model to enhance.
            /// </param>
            /// <param name='take'>
            /// The number of entries to return. Maximum page size is 500. Default is 100.
            /// </param>
            /// <param name='enableNestedChildren'>
            /// Toggles nested/flat format
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<IList<EntitiesSuggestionExample>> ListEntitySuggestionsAsync(this IModel operations, System.Guid appId, string versionId, System.Guid entityId, int? take = 100, bool? enableNestedChildren = false, CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.ListEntitySuggestionsWithHttpMessagesAsync(appId, versionId, entityId, take, enableNestedChildren, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Adds a sublist to an existing list entity in a version of the application.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='appId'>
            /// The application ID.
            /// </param>
            /// <param name='versionId'>
            /// The version ID.
            /// </param>
            /// <param name='clEntityId'>
            /// The list entity extractor ID.
            /// </param>
            /// <param name='wordListCreateObject'>
            /// Words list.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<long?> AddSubListAsync(this IModel operations, System.Guid appId, string versionId, System.Guid clEntityId, WordListObject wordListCreateObject, CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.AddSubListWithHttpMessagesAsync(appId, versionId, clEntityId, wordListCreateObject, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Adds a customizable prebuilt domain along with all of its intent and entity
            /// models in a version of the application.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='appId'>
            /// The application ID.
            /// </param>
            /// <param name='versionId'>
            /// The version ID.
            /// </param>
            /// <param name='prebuiltDomainObject'>
            /// A prebuilt domain create object containing the name of the domain.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<IList<System.Guid?>> AddCustomPrebuiltDomainAsync(this IModel operations, System.Guid appId, string versionId, PrebuiltDomainCreateBaseObject prebuiltDomainObject, CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.AddCustomPrebuiltDomainWithHttpMessagesAsync(appId, versionId, prebuiltDomainObject, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Adds a customizable prebuilt intent model to a version of the application.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='appId'>
            /// The application ID.
            /// </param>
            /// <param name='versionId'>
            /// The version ID.
            /// </param>
            /// <param name='prebuiltDomainModelCreateObject'>
            /// A model object containing the name of the customizable prebuilt intent and
            /// the name of the domain to which this model belongs.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<System.Guid> AddCustomPrebuiltIntentAsync(this IModel operations, System.Guid appId, string versionId, PrebuiltDomainModelCreateObject prebuiltDomainModelCreateObject, CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.AddCustomPrebuiltIntentWithHttpMessagesAsync(appId, versionId, prebuiltDomainModelCreateObject, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Gets information about customizable prebuilt intents added to a version of
            /// the application.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='appId'>
            /// The application ID.
            /// </param>
            /// <param name='versionId'>
            /// The version ID.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<IList<IntentClassifier>> ListCustomPrebuiltIntentsAsync(this IModel operations, System.Guid appId, string versionId, CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.ListCustomPrebuiltIntentsWithHttpMessagesAsync(appId, versionId, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Adds a prebuilt entity model to a version of the application.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='appId'>
            /// The application ID.
            /// </param>
            /// <param name='versionId'>
            /// The version ID.
            /// </param>
            /// <param name='prebuiltDomainModelCreateObject'>
            /// A model object containing the name of the prebuilt entity and the name of
            /// the domain to which this model belongs.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<System.Guid> AddCustomPrebuiltEntityAsync(this IModel operations, System.Guid appId, string versionId, PrebuiltDomainModelCreateObject prebuiltDomainModelCreateObject, CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.AddCustomPrebuiltEntityWithHttpMessagesAsync(appId, versionId, prebuiltDomainModelCreateObject, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Gets all prebuilt entities used in a version of the application.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='appId'>
            /// The application ID.
            /// </param>
            /// <param name='versionId'>
            /// The version ID.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<IList<EntityExtractor>> ListCustomPrebuiltEntitiesAsync(this IModel operations, System.Guid appId, string versionId, CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.ListCustomPrebuiltEntitiesWithHttpMessagesAsync(appId, versionId, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Gets all prebuilt intent and entity model information used in a version of
            /// this application.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='appId'>
            /// The application ID.
            /// </param>
            /// <param name='versionId'>
            /// The version ID.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<IList<CustomPrebuiltModel>> ListCustomPrebuiltModelsAsync(this IModel operations, System.Guid appId, string versionId, CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.ListCustomPrebuiltModelsWithHttpMessagesAsync(appId, versionId, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Deletes a prebuilt domain's models in a version of the application.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='appId'>
            /// The application ID.
            /// </param>
            /// <param name='versionId'>
            /// The version ID.
            /// </param>
            /// <param name='domainName'>
            /// Domain name.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<OperationStatus> DeleteCustomPrebuiltDomainAsync(this IModel operations, System.Guid appId, string versionId, string domainName, CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.DeleteCustomPrebuiltDomainWithHttpMessagesAsync(appId, versionId, domainName, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Creates a single child in an existing entity model hierarchy in a version
            /// of the application.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='appId'>
            /// The application ID.
            /// </param>
            /// <param name='versionId'>
            /// The version ID.
            /// </param>
            /// <param name='entityId'>
            /// The entity extractor ID.
            /// </param>
            /// <param name='childEntityModelCreateObject'>
            /// A model object containing the name of the new child model and its children.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<System.Guid> AddEntityChildAsync(this IModel operations, System.Guid appId, string versionId, System.Guid entityId, ChildEntityModelCreateObject childEntityModelCreateObject, CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.AddEntityChildWithHttpMessagesAsync(appId, versionId, entityId, childEntityModelCreateObject, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Gets information about the child's model contained in an hierarchical
            /// entity child model in a version of the application.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='appId'>
            /// The application ID.
            /// </param>
            /// <param name='versionId'>
            /// The version ID.
            /// </param>
            /// <param name='hEntityId'>
            /// The hierarchical entity extractor ID.
            /// </param>
            /// <param name='hChildId'>
            /// The hierarchical entity extractor child ID.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<HierarchicalChildEntity> GetHierarchicalEntityChildAsync(this IModel operations, System.Guid appId, string versionId, System.Guid hEntityId, System.Guid hChildId, CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.GetHierarchicalEntityChildWithHttpMessagesAsync(appId, versionId, hEntityId, hChildId, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Renames a single child in an existing hierarchical entity model in a
            /// version of the application.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='appId'>
            /// The application ID.
            /// </param>
            /// <param name='versionId'>
            /// The version ID.
            /// </param>
            /// <param name='hEntityId'>
            /// The hierarchical entity extractor ID.
            /// </param>
            /// <param name='hChildId'>
            /// The hierarchical entity extractor child ID.
            /// </param>
            /// <param name='hierarchicalChildModelUpdateObject'>
            /// Model object containing new name of the hierarchical entity child.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<OperationStatus> UpdateHierarchicalEntityChildAsync(this IModel operations, System.Guid appId, string versionId, System.Guid hEntityId, System.Guid hChildId, HierarchicalChildModelUpdateObject hierarchicalChildModelUpdateObject, CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.UpdateHierarchicalEntityChildWithHttpMessagesAsync(appId, versionId, hEntityId, hChildId, hierarchicalChildModelUpdateObject, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Deletes a hierarchical entity extractor child in a version of the
            /// application.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='appId'>
            /// The application ID.
            /// </param>
            /// <param name='versionId'>
            /// The version ID.
            /// </param>
            /// <param name='hEntityId'>
            /// The hierarchical entity extractor ID.
            /// </param>
            /// <param name='hChildId'>
            /// The hierarchical entity extractor child ID.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<OperationStatus> DeleteHierarchicalEntityChildAsync(this IModel operations, System.Guid appId, string versionId, System.Guid hEntityId, System.Guid hChildId, CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.DeleteHierarchicalEntityChildWithHttpMessagesAsync(appId, versionId, hEntityId, hChildId, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Creates a single child in an existing composite entity model in a version
            /// of the application.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='appId'>
            /// The application ID.
            /// </param>
            /// <param name='versionId'>
            /// The version ID.
            /// </param>
            /// <param name='cEntityId'>
            /// The composite entity extractor ID.
            /// </param>
            /// <param name='compositeChildModelCreateObject'>
            /// A model object containing the name of the new composite child model.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<System.Guid> AddCompositeEntityChildAsync(this IModel operations, System.Guid appId, string versionId, System.Guid cEntityId, CompositeChildModelCreateObject compositeChildModelCreateObject, CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.AddCompositeEntityChildWithHttpMessagesAsync(appId, versionId, cEntityId, compositeChildModelCreateObject, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Deletes a composite entity extractor child from a version of the
            /// application.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='appId'>
            /// The application ID.
            /// </param>
            /// <param name='versionId'>
            /// The version ID.
            /// </param>
            /// <param name='cEntityId'>
            /// The composite entity extractor ID.
            /// </param>
            /// <param name='cChildId'>
            /// The hierarchical entity extractor child ID.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<OperationStatus> DeleteCompositeEntityChildAsync(this IModel operations, System.Guid appId, string versionId, System.Guid cEntityId, System.Guid cChildId, CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.DeleteCompositeEntityChildWithHttpMessagesAsync(appId, versionId, cEntityId, cChildId, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Gets information about the regular expression entity models in a version of
            /// the application.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='appId'>
            /// The application ID.
            /// </param>
            /// <param name='versionId'>
            /// The version ID.
            /// </param>
            /// <param name='skip'>
            /// The number of entries to skip. Default value is 0.
            /// </param>
            /// <param name='take'>
            /// The number of entries to return. Maximum page size is 500. Default is 100.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<IList<RegexEntityExtractor>> ListRegexEntityInfosAsync(this IModel operations, System.Guid appId, string versionId, int? skip = 0, int? take = 100, CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.ListRegexEntityInfosWithHttpMessagesAsync(appId, versionId, skip, take, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Adds a regular expression entity model to a version of the application.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='appId'>
            /// The application ID.
            /// </param>
            /// <param name='versionId'>
            /// The version ID.
            /// </param>
            /// <param name='regexEntityExtractorCreateObj'>
            /// A model object containing the name and regex pattern for the new regular
            /// expression entity extractor.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<System.Guid> CreateRegexEntityModelAsync(this IModel operations, System.Guid appId, string versionId, RegexModelCreateObject regexEntityExtractorCreateObj, CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.CreateRegexEntityModelWithHttpMessagesAsync(appId, versionId, regexEntityExtractorCreateObj, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Get information about the Pattern.Any entity models in a version of the
            /// application.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='appId'>
            /// The application ID.
            /// </param>
            /// <param name='versionId'>
            /// The version ID.
            /// </param>
            /// <param name='skip'>
            /// The number of entries to skip. Default value is 0.
            /// </param>
            /// <param name='take'>
            /// The number of entries to return. Maximum page size is 500. Default is 100.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<IList<PatternAnyEntityExtractor>> ListPatternAnyEntityInfosAsync(this IModel operations, System.Guid appId, string versionId, int? skip = 0, int? take = 100, CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.ListPatternAnyEntityInfosWithHttpMessagesAsync(appId, versionId, skip, take, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Adds a pattern.any entity extractor to a version of the application.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='appId'>
            /// The application ID.
            /// </param>
            /// <param name='versionId'>
            /// The version ID.
            /// </param>
            /// <param name='extractorCreateObject'>
            /// A model object containing the name and explicit list for the new
            /// Pattern.Any entity extractor.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<System.Guid> CreatePatternAnyEntityModelAsync(this IModel operations, System.Guid appId, string versionId, PatternAnyModelCreateObject extractorCreateObject, CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.CreatePatternAnyEntityModelWithHttpMessagesAsync(appId, versionId, extractorCreateObject, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Get all roles for an entity in a version of the application
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='appId'>
            /// The application ID.
            /// </param>
            /// <param name='versionId'>
            /// The version ID.
            /// </param>
            /// <param name='entityId'>
            /// entity Id
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<IList<EntityRole>> ListEntityRolesAsync(this IModel operations, System.Guid appId, string versionId, System.Guid entityId, CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.ListEntityRolesWithHttpMessagesAsync(appId, versionId, entityId, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Create an entity role in a version of the application.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='appId'>
            /// The application ID.
            /// </param>
            /// <param name='versionId'>
            /// The version ID.
            /// </param>
            /// <param name='entityId'>
            /// The entity model ID.
            /// </param>
            /// <param name='entityRoleCreateObject'>
            /// An entity role object containing the name of role.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<System.Guid> CreateEntityRoleAsync(this IModel operations, System.Guid appId, string versionId, System.Guid entityId, EntityRoleCreateObject entityRoleCreateObject, CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.CreateEntityRoleWithHttpMessagesAsync(appId, versionId, entityId, entityRoleCreateObject, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Get a prebuilt entity's roles in a version of the application.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='appId'>
            /// The application ID.
            /// </param>
            /// <param name='versionId'>
            /// The version ID.
            /// </param>
            /// <param name='entityId'>
            /// entity Id
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<IList<EntityRole>> ListPrebuiltEntityRolesAsync(this IModel operations, System.Guid appId, string versionId, System.Guid entityId, CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.ListPrebuiltEntityRolesWithHttpMessagesAsync(appId, versionId, entityId, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Create a role for a prebuilt entity in a version of the application.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='appId'>
            /// The application ID.
            /// </param>
            /// <param name='versionId'>
            /// The version ID.
            /// </param>
            /// <param name='entityId'>
            /// The entity model ID.
            /// </param>
            /// <param name='entityRoleCreateObject'>
            /// An entity role object containing the name of role.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<System.Guid> CreatePrebuiltEntityRoleAsync(this IModel operations, System.Guid appId, string versionId, System.Guid entityId, EntityRoleCreateObject entityRoleCreateObject, CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.CreatePrebuiltEntityRoleWithHttpMessagesAsync(appId, versionId, entityId, entityRoleCreateObject, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Get all roles for a list entity in a version of the application.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='appId'>
            /// The application ID.
            /// </param>
            /// <param name='versionId'>
            /// The version ID.
            /// </param>
            /// <param name='entityId'>
            /// entity Id
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<IList<EntityRole>> ListClosedListEntityRolesAsync(this IModel operations, System.Guid appId, string versionId, System.Guid entityId, CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.ListClosedListEntityRolesWithHttpMessagesAsync(appId, versionId, entityId, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Create a role for a list entity in a version of the application.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='appId'>
            /// The application ID.
            /// </param>
            /// <param name='versionId'>
            /// The version ID.
            /// </param>
            /// <param name='entityId'>
            /// The entity model ID.
            /// </param>
            /// <param name='entityRoleCreateObject'>
            /// An entity role object containing the name of role.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<System.Guid> CreateClosedListEntityRoleAsync(this IModel operations, System.Guid appId, string versionId, System.Guid entityId, EntityRoleCreateObject entityRoleCreateObject, CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.CreateClosedListEntityRoleWithHttpMessagesAsync(appId, versionId, entityId, entityRoleCreateObject, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Get all roles for a regular expression entity in a version of the
            /// application.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='appId'>
            /// The application ID.
            /// </param>
            /// <param name='versionId'>
            /// The version ID.
            /// </param>
            /// <param name='entityId'>
            /// entity Id
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<IList<EntityRole>> ListRegexEntityRolesAsync(this IModel operations, System.Guid appId, string versionId, System.Guid entityId, CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.ListRegexEntityRolesWithHttpMessagesAsync(appId, versionId, entityId, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Create a role for an regular expression entity in a version of the
            /// application.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='appId'>
            /// The application ID.
            /// </param>
            /// <param name='versionId'>
            /// The version ID.
            /// </param>
            /// <param name='entityId'>
            /// The entity model ID.
            /// </param>
            /// <param name='entityRoleCreateObject'>
            /// An entity role object containing the name of role.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<System.Guid> CreateRegexEntityRoleAsync(this IModel operations, System.Guid appId, string versionId, System.Guid entityId, EntityRoleCreateObject entityRoleCreateObject, CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.CreateRegexEntityRoleWithHttpMessagesAsync(appId, versionId, entityId, entityRoleCreateObject, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Get all roles for a composite entity in a version of the application
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='appId'>
            /// The application ID.
            /// </param>
            /// <param name='versionId'>
            /// The version ID.
            /// </param>
            /// <param name='cEntityId'>
            /// The composite entity extractor ID.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<IList<EntityRole>> ListCompositeEntityRolesAsync(this IModel operations, System.Guid appId, string versionId, System.Guid cEntityId, CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.ListCompositeEntityRolesWithHttpMessagesAsync(appId, versionId, cEntityId, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Create a role for a composite entity in a version of the application.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='appId'>
            /// The application ID.
            /// </param>
            /// <param name='versionId'>
            /// The version ID.
            /// </param>
            /// <param name='cEntityId'>
            /// The composite entity extractor ID.
            /// </param>
            /// <param name='entityRoleCreateObject'>
            /// An entity role object containing the name of role.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<System.Guid> CreateCompositeEntityRoleAsync(this IModel operations, System.Guid appId, string versionId, System.Guid cEntityId, EntityRoleCreateObject entityRoleCreateObject, CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.CreateCompositeEntityRoleWithHttpMessagesAsync(appId, versionId, cEntityId, entityRoleCreateObject, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Get all roles for a Pattern.any entity in a version of the application
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='appId'>
            /// The application ID.
            /// </param>
            /// <param name='versionId'>
            /// The version ID.
            /// </param>
            /// <param name='entityId'>
            /// entity Id
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<IList<EntityRole>> ListPatternAnyEntityRolesAsync(this IModel operations, System.Guid appId, string versionId, System.Guid entityId, CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.ListPatternAnyEntityRolesWithHttpMessagesAsync(appId, versionId, entityId, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Create a role for an Pattern.any entity in a version of the application.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='appId'>
            /// The application ID.
            /// </param>
            /// <param name='versionId'>
            /// The version ID.
            /// </param>
            /// <param name='entityId'>
            /// The entity model ID.
            /// </param>
            /// <param name='entityRoleCreateObject'>
            /// An entity role object containing the name of role.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<System.Guid> CreatePatternAnyEntityRoleAsync(this IModel operations, System.Guid appId, string versionId, System.Guid entityId, EntityRoleCreateObject entityRoleCreateObject, CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.CreatePatternAnyEntityRoleWithHttpMessagesAsync(appId, versionId, entityId, entityRoleCreateObject, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Get all roles for a hierarchical entity in a version of the application
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='appId'>
            /// The application ID.
            /// </param>
            /// <param name='versionId'>
            /// The version ID.
            /// </param>
            /// <param name='hEntityId'>
            /// The hierarchical entity extractor ID.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<IList<EntityRole>> ListHierarchicalEntityRolesAsync(this IModel operations, System.Guid appId, string versionId, System.Guid hEntityId, CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.ListHierarchicalEntityRolesWithHttpMessagesAsync(appId, versionId, hEntityId, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Create a role for an hierarchical entity in a version of the application.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='appId'>
            /// The application ID.
            /// </param>
            /// <param name='versionId'>
            /// The version ID.
            /// </param>
            /// <param name='hEntityId'>
            /// The hierarchical entity extractor ID.
            /// </param>
            /// <param name='entityRoleCreateObject'>
            /// An entity role object containing the name of role.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<System.Guid> CreateHierarchicalEntityRoleAsync(this IModel operations, System.Guid appId, string versionId, System.Guid hEntityId, EntityRoleCreateObject entityRoleCreateObject, CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.CreateHierarchicalEntityRoleWithHttpMessagesAsync(appId, versionId, hEntityId, entityRoleCreateObject, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Get all roles for a prebuilt entity in a version of the application
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='appId'>
            /// The application ID.
            /// </param>
            /// <param name='versionId'>
            /// The version ID.
            /// </param>
            /// <param name='entityId'>
            /// entity Id
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<IList<EntityRole>> ListCustomPrebuiltEntityRolesAsync(this IModel operations, System.Guid appId, string versionId, System.Guid entityId, CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.ListCustomPrebuiltEntityRolesWithHttpMessagesAsync(appId, versionId, entityId, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Create a role for a prebuilt entity in a version of the application.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='appId'>
            /// The application ID.
            /// </param>
            /// <param name='versionId'>
            /// The version ID.
            /// </param>
            /// <param name='entityId'>
            /// The entity model ID.
            /// </param>
            /// <param name='entityRoleCreateObject'>
            /// An entity role object containing the name of role.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<System.Guid> CreateCustomPrebuiltEntityRoleAsync(this IModel operations, System.Guid appId, string versionId, System.Guid entityId, EntityRoleCreateObject entityRoleCreateObject, CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.CreateCustomPrebuiltEntityRoleWithHttpMessagesAsync(appId, versionId, entityId, entityRoleCreateObject, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Get the explicit (exception) list of the pattern.any entity in a version of
            /// the application.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='appId'>
            /// The application ID.
            /// </param>
            /// <param name='versionId'>
            /// The version ID.
            /// </param>
            /// <param name='entityId'>
            /// The Pattern.Any entity id.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<IList<ExplicitListItem>> GetExplicitListAsync(this IModel operations, System.Guid appId, string versionId, System.Guid entityId, CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.GetExplicitListWithHttpMessagesAsync(appId, versionId, entityId, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Add a new exception to the explicit list for the Pattern.Any entity in a
            /// version of the application.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='appId'>
            /// The application ID.
            /// </param>
            /// <param name='versionId'>
            /// The version ID.
            /// </param>
            /// <param name='entityId'>
            /// The Pattern.Any entity extractor ID.
            /// </param>
            /// <param name='item'>
            /// The new explicit list item.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<int?> AddExplicitListItemAsync(this IModel operations, System.Guid appId, string versionId, System.Guid entityId, ExplicitListItemCreateObject item, CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.AddExplicitListItemWithHttpMessagesAsync(appId, versionId, entityId, item, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Gets information about a regular expression entity in a version of the
            /// application.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='appId'>
            /// The application ID.
            /// </param>
            /// <param name='versionId'>
            /// The version ID.
            /// </param>
            /// <param name='regexEntityId'>
            /// The regular expression entity model ID.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<RegexEntityExtractor> GetRegexEntityEntityInfoAsync(this IModel operations, System.Guid appId, string versionId, System.Guid regexEntityId, CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.GetRegexEntityEntityInfoWithHttpMessagesAsync(appId, versionId, regexEntityId, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Updates the regular expression entity in a version of the application.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='appId'>
            /// The application ID.
            /// </param>
            /// <param name='versionId'>
            /// The version ID.
            /// </param>
            /// <param name='regexEntityId'>
            /// The regular expression entity extractor ID.
            /// </param>
            /// <param name='regexEntityUpdateObject'>
            /// An object containing the new entity name and regex pattern.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<OperationStatus> UpdateRegexEntityModelAsync(this IModel operations, System.Guid appId, string versionId, System.Guid regexEntityId, RegexModelUpdateObject regexEntityUpdateObject, CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.UpdateRegexEntityModelWithHttpMessagesAsync(appId, versionId, regexEntityId, regexEntityUpdateObject, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Deletes a regular expression entity from a version of the application.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='appId'>
            /// The application ID.
            /// </param>
            /// <param name='versionId'>
            /// The version ID.
            /// </param>
            /// <param name='regexEntityId'>
            /// The regular expression entity extractor ID.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<OperationStatus> DeleteRegexEntityModelAsync(this IModel operations, System.Guid appId, string versionId, System.Guid regexEntityId, CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.DeleteRegexEntityModelWithHttpMessagesAsync(appId, versionId, regexEntityId, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Gets information about the Pattern.Any model in a version of the
            /// application.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='appId'>
            /// The application ID.
            /// </param>
            /// <param name='versionId'>
            /// The version ID.
            /// </param>
            /// <param name='entityId'>
            /// The entity extractor ID.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<PatternAnyEntityExtractor> GetPatternAnyEntityInfoAsync(this IModel operations, System.Guid appId, string versionId, System.Guid entityId, CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.GetPatternAnyEntityInfoWithHttpMessagesAsync(appId, versionId, entityId, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Updates the name and explicit (exception) list of a Pattern.Any entity
            /// model in a version of the application.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='appId'>
            /// The application ID.
            /// </param>
            /// <param name='versionId'>
            /// The version ID.
            /// </param>
            /// <param name='entityId'>
            /// The Pattern.Any entity extractor ID.
            /// </param>
            /// <param name='patternAnyUpdateObject'>
            /// An object containing the explicit list of the Pattern.Any entity.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<OperationStatus> UpdatePatternAnyEntityModelAsync(this IModel operations, System.Guid appId, string versionId, System.Guid entityId, PatternAnyModelUpdateObject patternAnyUpdateObject, CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.UpdatePatternAnyEntityModelWithHttpMessagesAsync(appId, versionId, entityId, patternAnyUpdateObject, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Deletes a Pattern.Any entity extractor from a version of the application.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='appId'>
            /// The application ID.
            /// </param>
            /// <param name='versionId'>
            /// The version ID.
            /// </param>
            /// <param name='entityId'>
            /// The Pattern.Any entity extractor ID.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<OperationStatus> DeletePatternAnyEntityModelAsync(this IModel operations, System.Guid appId, string versionId, System.Guid entityId, CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.DeletePatternAnyEntityModelWithHttpMessagesAsync(appId, versionId, entityId, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Get one role for a given entity in a version of the application
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='appId'>
            /// The application ID.
            /// </param>
            /// <param name='versionId'>
            /// The version ID.
            /// </param>
            /// <param name='entityId'>
            /// entity ID.
            /// </param>
            /// <param name='roleId'>
            /// entity role ID.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<EntityRole> GetEntityRoleAsync(this IModel operations, System.Guid appId, string versionId, System.Guid entityId, System.Guid roleId, CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.GetEntityRoleWithHttpMessagesAsync(appId, versionId, entityId, roleId, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Update a role for a given entity in a version of the application.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='appId'>
            /// The application ID.
            /// </param>
            /// <param name='versionId'>
            /// The version ID.
            /// </param>
            /// <param name='entityId'>
            /// The entity ID.
            /// </param>
            /// <param name='roleId'>
            /// The entity role ID.
            /// </param>
            /// <param name='entityRoleUpdateObject'>
            /// The new entity role.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<OperationStatus> UpdateEntityRoleAsync(this IModel operations, System.Guid appId, string versionId, System.Guid entityId, System.Guid roleId, EntityRoleUpdateObject entityRoleUpdateObject, CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.UpdateEntityRoleWithHttpMessagesAsync(appId, versionId, entityId, roleId, entityRoleUpdateObject, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Delete an entity role in a version of the application.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='appId'>
            /// The application ID.
            /// </param>
            /// <param name='versionId'>
            /// The version ID.
            /// </param>
            /// <param name='entityId'>
            /// The entity ID.
            /// </param>
            /// <param name='roleId'>
            /// The entity role Id.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<OperationStatus> DeleteEntityRoleAsync(this IModel operations, System.Guid appId, string versionId, System.Guid entityId, System.Guid roleId, CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.DeleteEntityRoleWithHttpMessagesAsync(appId, versionId, entityId, roleId, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Get one role for a given prebuilt entity in a version of the application
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='appId'>
            /// The application ID.
            /// </param>
            /// <param name='versionId'>
            /// The version ID.
            /// </param>
            /// <param name='entityId'>
            /// entity ID.
            /// </param>
            /// <param name='roleId'>
            /// entity role ID.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<EntityRole> GetPrebuiltEntityRoleAsync(this IModel operations, System.Guid appId, string versionId, System.Guid entityId, System.Guid roleId, CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.GetPrebuiltEntityRoleWithHttpMessagesAsync(appId, versionId, entityId, roleId, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Update a role for a given prebuilt entity in a version of the application
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='appId'>
            /// The application ID.
            /// </param>
            /// <param name='versionId'>
            /// The version ID.
            /// </param>
            /// <param name='entityId'>
            /// The entity ID.
            /// </param>
            /// <param name='roleId'>
            /// The entity role ID.
            /// </param>
            /// <param name='entityRoleUpdateObject'>
            /// The new entity role.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<OperationStatus> UpdatePrebuiltEntityRoleAsync(this IModel operations, System.Guid appId, string versionId, System.Guid entityId, System.Guid roleId, EntityRoleUpdateObject entityRoleUpdateObject, CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.UpdatePrebuiltEntityRoleWithHttpMessagesAsync(appId, versionId, entityId, roleId, entityRoleUpdateObject, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Delete a role in a prebuilt entity in a version of the application.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='appId'>
            /// The application ID.
            /// </param>
            /// <param name='versionId'>
            /// The version ID.
            /// </param>
            /// <param name='entityId'>
            /// The entity ID.
            /// </param>
            /// <param name='roleId'>
            /// The entity role Id.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<OperationStatus> DeletePrebuiltEntityRoleAsync(this IModel operations, System.Guid appId, string versionId, System.Guid entityId, System.Guid roleId, CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.DeletePrebuiltEntityRoleWithHttpMessagesAsync(appId, versionId, entityId, roleId, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Get one role for a given list entity in a version of the application.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='appId'>
            /// The application ID.
            /// </param>
            /// <param name='versionId'>
            /// The version ID.
            /// </param>
            /// <param name='entityId'>
            /// entity ID.
            /// </param>
            /// <param name='roleId'>
            /// entity role ID.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<EntityRole> GetClosedListEntityRoleAsync(this IModel operations, System.Guid appId, string versionId, System.Guid entityId, System.Guid roleId, CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.GetClosedListEntityRoleWithHttpMessagesAsync(appId, versionId, entityId, roleId, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Update a role for a given list entity in a version of the application.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='appId'>
            /// The application ID.
            /// </param>
            /// <param name='versionId'>
            /// The version ID.
            /// </param>
            /// <param name='entityId'>
            /// The entity ID.
            /// </param>
            /// <param name='roleId'>
            /// The entity role ID.
            /// </param>
            /// <param name='entityRoleUpdateObject'>
            /// The new entity role.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<OperationStatus> UpdateClosedListEntityRoleAsync(this IModel operations, System.Guid appId, string versionId, System.Guid entityId, System.Guid roleId, EntityRoleUpdateObject entityRoleUpdateObject, CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.UpdateClosedListEntityRoleWithHttpMessagesAsync(appId, versionId, entityId, roleId, entityRoleUpdateObject, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Delete a role for a given list entity in a version of the application.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='appId'>
            /// The application ID.
            /// </param>
            /// <param name='versionId'>
            /// The version ID.
            /// </param>
            /// <param name='entityId'>
            /// The entity ID.
            /// </param>
            /// <param name='roleId'>
            /// The entity role Id.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<OperationStatus> DeleteClosedListEntityRoleAsync(this IModel operations, System.Guid appId, string versionId, System.Guid entityId, System.Guid roleId, CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.DeleteClosedListEntityRoleWithHttpMessagesAsync(appId, versionId, entityId, roleId, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Get one role for a given regular expression entity in a version of the
            /// application.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='appId'>
            /// The application ID.
            /// </param>
            /// <param name='versionId'>
            /// The version ID.
            /// </param>
            /// <param name='entityId'>
            /// entity ID.
            /// </param>
            /// <param name='roleId'>
            /// entity role ID.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<EntityRole> GetRegexEntityRoleAsync(this IModel operations, System.Guid appId, string versionId, System.Guid entityId, System.Guid roleId, CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.GetRegexEntityRoleWithHttpMessagesAsync(appId, versionId, entityId, roleId, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Update a role for a given regular expression entity in a version of the
            /// application
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='appId'>
            /// The application ID.
            /// </param>
            /// <param name='versionId'>
            /// The version ID.
            /// </param>
            /// <param name='entityId'>
            /// The entity ID.
            /// </param>
            /// <param name='roleId'>
            /// The entity role ID.
            /// </param>
            /// <param name='entityRoleUpdateObject'>
            /// The new entity role.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<OperationStatus> UpdateRegexEntityRoleAsync(this IModel operations, System.Guid appId, string versionId, System.Guid entityId, System.Guid roleId, EntityRoleUpdateObject entityRoleUpdateObject, CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.UpdateRegexEntityRoleWithHttpMessagesAsync(appId, versionId, entityId, roleId, entityRoleUpdateObject, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Delete a role for a given regular expression in a version of the
            /// application.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='appId'>
            /// The application ID.
            /// </param>
            /// <param name='versionId'>
            /// The version ID.
            /// </param>
            /// <param name='entityId'>
            /// The entity ID.
            /// </param>
            /// <param name='roleId'>
            /// The entity role Id.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<OperationStatus> DeleteRegexEntityRoleAsync(this IModel operations, System.Guid appId, string versionId, System.Guid entityId, System.Guid roleId, CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.DeleteRegexEntityRoleWithHttpMessagesAsync(appId, versionId, entityId, roleId, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Get one role for a given composite entity in a version of the application
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='appId'>
            /// The application ID.
            /// </param>
            /// <param name='versionId'>
            /// The version ID.
            /// </param>
            /// <param name='cEntityId'>
            /// The composite entity extractor ID.
            /// </param>
            /// <param name='roleId'>
            /// entity role ID.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<EntityRole> GetCompositeEntityRoleAsync(this IModel operations, System.Guid appId, string versionId, System.Guid cEntityId, System.Guid roleId, CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.GetCompositeEntityRoleWithHttpMessagesAsync(appId, versionId, cEntityId, roleId, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Update a role for a given composite entity in a version of the application
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='appId'>
            /// The application ID.
            /// </param>
            /// <param name='versionId'>
            /// The version ID.
            /// </param>
            /// <param name='cEntityId'>
            /// The composite entity extractor ID.
            /// </param>
            /// <param name='roleId'>
            /// The entity role ID.
            /// </param>
            /// <param name='entityRoleUpdateObject'>
            /// The new entity role.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<OperationStatus> UpdateCompositeEntityRoleAsync(this IModel operations, System.Guid appId, string versionId, System.Guid cEntityId, System.Guid roleId, EntityRoleUpdateObject entityRoleUpdateObject, CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.UpdateCompositeEntityRoleWithHttpMessagesAsync(appId, versionId, cEntityId, roleId, entityRoleUpdateObject, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Delete a role for a given composite entity in a version of the application.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='appId'>
            /// The application ID.
            /// </param>
            /// <param name='versionId'>
            /// The version ID.
            /// </param>
            /// <param name='cEntityId'>
            /// The composite entity extractor ID.
            /// </param>
            /// <param name='roleId'>
            /// The entity role Id.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<OperationStatus> DeleteCompositeEntityRoleAsync(this IModel operations, System.Guid appId, string versionId, System.Guid cEntityId, System.Guid roleId, CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.DeleteCompositeEntityRoleWithHttpMessagesAsync(appId, versionId, cEntityId, roleId, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Get one role for a given Pattern.any entity in a version of the
            /// application.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='appId'>
            /// The application ID.
            /// </param>
            /// <param name='versionId'>
            /// The version ID.
            /// </param>
            /// <param name='entityId'>
            /// entity ID.
            /// </param>
            /// <param name='roleId'>
            /// entity role ID.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<EntityRole> GetPatternAnyEntityRoleAsync(this IModel operations, System.Guid appId, string versionId, System.Guid entityId, System.Guid roleId, CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.GetPatternAnyEntityRoleWithHttpMessagesAsync(appId, versionId, entityId, roleId, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Update a role for a given Pattern.any entity in a version of the
            /// application.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='appId'>
            /// The application ID.
            /// </param>
            /// <param name='versionId'>
            /// The version ID.
            /// </param>
            /// <param name='entityId'>
            /// The entity ID.
            /// </param>
            /// <param name='roleId'>
            /// The entity role ID.
            /// </param>
            /// <param name='entityRoleUpdateObject'>
            /// The new entity role.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<OperationStatus> UpdatePatternAnyEntityRoleAsync(this IModel operations, System.Guid appId, string versionId, System.Guid entityId, System.Guid roleId, EntityRoleUpdateObject entityRoleUpdateObject, CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.UpdatePatternAnyEntityRoleWithHttpMessagesAsync(appId, versionId, entityId, roleId, entityRoleUpdateObject, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Delete a role for a given Pattern.any entity in a version of the
            /// application.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='appId'>
            /// The application ID.
            /// </param>
            /// <param name='versionId'>
            /// The version ID.
            /// </param>
            /// <param name='entityId'>
            /// The entity ID.
            /// </param>
            /// <param name='roleId'>
            /// The entity role Id.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<OperationStatus> DeletePatternAnyEntityRoleAsync(this IModel operations, System.Guid appId, string versionId, System.Guid entityId, System.Guid roleId, CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.DeletePatternAnyEntityRoleWithHttpMessagesAsync(appId, versionId, entityId, roleId, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Get one role for a given hierarchical entity in a version of the
            /// application.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='appId'>
            /// The application ID.
            /// </param>
            /// <param name='versionId'>
            /// The version ID.
            /// </param>
            /// <param name='hEntityId'>
            /// The hierarchical entity extractor ID.
            /// </param>
            /// <param name='roleId'>
            /// entity role ID.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<EntityRole> GetHierarchicalEntityRoleAsync(this IModel operations, System.Guid appId, string versionId, System.Guid hEntityId, System.Guid roleId, CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.GetHierarchicalEntityRoleWithHttpMessagesAsync(appId, versionId, hEntityId, roleId, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Update a role for a given hierarchical entity in a version of the
            /// application.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='appId'>
            /// The application ID.
            /// </param>
            /// <param name='versionId'>
            /// The version ID.
            /// </param>
            /// <param name='hEntityId'>
            /// The hierarchical entity extractor ID.
            /// </param>
            /// <param name='roleId'>
            /// The entity role ID.
            /// </param>
            /// <param name='entityRoleUpdateObject'>
            /// The new entity role.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<OperationStatus> UpdateHierarchicalEntityRoleAsync(this IModel operations, System.Guid appId, string versionId, System.Guid hEntityId, System.Guid roleId, EntityRoleUpdateObject entityRoleUpdateObject, CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.UpdateHierarchicalEntityRoleWithHttpMessagesAsync(appId, versionId, hEntityId, roleId, entityRoleUpdateObject, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Delete a role for a given hierarchical role in a version of the
            /// application.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='appId'>
            /// The application ID.
            /// </param>
            /// <param name='versionId'>
            /// The version ID.
            /// </param>
            /// <param name='hEntityId'>
            /// The hierarchical entity extractor ID.
            /// </param>
            /// <param name='roleId'>
            /// The entity role Id.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<OperationStatus> DeleteHierarchicalEntityRoleAsync(this IModel operations, System.Guid appId, string versionId, System.Guid hEntityId, System.Guid roleId, CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.DeleteHierarchicalEntityRoleWithHttpMessagesAsync(appId, versionId, hEntityId, roleId, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Get one role for a given prebuilt entity in a version of the application.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='appId'>
            /// The application ID.
            /// </param>
            /// <param name='versionId'>
            /// The version ID.
            /// </param>
            /// <param name='entityId'>
            /// entity ID.
            /// </param>
            /// <param name='roleId'>
            /// entity role ID.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<EntityRole> GetCustomEntityRoleAsync(this IModel operations, System.Guid appId, string versionId, System.Guid entityId, System.Guid roleId, CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.GetCustomEntityRoleWithHttpMessagesAsync(appId, versionId, entityId, roleId, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Update a role for a given prebuilt entity in a version of the application.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='appId'>
            /// The application ID.
            /// </param>
            /// <param name='versionId'>
            /// The version ID.
            /// </param>
            /// <param name='entityId'>
            /// The entity ID.
            /// </param>
            /// <param name='roleId'>
            /// The entity role ID.
            /// </param>
            /// <param name='entityRoleUpdateObject'>
            /// The new entity role.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<OperationStatus> UpdateCustomPrebuiltEntityRoleAsync(this IModel operations, System.Guid appId, string versionId, System.Guid entityId, System.Guid roleId, EntityRoleUpdateObject entityRoleUpdateObject, CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.UpdateCustomPrebuiltEntityRoleWithHttpMessagesAsync(appId, versionId, entityId, roleId, entityRoleUpdateObject, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Delete a role for a given prebuilt entity in a version of the application.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='appId'>
            /// The application ID.
            /// </param>
            /// <param name='versionId'>
            /// The version ID.
            /// </param>
            /// <param name='entityId'>
            /// The entity ID.
            /// </param>
            /// <param name='roleId'>
            /// The entity role Id.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<OperationStatus> DeleteCustomEntityRoleAsync(this IModel operations, System.Guid appId, string versionId, System.Guid entityId, System.Guid roleId, CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.DeleteCustomEntityRoleWithHttpMessagesAsync(appId, versionId, entityId, roleId, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Get the explicit (exception) list of the pattern.any entity in a version of
            /// the application.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='appId'>
            /// The application ID.
            /// </param>
            /// <param name='versionId'>
            /// The version ID.
            /// </param>
            /// <param name='entityId'>
            /// The Pattern.Any entity Id.
            /// </param>
            /// <param name='itemId'>
            /// The explicit list item Id.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<ExplicitListItem> GetExplicitListItemAsync(this IModel operations, System.Guid appId, string versionId, System.Guid entityId, long itemId, CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.GetExplicitListItemWithHttpMessagesAsync(appId, versionId, entityId, itemId, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Updates an explicit (exception) list item for a Pattern.Any entity in a
            /// version of the application.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='appId'>
            /// The application ID.
            /// </param>
            /// <param name='versionId'>
            /// The version ID.
            /// </param>
            /// <param name='entityId'>
            /// The Pattern.Any entity extractor ID.
            /// </param>
            /// <param name='itemId'>
            /// The explicit list item ID.
            /// </param>
            /// <param name='item'>
            /// The new explicit list item.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<OperationStatus> UpdateExplicitListItemAsync(this IModel operations, System.Guid appId, string versionId, System.Guid entityId, long itemId, ExplicitListItemUpdateObject item, CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.UpdateExplicitListItemWithHttpMessagesAsync(appId, versionId, entityId, itemId, item, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Delete an item from the explicit (exception) list for a Pattern.any entity
            /// in a version of the application.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='appId'>
            /// The application ID.
            /// </param>
            /// <param name='versionId'>
            /// The version ID.
            /// </param>
            /// <param name='entityId'>
            /// The pattern.any entity id.
            /// </param>
            /// <param name='itemId'>
            /// The explicit list item which will be deleted.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<OperationStatus> DeleteExplicitListItemAsync(this IModel operations, System.Guid appId, string versionId, System.Guid entityId, long itemId, CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.DeleteExplicitListItemWithHttpMessagesAsync(appId, versionId, entityId, itemId, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

    }
}
