// <auto-generated>
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for
// license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.
// </auto-generated>

namespace Microsoft.Azure.CognitiveServices.Knowledge.QnAMaker.Models
{
    using Microsoft.Rest;
    using Newtonsoft.Json;
    using System.Linq;

    /// <summary>
    /// PATCH Body schema for Update Qna List
    /// </summary>
    public partial class UpdateQnaDTO
    {
        /// <summary>
        /// Initializes a new instance of the UpdateQnaDTO class.
        /// </summary>
        public UpdateQnaDTO()
        {
            CustomInit();
        }

        /// <summary>
        /// Initializes a new instance of the UpdateQnaDTO class.
        /// </summary>
        /// <param name="id">Unique id for the Q-A</param>
        /// <param name="answer">Answer text</param>
        /// <param name="source">Source from which Q-A was indexed. eg.
        /// https://docs.microsoft.com/en-us/azure/cognitive-services/QnAMaker/FAQs</param>
        /// <param name="questions">List of questions associated with the
        /// answer.</param>
        /// <param name="metadata">List of metadata associated with the answer
        /// to be updated</param>
        /// <param name="context">Context associated with Qna to be
        /// updated.</param>
        public UpdateQnaDTO(int? id = default(int?), string answer = default(string), string source = default(string), UpdateQnaDTOQuestions questions = default(UpdateQnaDTOQuestions), UpdateQnaDTOMetadata metadata = default(UpdateQnaDTOMetadata), UpdateQnaDTOContext context = default(UpdateQnaDTOContext))
        {
            Id = id;
            Answer = answer;
            Source = source;
            Questions = questions;
            Metadata = metadata;
            Context = context;
            CustomInit();
        }

        /// <summary>
        /// An initialization method that performs custom operations like setting defaults
        /// </summary>
        partial void CustomInit();

        /// <summary>
        /// Gets or sets unique id for the Q-A
        /// </summary>
        [JsonProperty(PropertyName = "id")]
        public int? Id { get; set; }

        /// <summary>
        /// Gets or sets answer text
        /// </summary>
        [JsonProperty(PropertyName = "answer")]
        public string Answer { get; set; }

        /// <summary>
        /// Gets or sets source from which Q-A was indexed. eg.
        /// https://docs.microsoft.com/en-us/azure/cognitive-services/QnAMaker/FAQs
        /// </summary>
        [JsonProperty(PropertyName = "source")]
        public string Source { get; set; }

        /// <summary>
        /// Gets or sets list of questions associated with the answer.
        /// </summary>
        [JsonProperty(PropertyName = "questions")]
        public UpdateQnaDTOQuestions Questions { get; set; }

        /// <summary>
        /// Gets or sets list of metadata associated with the answer to be
        /// updated
        /// </summary>
        [JsonProperty(PropertyName = "metadata")]
        public UpdateQnaDTOMetadata Metadata { get; set; }

        /// <summary>
        /// Gets or sets context associated with Qna to be updated.
        /// </summary>
        [JsonProperty(PropertyName = "context")]
        public UpdateQnaDTOContext Context { get; set; }

        /// <summary>
        /// Validate the object.
        /// </summary>
        /// <exception cref="ValidationException">
        /// Thrown if validation fails
        /// </exception>
        public virtual void Validate()
        {
            if (Id > 2147483647)
            {
                throw new ValidationException(ValidationRules.InclusiveMaximum, "Id", 2147483647);
            }
            if (Id < 0)
            {
                throw new ValidationException(ValidationRules.InclusiveMinimum, "Id", 0);
            }
            if (Source != null)
            {
                if (Source.Length > 300)
                {
                    throw new ValidationException(ValidationRules.MaxLength, "Source", 300);
                }
            }
        }
    }
}
