// <auto-generated>
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for
// license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.
// </auto-generated>

namespace Microsoft.Azure.CognitiveServices.Knowledge.QnAMaker.Models
{
    using Microsoft.Rest;
    using Newtonsoft.Json;
    using System.Linq;

    /// <summary>
    /// Contains list of QnAs to be updated
    /// </summary>
    public partial class UpdateKbOperationDTO
    {
        /// <summary>
        /// Initializes a new instance of the UpdateKbOperationDTO class.
        /// </summary>
        public UpdateKbOperationDTO()
        {
            CustomInit();
        }

        /// <summary>
        /// Initializes a new instance of the UpdateKbOperationDTO class.
        /// </summary>
        /// <param name="add">An instance of CreateKbInputDTO for add
        /// operation</param>
        /// <param name="delete">An instance of DeleteKbContentsDTO for delete
        /// Operation</param>
        /// <param name="update">An instance of UpdateKbContentsDTO for Update
        /// Operation</param>
        /// <param name="enableHierarchicalExtraction">Enable hierarchical
        /// extraction of Q-A from files and urls. The value set during KB
        /// creation will be used if this field is not present.</param>
        /// <param name="defaultAnswerUsedForExtraction">Text string to be used
        /// as the answer in any Q-A which has no extracted answer from the
        /// document but has a hierarchy. Required when
        /// EnableHierarchicalExtraction field is set to True.</param>
        public UpdateKbOperationDTO(UpdateKbOperationDTOAdd add = default(UpdateKbOperationDTOAdd), UpdateKbOperationDTODelete delete = default(UpdateKbOperationDTODelete), UpdateKbOperationDTOUpdate update = default(UpdateKbOperationDTOUpdate), bool? enableHierarchicalExtraction = default(bool?), string defaultAnswerUsedForExtraction = default(string))
        {
            Add = add;
            Delete = delete;
            Update = update;
            EnableHierarchicalExtraction = enableHierarchicalExtraction;
            DefaultAnswerUsedForExtraction = defaultAnswerUsedForExtraction;
            CustomInit();
        }

        /// <summary>
        /// An initialization method that performs custom operations like setting defaults
        /// </summary>
        partial void CustomInit();

        /// <summary>
        /// Gets or sets an instance of CreateKbInputDTO for add operation
        /// </summary>
        [JsonProperty(PropertyName = "add")]
        public UpdateKbOperationDTOAdd Add { get; set; }

        /// <summary>
        /// Gets or sets an instance of DeleteKbContentsDTO for delete
        /// Operation
        /// </summary>
        [JsonProperty(PropertyName = "delete")]
        public UpdateKbOperationDTODelete Delete { get; set; }

        /// <summary>
        /// Gets or sets an instance of UpdateKbContentsDTO for Update
        /// Operation
        /// </summary>
        [JsonProperty(PropertyName = "update")]
        public UpdateKbOperationDTOUpdate Update { get; set; }

        /// <summary>
        /// Gets or sets enable hierarchical extraction of Q-A from files and
        /// urls. The value set during KB creation will be used if this field
        /// is not present.
        /// </summary>
        [JsonProperty(PropertyName = "enableHierarchicalExtraction")]
        public bool? EnableHierarchicalExtraction { get; set; }

        /// <summary>
        /// Gets or sets text string to be used as the answer in any Q-A which
        /// has no extracted answer from the document but has a hierarchy.
        /// Required when EnableHierarchicalExtraction field is set to True.
        /// </summary>
        [JsonProperty(PropertyName = "defaultAnswerUsedForExtraction")]
        public string DefaultAnswerUsedForExtraction { get; set; }

        /// <summary>
        /// Validate the object.
        /// </summary>
        /// <exception cref="ValidationException">
        /// Thrown if validation fails
        /// </exception>
        public virtual void Validate()
        {
            if (Update != null)
            {
                Update.Validate();
            }
            if (DefaultAnswerUsedForExtraction != null)
            {
                if (DefaultAnswerUsedForExtraction.Length > 300)
                {
                    throw new ValidationException(ValidationRules.MaxLength, "DefaultAnswerUsedForExtraction", 300);
                }
                if (DefaultAnswerUsedForExtraction.Length < 1)
                {
                    throw new ValidationException(ValidationRules.MinLength, "DefaultAnswerUsedForExtraction", 1);
                }
            }
        }
    }
}
