// <auto-generated>
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for
// license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.
// </auto-generated>

namespace Microsoft.Azure.CognitiveServices.Knowledge.QnAMaker.Models
{
    using Microsoft.Rest;
    using Newtonsoft.Json;
    using System.Collections;
    using System.Collections.Generic;
    using System.Linq;

    /// <summary>
    /// Post body schema for Replace KB operation.
    /// </summary>
    public partial class ReplaceKbDTO
    {
        /// <summary>
        /// Initializes a new instance of the ReplaceKbDTO class.
        /// </summary>
        public ReplaceKbDTO()
        {
            CustomInit();
        }

        /// <summary>
        /// Initializes a new instance of the ReplaceKbDTO class.
        /// </summary>
        /// <param name="qnAList">List of Q-A (QnADTO) to be added to the
        /// knowledgebase. Q-A Ids are assigned by the service and should be
        /// omitted.</param>
        public ReplaceKbDTO(IList<QnADTO> qnAList)
        {
            QnAList = qnAList;
            CustomInit();
        }

        /// <summary>
        /// An initialization method that performs custom operations like setting defaults
        /// </summary>
        partial void CustomInit();

        /// <summary>
        /// Gets or sets list of Q-A (QnADTO) to be added to the knowledgebase.
        /// Q-A Ids are assigned by the service and should be omitted.
        /// </summary>
        [JsonProperty(PropertyName = "qnAList")]
        public IList<QnADTO> QnAList { get; set; }

        /// <summary>
        /// Validate the object.
        /// </summary>
        /// <exception cref="ValidationException">
        /// Thrown if validation fails
        /// </exception>
        public virtual void Validate()
        {
            if (QnAList == null)
            {
                throw new ValidationException(ValidationRules.CannotBeNull, "QnAList");
            }
            if (QnAList != null)
            {
                foreach (var element in QnAList)
                {
                    if (element != null)
                    {
                        element.Validate();
                    }
                }
            }
        }
    }
}
