// <auto-generated>
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for
// license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.
// </auto-generated>

namespace Microsoft.Azure.CognitiveServices.Knowledge.QnAMaker.Models
{
    using Newtonsoft.Json;
    using System.Collections;
    using System.Collections.Generic;
    using System.Linq;

    /// <summary>
    /// Represents Search Result.
    /// </summary>
    public partial class QnASearchResult
    {
        /// <summary>
        /// Initializes a new instance of the QnASearchResult class.
        /// </summary>
        public QnASearchResult()
        {
            CustomInit();
        }

        /// <summary>
        /// Initializes a new instance of the QnASearchResult class.
        /// </summary>
        /// <param name="questions">List of questions.</param>
        /// <param name="answer">Answer.</param>
        /// <param name="score">Search result score.</param>
        /// <param name="id">Id of the QnA result.</param>
        /// <param name="source">Source of QnA result.</param>
        /// <param name="metadata">List of metadata.</param>
        /// <param name="context">Context object of the QnA</param>
        /// <param name="answerSpan">Answer span object of QnA with respect to
        /// user's question.</param>
        public QnASearchResult(IList<string> questions = default(IList<string>), string answer = default(string), double? score = default(double?), int? id = default(int?), string source = default(string), IList<MetadataDTO> metadata = default(IList<MetadataDTO>), QnASearchResultContext context = default(QnASearchResultContext), QnASearchResultAnswerSpan answerSpan = default(QnASearchResultAnswerSpan))
        {
            Questions = questions;
            Answer = answer;
            Score = score;
            Id = id;
            Source = source;
            Metadata = metadata;
            Context = context;
            AnswerSpan = answerSpan;
            CustomInit();
        }

        /// <summary>
        /// An initialization method that performs custom operations like setting defaults
        /// </summary>
        partial void CustomInit();

        /// <summary>
        /// Gets or sets list of questions.
        /// </summary>
        [JsonProperty(PropertyName = "questions")]
        public IList<string> Questions { get; set; }

        /// <summary>
        /// Gets or sets answer.
        /// </summary>
        [JsonProperty(PropertyName = "answer")]
        public string Answer { get; set; }

        /// <summary>
        /// Gets or sets search result score.
        /// </summary>
        [JsonProperty(PropertyName = "score")]
        public double? Score { get; set; }

        /// <summary>
        /// Gets or sets id of the QnA result.
        /// </summary>
        [JsonProperty(PropertyName = "id")]
        public int? Id { get; set; }

        /// <summary>
        /// Gets or sets source of QnA result.
        /// </summary>
        [JsonProperty(PropertyName = "source")]
        public string Source { get; set; }

        /// <summary>
        /// Gets or sets list of metadata.
        /// </summary>
        [JsonProperty(PropertyName = "metadata")]
        public IList<MetadataDTO> Metadata { get; set; }

        /// <summary>
        /// Gets or sets context object of the QnA
        /// </summary>
        [JsonProperty(PropertyName = "context")]
        public QnASearchResultContext Context { get; set; }

        /// <summary>
        /// Gets or sets answer span object of QnA with respect to user's
        /// question.
        /// </summary>
        [JsonProperty(PropertyName = "answerSpan")]
        public QnASearchResultAnswerSpan AnswerSpan { get; set; }

    }
}
