// <auto-generated>
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for
// license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.
// </auto-generated>

namespace Microsoft.Azure.CognitiveServices.Knowledge.QnAMaker.Models
{
    using Microsoft.Rest;
    using Newtonsoft.Json;
    using System.Linq;

    /// <summary>
    /// DTO to hold details of uploaded files.
    /// </summary>
    public partial class FileDTO
    {
        /// <summary>
        /// Initializes a new instance of the FileDTO class.
        /// </summary>
        public FileDTO()
        {
            CustomInit();
        }

        /// <summary>
        /// Initializes a new instance of the FileDTO class.
        /// </summary>
        /// <param name="fileName">File name. Supported file types are ".tsv",
        /// ".pdf", ".txt", ".docx", ".xlsx".</param>
        /// <param name="fileUri">Public URI of the file.</param>
        public FileDTO(string fileName, string fileUri)
        {
            FileName = fileName;
            FileUri = fileUri;
            CustomInit();
        }

        /// <summary>
        /// An initialization method that performs custom operations like setting defaults
        /// </summary>
        partial void CustomInit();

        /// <summary>
        /// Gets or sets file name. Supported file types are ".tsv", ".pdf",
        /// ".txt", ".docx", ".xlsx".
        /// </summary>
        [JsonProperty(PropertyName = "fileName")]
        public string FileName { get; set; }

        /// <summary>
        /// Gets or sets public URI of the file.
        /// </summary>
        [JsonProperty(PropertyName = "fileUri")]
        public string FileUri { get; set; }

        /// <summary>
        /// Validate the object.
        /// </summary>
        /// <exception cref="ValidationException">
        /// Thrown if validation fails
        /// </exception>
        public virtual void Validate()
        {
            if (FileName == null)
            {
                throw new ValidationException(ValidationRules.CannotBeNull, "FileName");
            }
            if (FileUri == null)
            {
                throw new ValidationException(ValidationRules.CannotBeNull, "FileUri");
            }
            if (FileName != null)
            {
                if (FileName.Length > 200)
                {
                    throw new ValidationException(ValidationRules.MaxLength, "FileName", 200);
                }
                if (FileName.Length < 1)
                {
                    throw new ValidationException(ValidationRules.MinLength, "FileName", 1);
                }
            }
        }
    }
}
