// <auto-generated>
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for
// license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.
// </auto-generated>

namespace Microsoft.Azure.CognitiveServices.Knowledge.QnAMaker.Models
{
    using Microsoft.Rest;
    using Newtonsoft.Json;
    using System.Collections;
    using System.Collections.Generic;
    using System.Linq;

    /// <summary>
    /// Post body schema for CreateKb operation.
    /// </summary>
    public partial class CreateKbDTO
    {
        /// <summary>
        /// Initializes a new instance of the CreateKbDTO class.
        /// </summary>
        public CreateKbDTO()
        {
            CustomInit();
        }

        /// <summary>
        /// Initializes a new instance of the CreateKbDTO class.
        /// </summary>
        /// <param name="name">Friendly name for the knowledgebase.</param>
        /// <param name="qnaList">List of Q-A (QnADTO) to be added to the
        /// knowledgebase. Q-A Ids are assigned by the service and should be
        /// omitted.</param>
        /// <param name="urls">List of URLs to be used for extracting
        /// Q-A.</param>
        /// <param name="files">List of files from which to Extract
        /// Q-A.</param>
        /// <param name="enableHierarchicalExtraction">Enable hierarchical
        /// extraction of Q-A from files and urls. Value to be considered False
        /// if this field is not present.</param>
        /// <param name="defaultAnswerUsedForExtraction">Text string to be used
        /// as the answer in any Q-A which has no extracted answer from the
        /// document but has a hierarchy. Required when
        /// EnableHierarchicalExtraction field is set to True.</param>
        /// <param name="language">Language of the knowledgebase. Please find
        /// the list of supported languages &lt;a
        /// href="https://aka.ms/qnamaker-languages#languages-supported"
        /// target="_blank"&gt;here&lt;/a&gt;.</param>
        /// <param name="enableMultipleLanguages">Set to true to enable
        /// creating KBs in different languages for the same resource.</param>
        /// <param name="defaultAnswer">Default answer sent to user if no good
        /// match is found in the KB.</param>
        public CreateKbDTO(string name, IList<QnADTO> qnaList = default(IList<QnADTO>), IList<string> urls = default(IList<string>), IList<FileDTO> files = default(IList<FileDTO>), bool? enableHierarchicalExtraction = default(bool?), string defaultAnswerUsedForExtraction = default(string), string language = default(string), bool? enableMultipleLanguages = default(bool?), string defaultAnswer = default(string))
        {
            Name = name;
            QnaList = qnaList;
            Urls = urls;
            Files = files;
            EnableHierarchicalExtraction = enableHierarchicalExtraction;
            DefaultAnswerUsedForExtraction = defaultAnswerUsedForExtraction;
            Language = language;
            EnableMultipleLanguages = enableMultipleLanguages;
            DefaultAnswer = defaultAnswer;
            CustomInit();
        }

        /// <summary>
        /// An initialization method that performs custom operations like setting defaults
        /// </summary>
        partial void CustomInit();

        /// <summary>
        /// Gets or sets friendly name for the knowledgebase.
        /// </summary>
        [JsonProperty(PropertyName = "name")]
        public string Name { get; set; }

        /// <summary>
        /// Gets or sets list of Q-A (QnADTO) to be added to the knowledgebase.
        /// Q-A Ids are assigned by the service and should be omitted.
        /// </summary>
        [JsonProperty(PropertyName = "qnaList")]
        public IList<QnADTO> QnaList { get; set; }

        /// <summary>
        /// Gets or sets list of URLs to be used for extracting Q-A.
        /// </summary>
        [JsonProperty(PropertyName = "urls")]
        public IList<string> Urls { get; set; }

        /// <summary>
        /// Gets or sets list of files from which to Extract Q-A.
        /// </summary>
        [JsonProperty(PropertyName = "files")]
        public IList<FileDTO> Files { get; set; }

        /// <summary>
        /// Gets or sets enable hierarchical extraction of Q-A from files and
        /// urls. Value to be considered False if this field is not present.
        /// </summary>
        [JsonProperty(PropertyName = "enableHierarchicalExtraction")]
        public bool? EnableHierarchicalExtraction { get; set; }

        /// <summary>
        /// Gets or sets text string to be used as the answer in any Q-A which
        /// has no extracted answer from the document but has a hierarchy.
        /// Required when EnableHierarchicalExtraction field is set to True.
        /// </summary>
        [JsonProperty(PropertyName = "defaultAnswerUsedForExtraction")]
        public string DefaultAnswerUsedForExtraction { get; set; }

        /// <summary>
        /// Gets or sets language of the knowledgebase. Please find the list of
        /// supported languages &amp;lt;a
        /// href="https://aka.ms/qnamaker-languages#languages-supported"
        /// target="_blank"&amp;gt;here&amp;lt;/a&amp;gt;.
        /// </summary>
        [JsonProperty(PropertyName = "language")]
        public string Language { get; set; }

        /// <summary>
        /// Gets or sets set to true to enable creating KBs in different
        /// languages for the same resource.
        /// </summary>
        [JsonProperty(PropertyName = "enableMultipleLanguages")]
        public bool? EnableMultipleLanguages { get; set; }

        /// <summary>
        /// Gets or sets default answer sent to user if no good match is found
        /// in the KB.
        /// </summary>
        [JsonProperty(PropertyName = "defaultAnswer")]
        public string DefaultAnswer { get; set; }

        /// <summary>
        /// Validate the object.
        /// </summary>
        /// <exception cref="ValidationException">
        /// Thrown if validation fails
        /// </exception>
        public virtual void Validate()
        {
            if (Name == null)
            {
                throw new ValidationException(ValidationRules.CannotBeNull, "Name");
            }
            if (Name != null)
            {
                if (Name.Length > 100)
                {
                    throw new ValidationException(ValidationRules.MaxLength, "Name", 100);
                }
                if (Name.Length < 1)
                {
                    throw new ValidationException(ValidationRules.MinLength, "Name", 1);
                }
            }
            if (QnaList != null)
            {
                foreach (var element in QnaList)
                {
                    if (element != null)
                    {
                        element.Validate();
                    }
                }
            }
            if (Files != null)
            {
                foreach (var element1 in Files)
                {
                    if (element1 != null)
                    {
                        element1.Validate();
                    }
                }
            }
            if (DefaultAnswerUsedForExtraction != null)
            {
                if (DefaultAnswerUsedForExtraction.Length > 300)
                {
                    throw new ValidationException(ValidationRules.MaxLength, "DefaultAnswerUsedForExtraction", 300);
                }
                if (DefaultAnswerUsedForExtraction.Length < 1)
                {
                    throw new ValidationException(ValidationRules.MinLength, "DefaultAnswerUsedForExtraction", 1);
                }
            }
            if (Language != null)
            {
                if (Language.Length > 100)
                {
                    throw new ValidationException(ValidationRules.MaxLength, "Language", 100);
                }
                if (Language.Length < 1)
                {
                    throw new ValidationException(ValidationRules.MinLength, "Language", 1);
                }
            }
            if (DefaultAnswer != null)
            {
                if (DefaultAnswer.Length > 300)
                {
                    throw new ValidationException(ValidationRules.MaxLength, "DefaultAnswer", 300);
                }
                if (DefaultAnswer.Length < 1)
                {
                    throw new ValidationException(ValidationRules.MinLength, "DefaultAnswer", 1);
                }
            }
        }
    }
}
