// <auto-generated>
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for
// license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.
// </auto-generated>

namespace Microsoft.Azure.CognitiveServices.Knowledge.QnAMaker.Models
{
    using Microsoft.Rest;
    using Newtonsoft.Json;
    using System.Collections;
    using System.Collections.Generic;
    using System.Linq;

    /// <summary>
    /// Context associated with Qna.
    /// </summary>
    public partial class ContextDTO
    {
        /// <summary>
        /// Initializes a new instance of the ContextDTO class.
        /// </summary>
        public ContextDTO()
        {
            CustomInit();
        }

        /// <summary>
        /// Initializes a new instance of the ContextDTO class.
        /// </summary>
        /// <param name="isContextOnly">To mark if a prompt is relevant only
        /// with a previous question or not.
        /// true - Do not include this QnA as search result for queries without
        /// context
        /// false - ignores context and includes this QnA in search
        /// result</param>
        /// <param name="prompts">List of prompts associated with the
        /// answer.</param>
        public ContextDTO(bool? isContextOnly = default(bool?), IList<PromptDTO> prompts = default(IList<PromptDTO>))
        {
            IsContextOnly = isContextOnly;
            Prompts = prompts;
            CustomInit();
        }

        /// <summary>
        /// An initialization method that performs custom operations like setting defaults
        /// </summary>
        partial void CustomInit();

        /// <summary>
        /// Gets or sets to mark if a prompt is relevant only with a previous
        /// question or not.
        /// true - Do not include this QnA as search result for queries without
        /// context
        /// false - ignores context and includes this QnA in search result
        /// </summary>
        [JsonProperty(PropertyName = "isContextOnly")]
        public bool? IsContextOnly { get; set; }

        /// <summary>
        /// Gets or sets list of prompts associated with the answer.
        /// </summary>
        [JsonProperty(PropertyName = "prompts")]
        public IList<PromptDTO> Prompts { get; set; }

        /// <summary>
        /// Validate the object.
        /// </summary>
        /// <exception cref="ValidationException">
        /// Thrown if validation fails
        /// </exception>
        public virtual void Validate()
        {
            if (Prompts != null)
            {
                if (Prompts.Count > 20)
                {
                    throw new ValidationException(ValidationRules.MaxItems, "Prompts", 20);
                }
                foreach (var element in Prompts)
                {
                    if (element != null)
                    {
                        element.Validate();
                    }
                }
            }
        }
    }
}
