// <auto-generated>
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for
// license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.
// </auto-generated>

namespace Microsoft.Azure.CognitiveServices.Knowledge.QnAMaker
{
    using Models;
    using System.Threading;
    using System.Threading.Tasks;

    /// <summary>
    /// Extension methods for Knowledgebase.
    /// </summary>
    public static partial class KnowledgebaseExtensions
    {
            /// <summary>
            /// Gets all knowledgebases for a user.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<KnowledgebasesDTO> ListAllAsync(this IKnowledgebase operations, CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.ListAllWithHttpMessagesAsync(null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Gets details of a specific knowledgebase.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='kbId'>
            /// Knowledgebase id.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<KnowledgebaseDTO> GetDetailsAsync(this IKnowledgebase operations, string kbId, CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.GetDetailsWithHttpMessagesAsync(kbId, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Deletes the knowledgebase and all its data.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='kbId'>
            /// Knowledgebase id.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task DeleteAsync(this IKnowledgebase operations, string kbId, CancellationToken cancellationToken = default(CancellationToken))
            {
                (await operations.DeleteWithHttpMessagesAsync(kbId, null, cancellationToken).ConfigureAwait(false)).Dispose();
            }

            /// <summary>
            /// Publishes all changes in test index of a knowledgebase to its prod index.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='kbId'>
            /// Knowledgebase id.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task PublishAsync(this IKnowledgebase operations, string kbId, CancellationToken cancellationToken = default(CancellationToken))
            {
                (await operations.PublishWithHttpMessagesAsync(kbId, null, cancellationToken).ConfigureAwait(false)).Dispose();
            }

            /// <summary>
            /// Replace knowledgebase contents.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='kbId'>
            /// Knowledgebase id.
            /// </param>
            /// <param name='replaceKb'>
            /// An instance of ReplaceKbDTO which contains list of qnas to be uploaded
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task ReplaceAsync(this IKnowledgebase operations, string kbId, ReplaceKbDTO replaceKb, CancellationToken cancellationToken = default(CancellationToken))
            {
                (await operations.ReplaceWithHttpMessagesAsync(kbId, replaceKb, null, cancellationToken).ConfigureAwait(false)).Dispose();
            }

            /// <summary>
            /// Asynchronous operation to modify a knowledgebase.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='kbId'>
            /// Knowledgebase id.
            /// </param>
            /// <param name='updateKb'>
            /// Post body of the request.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<Operation> UpdateAsync(this IKnowledgebase operations, string kbId, UpdateKbOperationDTO updateKb, CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.UpdateWithHttpMessagesAsync(kbId, updateKb, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Asynchronous operation to create a new knowledgebase.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='createKbPayload'>
            /// Post body of the request.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<Operation> CreateAsync(this IKnowledgebase operations, CreateKbDTO createKbPayload, CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.CreateWithHttpMessagesAsync(createKbPayload, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Download the knowledgebase.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='kbId'>
            /// Knowledgebase id.
            /// </param>
            /// <param name='environment'>
            /// Specifies whether environment is Test or Prod. Possible values include:
            /// 'Prod', 'Test'
            /// </param>
            /// <param name='source'>
            /// The source property filter to apply.
            /// </param>
            /// <param name='changedSince'>
            /// The last changed status property filter to apply.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<QnADocumentsDTO> DownloadAsync(this IKnowledgebase operations, string kbId, string environment, string source = default(string), string changedSince = default(string), CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.DownloadWithHttpMessagesAsync(kbId, environment, source, changedSince, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// GenerateAnswer call to query knowledgebase (QnA Maker Managed).
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='kbId'>
            /// Knowledgebase id.
            /// </param>
            /// <param name='generateAnswerPayload'>
            /// Post body of the request.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<QnASearchResultList> GenerateAnswerAsync(this IKnowledgebase operations, string kbId, QueryDTO generateAnswerPayload, CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.GenerateAnswerWithHttpMessagesAsync(kbId, generateAnswerPayload, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Train call to add suggestions to knowledgebase (QnAMaker Managed).
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='kbId'>
            /// Knowledgebase id.
            /// </param>
            /// <param name='trainPayload'>
            /// Post body of the request.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task TrainAsync(this IKnowledgebase operations, string kbId, FeedbackRecordsDTO trainPayload, CancellationToken cancellationToken = default(CancellationToken))
            {
                (await operations.TrainWithHttpMessagesAsync(kbId, trainPayload, null, cancellationToken).ConfigureAwait(false)).Dispose();
            }

    }
}
