// <auto-generated>
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for
// license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.
// </auto-generated>

namespace Microsoft.Azure.CognitiveServices.Knowledge.QnAMaker
{
    using Models;
    using System.Threading;
    using System.Threading.Tasks;

    /// <summary>
    /// Extension methods for EndpointKeys.
    /// </summary>
    public static partial class EndpointKeysExtensions
    {
            /// <summary>
            /// Gets endpoint keys for an endpoint
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<EndpointKeysDTO> GetKeysAsync(this IEndpointKeys operations, CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.GetKeysWithHttpMessagesAsync(null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Re-generates an endpoint key.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='keyType'>
            /// Type of Key
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<EndpointKeysDTO> RefreshKeysAsync(this IEndpointKeys operations, string keyType, CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.RefreshKeysWithHttpMessagesAsync(keyType, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

    }
}
