// <auto-generated>
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for
// license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.
// </auto-generated>

namespace Microsoft.Azure.CognitiveServices.Knowledge.QnAMaker
{
    using Models;
    using System.Threading;
    using System.Threading.Tasks;

    /// <summary>
    /// Extension methods for Alterations.
    /// </summary>
    public static partial class AlterationsExtensions
    {
            /// <summary>
            /// Download alterations from runtime.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<WordAlterationsDTO> GetAsync(this IAlterations operations, CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.GetWithHttpMessagesAsync(null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Replace alterations data.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='wordAlterations'>
            /// New alterations data.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task ReplaceAsync(this IAlterations operations, WordAlterationsDTO wordAlterations, CancellationToken cancellationToken = default(CancellationToken))
            {
                (await operations.ReplaceWithHttpMessagesAsync(wordAlterations, null, cancellationToken).ConfigureAwait(false)).Dispose();
            }

            /// <summary>
            /// Download alterations per Knowledgebase (QnAMaker Managed).
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='kbId'>
            /// Knowledgebase id.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<WordAlterationsDTO> GetAlterationsForKbAsync(this IAlterations operations, string kbId, CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.GetAlterationsForKbWithHttpMessagesAsync(kbId, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Replace alterations data per Knowledgebase (QnAMaker Managed).
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='kbId'>
            /// Knowledgebase id.
            /// </param>
            /// <param name='wordAlterations'>
            /// New alterations data.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task ReplaceAlterationsForKbAsync(this IAlterations operations, string kbId, WordAlterationsDTO wordAlterations, CancellationToken cancellationToken = default(CancellationToken))
            {
                (await operations.ReplaceAlterationsForKbWithHttpMessagesAsync(kbId, wordAlterations, null, cancellationToken).ConfigureAwait(false)).Dispose();
            }

    }
}
