// <auto-generated>
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for
// license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.
// </auto-generated>

namespace Microsoft.Azure.CognitiveServices.FormRecognizer.Models
{
    using Newtonsoft.Json;
    using System.Collections;
    using System.Collections.Generic;
    using System.Linq;

    /// <summary>
    /// An object representing a recognized text line.
    /// </summary>
    public partial class Line
    {
        /// <summary>
        /// Initializes a new instance of the Line class.
        /// </summary>
        public Line()
        {
            CustomInit();
        }

        /// <summary>
        /// Initializes a new instance of the Line class.
        /// </summary>
        /// <param name="boundingBox">Bounding box of a recognized
        /// line.</param>
        /// <param name="text">The text content of the line.</param>
        /// <param name="words">List of words in the text line.</param>
        public Line(IList<int> boundingBox = default(IList<int>), string text = default(string), IList<Word> words = default(IList<Word>))
        {
            BoundingBox = boundingBox;
            Text = text;
            Words = words;
            CustomInit();
        }

        /// <summary>
        /// An initialization method that performs custom operations like setting defaults
        /// </summary>
        partial void CustomInit();

        /// <summary>
        /// Gets or sets bounding box of a recognized line.
        /// </summary>
        [JsonProperty(PropertyName = "boundingBox")]
        public IList<int> BoundingBox { get; set; }

        /// <summary>
        /// Gets or sets the text content of the line.
        /// </summary>
        [JsonProperty(PropertyName = "text")]
        public string Text { get; set; }

        /// <summary>
        /// Gets or sets list of words in the text line.
        /// </summary>
        [JsonProperty(PropertyName = "words")]
        public IList<Word> Words { get; set; }

    }
}
