// <auto-generated>
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for
// license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.
// </auto-generated>

namespace Microsoft.Azure.CognitiveServices.FormRecognizer.Models
{
    using Newtonsoft.Json;
    using System.Collections;
    using System.Collections.Generic;
    using System.Linq;

    public partial class FormDocumentReport
    {
        /// <summary>
        /// Initializes a new instance of the FormDocumentReport class.
        /// </summary>
        public FormDocumentReport()
        {
            CustomInit();
        }

        /// <summary>
        /// Initializes a new instance of the FormDocumentReport class.
        /// </summary>
        /// <param name="documentName">Reference to the data that the report is
        /// for.</param>
        /// <param name="pages">Total number of pages trained on.</param>
        /// <param name="errors">List of errors per page.</param>
        /// <param name="status">Status of the training operation. Possible
        /// values include: 'success', 'partialSuccess', 'failure'</param>
        public FormDocumentReport(string documentName = default(string), int? pages = default(int?), IList<string> errors = default(IList<string>), string status = default(string))
        {
            DocumentName = documentName;
            Pages = pages;
            Errors = errors;
            Status = status;
            CustomInit();
        }

        /// <summary>
        /// An initialization method that performs custom operations like setting defaults
        /// </summary>
        partial void CustomInit();

        /// <summary>
        /// Gets or sets reference to the data that the report is for.
        /// </summary>
        [JsonProperty(PropertyName = "documentName")]
        public string DocumentName { get; set; }

        /// <summary>
        /// Gets or sets total number of pages trained on.
        /// </summary>
        [JsonProperty(PropertyName = "pages")]
        public int? Pages { get; set; }

        /// <summary>
        /// Gets or sets list of errors per page.
        /// </summary>
        [JsonProperty(PropertyName = "errors")]
        public IList<string> Errors { get; set; }

        /// <summary>
        /// Gets or sets status of the training operation. Possible values
        /// include: 'success', 'partialSuccess', 'failure'
        /// </summary>
        [JsonProperty(PropertyName = "status")]
        public string Status { get; set; }

    }
}
