// <auto-generated>
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for
// license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.
// </auto-generated>

namespace Microsoft.Azure.CognitiveServices.FormRecognizer.Models
{
    using Newtonsoft.Json;
    using System.Collections;
    using System.Collections.Generic;
    using System.Linq;

    /// <summary>
    /// Canonical representation of single extracted text.
    /// </summary>
    public partial class ExtractedToken
    {
        /// <summary>
        /// Initializes a new instance of the ExtractedToken class.
        /// </summary>
        public ExtractedToken()
        {
            CustomInit();
        }

        /// <summary>
        /// Initializes a new instance of the ExtractedToken class.
        /// </summary>
        /// <param name="text">String value of the extracted text.</param>
        /// <param name="boundingBox">Bounding box of the extracted text.
        /// Represents the
        /// location of the extracted text as a pair of
        /// cartesian co-ordinates. The co-ordinate pairs are arranged by
        /// top-left, top-right, bottom-right and bottom-left endpoints box
        /// with origin reference from the bottom-left of the page.</param>
        /// <param name="confidence">A measure of accuracy of the extracted
        /// text.</param>
        public ExtractedToken(string text = default(string), IList<double?> boundingBox = default(IList<double?>), double? confidence = default(double?))
        {
            Text = text;
            BoundingBox = boundingBox;
            Confidence = confidence;
            CustomInit();
        }

        /// <summary>
        /// An initialization method that performs custom operations like setting defaults
        /// </summary>
        partial void CustomInit();

        /// <summary>
        /// Gets or sets string value of the extracted text.
        /// </summary>
        [JsonProperty(PropertyName = "text")]
        public string Text { get; set; }

        /// <summary>
        /// Gets or sets bounding box of the extracted text. Represents the
        /// location of the extracted text as a pair of
        /// cartesian co-ordinates. The co-ordinate pairs are arranged by
        /// top-left, top-right, bottom-right and bottom-left endpoints box
        /// with origin reference from the bottom-left of the page.
        /// </summary>
        [JsonProperty(PropertyName = "boundingBox")]
        public IList<double?> BoundingBox { get; set; }

        /// <summary>
        /// Gets or sets a measure of accuracy of the extracted text.
        /// </summary>
        [JsonProperty(PropertyName = "confidence")]
        public double? Confidence { get; set; }

    }
}
