// <auto-generated>
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for
// license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.
// </auto-generated>

namespace Microsoft.Azure.CognitiveServices.FormRecognizer.Models
{
    using Newtonsoft.Json;
    using System.Collections;
    using System.Collections.Generic;
    using System.Linq;

    /// <summary>
    /// Analyze API call result.
    /// </summary>
    public partial class AnalyzeResult
    {
        /// <summary>
        /// Initializes a new instance of the AnalyzeResult class.
        /// </summary>
        public AnalyzeResult()
        {
            CustomInit();
        }

        /// <summary>
        /// Initializes a new instance of the AnalyzeResult class.
        /// </summary>
        /// <param name="status">Status of the analyze operation. Possible
        /// values include: 'success', 'partialSuccess', 'failure'</param>
        /// <param name="pages">Page level information extracted in the
        /// analyzed
        /// document.</param>
        /// <param name="errors">List of errors reported during the analyze
        /// operation.</param>
        public AnalyzeResult(string status = default(string), IList<ExtractedPage> pages = default(IList<ExtractedPage>), IList<FormOperationError> errors = default(IList<FormOperationError>))
        {
            Status = status;
            Pages = pages;
            Errors = errors;
            CustomInit();
        }

        /// <summary>
        /// An initialization method that performs custom operations like setting defaults
        /// </summary>
        partial void CustomInit();

        /// <summary>
        /// Gets or sets status of the analyze operation. Possible values
        /// include: 'success', 'partialSuccess', 'failure'
        /// </summary>
        [JsonProperty(PropertyName = "status")]
        public string Status { get; set; }

        /// <summary>
        /// Gets or sets page level information extracted in the analyzed
        /// document.
        /// </summary>
        [JsonProperty(PropertyName = "pages")]
        public IList<ExtractedPage> Pages { get; set; }

        /// <summary>
        /// Gets or sets list of errors reported during the analyze
        /// operation.
        /// </summary>
        [JsonProperty(PropertyName = "errors")]
        public IList<FormOperationError> Errors { get; set; }

    }
}
