// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.CognitiveServices.Models
{
    /// <summary> Cognitive Services account quota usage status. </summary>
    public readonly partial struct ServiceAccountQuotaUsageStatus : IEquatable<ServiceAccountQuotaUsageStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ServiceAccountQuotaUsageStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ServiceAccountQuotaUsageStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string IncludedValue = "Included";
        private const string BlockedValue = "Blocked";
        private const string InOverageValue = "InOverage";
        private const string UnknownValue = "Unknown";

        /// <summary> Included. </summary>
        public static ServiceAccountQuotaUsageStatus Included { get; } = new ServiceAccountQuotaUsageStatus(IncludedValue);
        /// <summary> Blocked. </summary>
        public static ServiceAccountQuotaUsageStatus Blocked { get; } = new ServiceAccountQuotaUsageStatus(BlockedValue);
        /// <summary> InOverage. </summary>
        public static ServiceAccountQuotaUsageStatus InOverage { get; } = new ServiceAccountQuotaUsageStatus(InOverageValue);
        /// <summary> Unknown. </summary>
        public static ServiceAccountQuotaUsageStatus Unknown { get; } = new ServiceAccountQuotaUsageStatus(UnknownValue);
        /// <summary> Determines if two <see cref="ServiceAccountQuotaUsageStatus"/> values are the same. </summary>
        public static bool operator ==(ServiceAccountQuotaUsageStatus left, ServiceAccountQuotaUsageStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ServiceAccountQuotaUsageStatus"/> values are not the same. </summary>
        public static bool operator !=(ServiceAccountQuotaUsageStatus left, ServiceAccountQuotaUsageStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ServiceAccountQuotaUsageStatus"/>. </summary>
        public static implicit operator ServiceAccountQuotaUsageStatus(string value) => new ServiceAccountQuotaUsageStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ServiceAccountQuotaUsageStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ServiceAccountQuotaUsageStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
