// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.CognitiveServices.Models
{
    /// <summary> Whether or not public endpoint access is allowed for this account. </summary>
    public readonly partial struct ServiceAccountPublicNetworkAccess : IEquatable<ServiceAccountPublicNetworkAccess>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ServiceAccountPublicNetworkAccess"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ServiceAccountPublicNetworkAccess(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string EnabledValue = "Enabled";
        private const string DisabledValue = "Disabled";

        /// <summary> Enabled. </summary>
        public static ServiceAccountPublicNetworkAccess Enabled { get; } = new ServiceAccountPublicNetworkAccess(EnabledValue);
        /// <summary> Disabled. </summary>
        public static ServiceAccountPublicNetworkAccess Disabled { get; } = new ServiceAccountPublicNetworkAccess(DisabledValue);
        /// <summary> Determines if two <see cref="ServiceAccountPublicNetworkAccess"/> values are the same. </summary>
        public static bool operator ==(ServiceAccountPublicNetworkAccess left, ServiceAccountPublicNetworkAccess right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ServiceAccountPublicNetworkAccess"/> values are not the same. </summary>
        public static bool operator !=(ServiceAccountPublicNetworkAccess left, ServiceAccountPublicNetworkAccess right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ServiceAccountPublicNetworkAccess"/>. </summary>
        public static implicit operator ServiceAccountPublicNetworkAccess(string value) => new ServiceAccountPublicNetworkAccess(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ServiceAccountPublicNetworkAccess other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ServiceAccountPublicNetworkAccess other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
