// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.ResourceManager.CognitiveServices.Models
{
    internal static partial class ServiceAccountKeyNameExtensions
    {
        public static string ToSerialString(this ServiceAccountKeyName value) => value switch
        {
            ServiceAccountKeyName.Key1 => "Key1",
            ServiceAccountKeyName.Key2 => "Key2",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown ServiceAccountKeyName value.")
        };

        public static ServiceAccountKeyName ToServiceAccountKeyName(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Key1")) return ServiceAccountKeyName.Key1;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Key2")) return ServiceAccountKeyName.Key2;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown ServiceAccountKeyName value.");
        }
    }
}
