// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.CognitiveServices.Models
{
    /// <summary> Enumerates the possible value of keySource for Encryption. </summary>
    public readonly partial struct ServiceAccountEncryptionKeySource : IEquatable<ServiceAccountEncryptionKeySource>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ServiceAccountEncryptionKeySource"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ServiceAccountEncryptionKeySource(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string MicrosoftCognitiveServicesValue = "Microsoft.CognitiveServices";
        private const string MicrosoftKeyVaultValue = "Microsoft.KeyVault";

        /// <summary> Microsoft.CognitiveServices. </summary>
        public static ServiceAccountEncryptionKeySource MicrosoftCognitiveServices { get; } = new ServiceAccountEncryptionKeySource(MicrosoftCognitiveServicesValue);
        /// <summary> Microsoft.KeyVault. </summary>
        public static ServiceAccountEncryptionKeySource MicrosoftKeyVault { get; } = new ServiceAccountEncryptionKeySource(MicrosoftKeyVaultValue);
        /// <summary> Determines if two <see cref="ServiceAccountEncryptionKeySource"/> values are the same. </summary>
        public static bool operator ==(ServiceAccountEncryptionKeySource left, ServiceAccountEncryptionKeySource right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ServiceAccountEncryptionKeySource"/> values are not the same. </summary>
        public static bool operator !=(ServiceAccountEncryptionKeySource left, ServiceAccountEncryptionKeySource right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ServiceAccountEncryptionKeySource"/>. </summary>
        public static implicit operator ServiceAccountEncryptionKeySource(string value) => new ServiceAccountEncryptionKeySource(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ServiceAccountEncryptionKeySource other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ServiceAccountEncryptionKeySource other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
