// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.CognitiveServices.Models
{
    public partial class ServiceAccountApiProperties : IUtf8JsonSerializable, IJsonModel<ServiceAccountApiProperties>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<ServiceAccountApiProperties>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<ServiceAccountApiProperties>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ServiceAccountApiProperties>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ServiceAccountApiProperties)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(QnaRuntimeEndpoint))
            {
                writer.WritePropertyName("qnaRuntimeEndpoint"u8);
                writer.WriteStringValue(QnaRuntimeEndpoint);
            }
            if (Optional.IsDefined(QnaAzureSearchEndpointKey))
            {
                writer.WritePropertyName("qnaAzureSearchEndpointKey"u8);
                writer.WriteStringValue(QnaAzureSearchEndpointKey);
            }
            if (Optional.IsDefined(QnaAzureSearchEndpointId))
            {
                writer.WritePropertyName("qnaAzureSearchEndpointId"u8);
                writer.WriteStringValue(QnaAzureSearchEndpointId);
            }
            if (Optional.IsDefined(EnableStatistics))
            {
                writer.WritePropertyName("statisticsEnabled"u8);
                writer.WriteBooleanValue(EnableStatistics.Value);
            }
            if (Optional.IsDefined(EventHubConnectionString))
            {
                writer.WritePropertyName("eventHubConnectionString"u8);
                writer.WriteStringValue(EventHubConnectionString);
            }
            if (Optional.IsDefined(StorageAccountConnectionString))
            {
                writer.WritePropertyName("storageAccountConnectionString"u8);
                writer.WriteStringValue(StorageAccountConnectionString);
            }
            if (Optional.IsDefined(AadClientId))
            {
                writer.WritePropertyName("aadClientId"u8);
                writer.WriteStringValue(AadClientId.Value);
            }
            if (Optional.IsDefined(AadTenantId))
            {
                writer.WritePropertyName("aadTenantId"u8);
                writer.WriteStringValue(AadTenantId.Value);
            }
            if (Optional.IsDefined(SuperUser))
            {
                writer.WritePropertyName("superUser"u8);
                writer.WriteStringValue(SuperUser);
            }
            if (Optional.IsDefined(WebsiteName))
            {
                writer.WritePropertyName("websiteName"u8);
                writer.WriteStringValue(WebsiteName);
            }
            foreach (var item in AdditionalProperties)
            {
                writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                using (JsonDocument document = JsonDocument.Parse(item.Value))
                {
                    JsonSerializer.Serialize(writer, document.RootElement);
                }
#endif
            }
        }

        ServiceAccountApiProperties IJsonModel<ServiceAccountApiProperties>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ServiceAccountApiProperties>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ServiceAccountApiProperties)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeServiceAccountApiProperties(document.RootElement, options);
        }

        internal static ServiceAccountApiProperties DeserializeServiceAccountApiProperties(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string qnaRuntimeEndpoint = default;
            string qnaAzureSearchEndpointKey = default;
            ResourceIdentifier qnaAzureSearchEndpointId = default;
            bool? statisticsEnabled = default;
            string eventHubConnectionString = default;
            string storageAccountConnectionString = default;
            Guid? aadClientId = default;
            Guid? aadTenantId = default;
            string superUser = default;
            string websiteName = default;
            IDictionary<string, BinaryData> additionalProperties = default;
            Dictionary<string, BinaryData> additionalPropertiesDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("qnaRuntimeEndpoint"u8))
                {
                    qnaRuntimeEndpoint = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("qnaAzureSearchEndpointKey"u8))
                {
                    qnaAzureSearchEndpointKey = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("qnaAzureSearchEndpointId"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    qnaAzureSearchEndpointId = new ResourceIdentifier(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("statisticsEnabled"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    statisticsEnabled = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("eventHubConnectionString"u8))
                {
                    eventHubConnectionString = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("storageAccountConnectionString"u8))
                {
                    storageAccountConnectionString = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("aadClientId"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    aadClientId = property.Value.GetGuid();
                    continue;
                }
                if (property.NameEquals("aadTenantId"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    aadTenantId = property.Value.GetGuid();
                    continue;
                }
                if (property.NameEquals("superUser"u8))
                {
                    superUser = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("websiteName"u8))
                {
                    websiteName = property.Value.GetString();
                    continue;
                }
                additionalPropertiesDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
            }
            additionalProperties = additionalPropertiesDictionary;
            return new ServiceAccountApiProperties(
                qnaRuntimeEndpoint,
                qnaAzureSearchEndpointKey,
                qnaAzureSearchEndpointId,
                statisticsEnabled,
                eventHubConnectionString,
                storageAccountConnectionString,
                aadClientId,
                aadTenantId,
                superUser,
                websiteName,
                additionalProperties);
        }

        private BinaryData SerializeBicep(ModelReaderWriterOptions options)
        {
            StringBuilder builder = new StringBuilder();
            BicepModelReaderWriterOptions bicepOptions = options as BicepModelReaderWriterOptions;
            IDictionary<string, string> propertyOverrides = null;
            bool hasObjectOverride = bicepOptions != null && bicepOptions.PropertyOverrides.TryGetValue(this, out propertyOverrides);
            bool hasPropertyOverride = false;
            string propertyOverride = null;

            builder.AppendLine("{");

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(QnaRuntimeEndpoint), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  qnaRuntimeEndpoint: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(QnaRuntimeEndpoint))
                {
                    builder.Append("  qnaRuntimeEndpoint: ");
                    if (QnaRuntimeEndpoint.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{QnaRuntimeEndpoint}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{QnaRuntimeEndpoint}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(QnaAzureSearchEndpointKey), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  qnaAzureSearchEndpointKey: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(QnaAzureSearchEndpointKey))
                {
                    builder.Append("  qnaAzureSearchEndpointKey: ");
                    if (QnaAzureSearchEndpointKey.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{QnaAzureSearchEndpointKey}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{QnaAzureSearchEndpointKey}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(QnaAzureSearchEndpointId), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  qnaAzureSearchEndpointId: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(QnaAzureSearchEndpointId))
                {
                    builder.Append("  qnaAzureSearchEndpointId: ");
                    builder.AppendLine($"'{QnaAzureSearchEndpointId.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(EnableStatistics), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  statisticsEnabled: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(EnableStatistics))
                {
                    builder.Append("  statisticsEnabled: ");
                    var boolValue = EnableStatistics.Value == true ? "true" : "false";
                    builder.AppendLine($"{boolValue}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(EventHubConnectionString), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  eventHubConnectionString: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(EventHubConnectionString))
                {
                    builder.Append("  eventHubConnectionString: ");
                    if (EventHubConnectionString.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{EventHubConnectionString}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{EventHubConnectionString}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(StorageAccountConnectionString), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  storageAccountConnectionString: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(StorageAccountConnectionString))
                {
                    builder.Append("  storageAccountConnectionString: ");
                    if (StorageAccountConnectionString.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{StorageAccountConnectionString}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{StorageAccountConnectionString}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(AadClientId), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  aadClientId: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(AadClientId))
                {
                    builder.Append("  aadClientId: ");
                    builder.AppendLine($"'{AadClientId.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(AadTenantId), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  aadTenantId: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(AadTenantId))
                {
                    builder.Append("  aadTenantId: ");
                    builder.AppendLine($"'{AadTenantId.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(SuperUser), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  superUser: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(SuperUser))
                {
                    builder.Append("  superUser: ");
                    if (SuperUser.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{SuperUser}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{SuperUser}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(WebsiteName), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  websiteName: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(WebsiteName))
                {
                    builder.Append("  websiteName: ");
                    if (WebsiteName.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{WebsiteName}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{WebsiteName}'");
                    }
                }
            }

            builder.AppendLine("}");
            return BinaryData.FromString(builder.ToString());
        }

        BinaryData IPersistableModel<ServiceAccountApiProperties>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ServiceAccountApiProperties>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                case "bicep":
                    return SerializeBicep(options);
                default:
                    throw new FormatException($"The model {nameof(ServiceAccountApiProperties)} does not support writing '{options.Format}' format.");
            }
        }

        ServiceAccountApiProperties IPersistableModel<ServiceAccountApiProperties>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ServiceAccountApiProperties>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeServiceAccountApiProperties(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(ServiceAccountApiProperties)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<ServiceAccountApiProperties>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
